/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.io.Serializable;
import java.util.Date;
import javax.cache.CacheStatistics;
import net.sf.ehcache.jcache.JCache;
import net.sf.ehcache.statistics.LiveCacheStatistics;

public class JCacheStatistics
implements CacheStatistics,
Serializable {
    private final LiveCacheStatistics statistics;
    private final JCache cache;
    private Date dateFrom;

    public JCacheStatistics(JCache cache, LiveCacheStatistics statistics) {
        this.statistics = statistics;
        this.cache = cache;
    }

    public void clearStatistics() {
        this.statistics.clearStatistics();
        this.dateFrom = new Date();
    }

    public Date getStartAccumulationDate() {
        return this.dateFrom;
    }

    public long getCacheHits() {
        return this.statistics.getCacheHitCount();
    }

    public float getCacheHitPercentage() {
        if (this.statistics.getCacheHitCount() == 0L && this.statistics.getCacheMissCount() == 0L) {
            return Float.POSITIVE_INFINITY;
        }
        return this.statistics.getCacheHitCount() / (this.statistics.getCacheHitCount() + this.statistics.getCacheMissCount());
    }

    public long getCacheMisses() {
        return this.statistics.getCacheMissCount();
    }

    public float getCacheMissPercentage() {
        if (this.statistics.getCacheHitCount() == 0L && this.statistics.getCacheMissCount() == 0L) {
            return Float.POSITIVE_INFINITY;
        }
        return this.statistics.getCacheMissCount() / (this.statistics.getCacheHitCount() + this.statistics.getCacheMissCount());
    }

    public long getCacheGets() {
        return this.statistics.getCacheHitCount() + this.statistics.getCacheMissCount();
    }

    public long getCachePuts() {
        return this.statistics.getPutCount();
    }

    public long getCacheRemovals() {
        return this.statistics.getRemovedCount();
    }

    public long getCacheEvictions() {
        return this.statistics.getEvictedCount();
    }

    public float getAverageGetMillis() {
        return this.statistics.getAverageGetTimeMillis();
    }

    public float getAveragePutMillis() {
        throw new UnsupportedOperationException("getAveragePutMillis is not implemented in net.sf.ehcache.jcache.JCacheStatistics");
    }

    public float getAverageRemoveMillis() {
        throw new UnsupportedOperationException("getAverageRemoveMillis is not implemented in net.sf.ehcache.jcache.JCacheStatistics");
    }
}

