/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.snowflake.ingest.internal.apache.http.annotation.NotThreadSafe;
import net.snowflake.ingest.internal.apache.http.config.Registry;
import net.snowflake.ingest.internal.apache.http.util.Args;

@NotThreadSafe
public final class RegistryBuilder<I> {
    private final Map<String, I> items = new HashMap<String, I>();

    public static <I> RegistryBuilder<I> create() {
        return new RegistryBuilder<I>();
    }

    RegistryBuilder() {
    }

    public RegistryBuilder<I> register(String id, I item) {
        Args.notEmpty(id, "ID");
        Args.notNull(item, "Item");
        this.items.put(id.toLowerCase(Locale.ROOT), item);
        return this;
    }

    public Registry<I> build() {
        return new Registry<I>(this.items);
    }

    public String toString() {
        return this.items.toString();
    }
}

