/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.client;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.http.HttpEntity;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.StatusLine;
import net.snowflake.ingest.internal.apache.http.annotation.Immutable;
import net.snowflake.ingest.internal.apache.http.client.HttpResponseException;
import net.snowflake.ingest.internal.apache.http.client.ResponseHandler;
import net.snowflake.ingest.internal.apache.http.util.EntityUtils;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

