/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import net.snowflake.ingest.internal.apache.http.HttpConnection;
import net.snowflake.ingest.internal.apache.http.HttpException;
import net.snowflake.ingest.internal.apache.http.HttpHost;
import net.snowflake.ingest.internal.apache.http.HttpInetConnection;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpRequestInterceptor;
import net.snowflake.ingest.internal.apache.http.HttpVersion;
import net.snowflake.ingest.internal.apache.http.ProtocolException;
import net.snowflake.ingest.internal.apache.http.ProtocolVersion;
import net.snowflake.ingest.internal.apache.http.annotation.Immutable;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.protocol.HttpCoreContext;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

