/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.client.protocol;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.http.HttpEntity;
import net.snowflake.ingest.internal.apache.http.HttpEntityEnclosingRequest;
import net.snowflake.ingest.internal.apache.http.HttpException;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpRequestInterceptor;
import net.snowflake.ingest.internal.apache.http.HttpVersion;
import net.snowflake.ingest.internal.apache.http.ProtocolVersion;
import net.snowflake.ingest.internal.apache.http.annotation.Immutable;
import net.snowflake.ingest.internal.apache.http.client.config.RequestConfig;
import net.snowflake.ingest.internal.apache.http.client.protocol.HttpClientContext;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

