/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.cookie;

import java.util.Date;
import net.snowflake.ingest.internal.apache.http.annotation.Immutable;
import net.snowflake.ingest.internal.apache.http.client.utils.DateUtils;
import net.snowflake.ingest.internal.apache.http.cookie.CommonCookieAttributeHandler;
import net.snowflake.ingest.internal.apache.http.cookie.MalformedCookieException;
import net.snowflake.ingest.internal.apache.http.cookie.SetCookie;
import net.snowflake.ingest.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

