/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.jwk.source;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.JWKSet;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.source.JWKSetCache;

public class DefaultJWKSetCache
implements JWKSetCache {
    public static final long DEFAULT_LIFESPAN_MINUTES = 5L;
    private final long lifespan;
    private final TimeUnit timeUnit;
    private long putTimestamp = -1L;
    private JWKSet jwkSet;

    public DefaultJWKSetCache() {
        this(5L, TimeUnit.MINUTES);
    }

    public DefaultJWKSetCache(long lifespan, TimeUnit timeUnit) {
        this.lifespan = lifespan;
        if (lifespan > -1L && timeUnit == null) {
            throw new IllegalArgumentException("A time unit must be specified for non-negative lifespans");
        }
        this.timeUnit = timeUnit;
    }

    @Override
    public void put(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
        this.putTimestamp = jwkSet != null ? new Date().getTime() : -1L;
    }

    @Override
    public JWKSet get() {
        if (this.isExpired()) {
            this.jwkSet = null;
        }
        return this.jwkSet;
    }

    public long getPutTimestamp() {
        return this.putTimestamp;
    }

    public boolean isExpired() {
        return this.putTimestamp > -1L && this.lifespan > -1L && new Date().getTime() > this.putTimestamp + TimeUnit.MILLISECONDS.convert(this.lifespan, this.timeUnit);
    }

    public long getLifespan(TimeUnit timeUnit) {
        if (this.lifespan < 0L) {
            return this.lifespan;
        }
        return timeUnit.convert(this.lifespan, timeUnit);
    }
}

