/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.util;

import java.io.Serializable;
import java.math.BigInteger;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64Codec;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.BigIntegerUtils;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.StandardCharset;
import net.snowflake.ingest.internal.net.jcip.annotations.Immutable;
import net.snowflake.ingest.internal.net.minidev.json.JSONAware;
import net.snowflake.ingest.internal.net.minidev.json.JSONValue;

@Immutable
public class Base64
implements JSONAware,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String value;

    public Base64(String base64) {
        if (base64 == null) {
            throw new IllegalArgumentException("The Base64 value must not be null");
        }
        this.value = base64;
    }

    public byte[] decode() {
        return Base64Codec.decode(this.value);
    }

    public BigInteger decodeToBigInteger() {
        return new BigInteger(1, this.decode());
    }

    public String decodeToString() {
        return new String(this.decode(), StandardCharset.UTF_8);
    }

    @Override
    public String toJSONString() {
        return "\"" + JSONValue.escape(this.value) + "\"";
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Base64 && this.toString().equals(object.toString());
    }

    public static Base64 encode(byte[] bytes) {
        return new Base64(Base64Codec.encodeToString(bytes, false));
    }

    public static Base64 encode(BigInteger bigInt) {
        return Base64.encode(BigIntegerUtils.toBytesUnsigned(bigInt));
    }

    public static Base64 encode(String text) {
        return Base64.encode(text.getBytes(StandardCharset.UTF_8));
    }
}

