/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.nativeimage.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.function.BooleanSupplier;

@TargetClass(className="net.snowflake.client.jdbc.internal.google.api.client.googleapis.services.AbstractGoogleClientRequest$ApiClientVersion", onlyWith={OnlyIfInClassPath.class})
final class ApiClientVersionSubstitutions {
    @Alias
    private String versionString;

    @Substitute
    public String toString() {
        CharSequence[] tokens = this.versionString.split(" ");
        if (tokens.length > 0 && tokens[0].startsWith("gl-java")) {
            tokens[0] = tokens[0] + "-graalvm";
            return String.join((CharSequence)" ", tokens);
        }
        return this.versionString;
    }

    private ApiClientVersionSubstitutions() {
    }

    static class OnlyIfInClassPath
    implements BooleanSupplier {
        OnlyIfInClassPath() {
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Class.forName("net.snowflake.client.jdbc.internal.google.api.client.googleapis.services.AbstractGoogleClientRequest$ApiClientVersion", false, Thread.currentThread().getContextClassLoader());
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

