/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.s3upload;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceResultsHandler<V>
implements Iterable<V> {
    private ExecutorCompletionService<V> completionService;
    private ExecutorService executorService;
    private AtomicInteger taskCount = new AtomicInteger(0);

    public ExecutorServiceResultsHandler(ExecutorService executorService) {
        this.executorService = executorService;
        this.completionService = new ExecutorCompletionService(executorService);
    }

    public void submit(Callable<V> callable) {
        this.completionService.submit(callable);
        this.taskCount.incrementAndGet();
    }

    public void finishedSubmitting() {
        this.executorService.shutdown();
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return ExecutorServiceResultsHandler.this.taskCount.getAndDecrement() > 0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove with this iterator.");
            }

            @Override
            public V next() {
                Exception exception;
                try {
                    return ExecutorServiceResultsHandler.this.completionService.take().get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    exception = interruptedException;
                }
                catch (ExecutionException executionException) {
                    exception = executionException;
                }
                ExecutorServiceResultsHandler.this.abort();
                throw new RuntimeException(exception);
            }
        };
    }

    public void abort() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
        this.completionService = null;
    }

    public void awaitCompletion() {
        for (V v : this) {
        }
    }
}

