/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client.compatible1X;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQBytesCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQMapCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQObjectCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQStreamCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQTextCompatibleMessage;
import org.apache.activemq.artemis.reader.MessageUtil;

public class ActiveMQCompatibleMessage
extends ActiveMQMessage {
    public ActiveMQCompatibleMessage(byte type, ClientSession session) {
        super(type, session);
    }

    public ActiveMQCompatibleMessage(ClientSession session) {
        super(session);
    }

    public ActiveMQCompatibleMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQCompatibleMessage(Message foreign, ClientSession session) throws JMSException {
        super(foreign, session);
    }

    public ActiveMQCompatibleMessage() {
    }

    public ActiveMQCompatibleMessage(Message foreign, byte type, ClientSession session) throws JMSException {
        super(foreign, type, session);
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        if (this.replyTo == null) {
            this.replyTo = ActiveMQCompatibleMessage.findCompatibleReplyTo(this.message);
        }
        return this.replyTo;
    }

    @Override
    public void setJMSReplyTo(Destination dest) throws JMSException {
        this.replyTo = ActiveMQCompatibleMessage.setCompatibleReplyTo(dest, this.message);
    }

    static Destination setCompatibleReplyTo(Destination dest, ClientMessage message) throws InvalidDestinationException {
        if (dest == null) {
            MessageUtil.setJMSReplyTo((org.apache.activemq.artemis.api.core.Message)message, (String)null);
            return null;
        }
        if (!(dest instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Foreign destination " + dest);
        }
        ActiveMQDestination jbd = (ActiveMQDestination)dest;
        String address = jbd.getAddress();
        if (ActiveMQCompatibleMessage.hasPrefix1X(address)) {
            MessageUtil.setJMSReplyTo((org.apache.activemq.artemis.api.core.Message)message, (String)jbd.getAddress());
        } else {
            String prefix = ActiveMQCompatibleMessage.prefixOf(dest);
            MessageUtil.setJMSReplyTo((org.apache.activemq.artemis.api.core.Message)message, (String)(prefix + jbd.getAddress()));
        }
        return jbd;
    }

    static Destination findCompatibleReplyTo(ClientMessage message) {
        SimpleString address = MessageUtil.getJMSReplyTo((org.apache.activemq.artemis.api.core.Message)message);
        if (address != null) {
            SimpleString checkedAddress = ActiveMQCompatibleMessage.checkPrefix1X(address);
            if (checkedAddress != null) {
                return ActiveMQDestination.fromPrefixed1XName(address.toString(), checkedAddress.toString());
            }
            String name = address.toString();
            if (address.startsWith(OLD_QUEUE_QUALIFIED_PREFIX)) {
                name = address.subSeq(OLD_QUEUE_QUALIFIED_PREFIX.length(), address.length()).toString();
            } else if (address.startsWith(OLD_TEMP_QUEUE_QUALIFED_PREFIX)) {
                name = address.subSeq(OLD_TEMP_QUEUE_QUALIFED_PREFIX.length(), address.length()).toString();
            } else if (address.startsWith(OLD_TOPIC_QUALIFIED_PREFIX)) {
                name = address.subSeq(OLD_TOPIC_QUALIFIED_PREFIX.length(), address.length()).toString();
            } else if (address.startsWith(OLD_TEMP_TOPIC_QUALIFED_PREFIX)) {
                name = address.subSeq(OLD_TEMP_TOPIC_QUALIFED_PREFIX.length(), address.length()).toString();
            }
            return ActiveMQDestination.fromPrefixedName(address.toString(), name);
        }
        return null;
    }

    @Override
    public SimpleString checkPrefix(SimpleString address) {
        return ActiveMQCompatibleMessage.checkPrefix1X(address);
    }

    private static boolean hasPrefix1X(String address) {
        if (address != null) {
            if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
                return true;
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString())) {
                return true;
            }
            if (address.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
                return true;
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString())) {
                return true;
            }
        }
        return false;
    }

    protected static SimpleString checkPrefix1X(SimpleString address) {
        if (address != null) {
            if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_QUEUE_PREFIX.length(), address.length());
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_TEMP_QUEUE_PREFIX.length(), address.length());
            }
            if (address.startsWith(PacketImpl.OLD_TOPIC_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_TOPIC_PREFIX.length(), address.length());
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX)) {
                return address.subSeq(PacketImpl.OLD_TEMP_TOPIC_PREFIX.length(), address.length());
            }
        }
        return null;
    }

    public static ActiveMQMessage createMessage(ClientMessage message, ClientSession session, ConnectionFactoryOptions options) {
        byte type = message.getType();
        return switch (type) {
            case 0 -> new ActiveMQCompatibleMessage(message, session);
            case 4 -> new ActiveMQBytesCompatibleMessage(message, session);
            case 5 -> new ActiveMQMapCompatibleMessage(message, session);
            case 2 -> new ActiveMQObjectCompatibleMessage(message, session, options);
            case 6 -> new ActiveMQStreamCompatibleMessage(message, session);
            case 3 -> new ActiveMQTextCompatibleMessage(message, session);
            default -> throw new JMSRuntimeException("Invalid message type " + type);
        };
    }
}

