/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.AbstractStub;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallOption;

public class CallOptions {
    public static CallOption timeout(long duration, TimeUnit unit) {
        return new Timeout(duration, unit);
    }

    static <T extends AbstractStub<T>> T wrapStub(T stub, CallOption[] options) {
        for (CallOption option : options) {
            if (!(option instanceof GrpcCallOption)) continue;
            stub = ((GrpcCallOption)option).wrapStub(stub);
        }
        return stub;
    }

    private static class Timeout
    implements GrpcCallOption {
        long timeout;
        TimeUnit timeoutUnit;

        Timeout(long timeout, TimeUnit timeoutUnit) {
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
        }

        @Override
        public <T extends AbstractStub<T>> T wrapStub(T stub) {
            return stub.withDeadlineAfter(this.timeout, this.timeoutUnit);
        }
    }

    public static interface GrpcCallOption
    extends CallOption {
        public <T extends AbstractStub<T>> T wrapStub(T var1);
    }
}

