/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.constraints.ConstraintUtils;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.DHParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DHBasicKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

