/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

public abstract class ApplicationEDIEntity
extends MimeEntity {
    private final String ediMessage;

    protected ApplicationEDIEntity(String ediMessage, ContentType contentType, String contentTransferEncoding, boolean isMainBody) {
        this.ediMessage = (String)Args.notNull((Object)ediMessage, (String)"EDI Message");
        this.setContentType(((ContentType)Args.notNull((Object)contentType, (String)"Content Type")).toString());
        this.setContentTransferEncoding(contentTransferEncoding);
        this.setMainBody(isMainBody);
    }

    public String getEdiMessage() {
        return this.ediMessage;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, "US-ASCII");
             OutputStream transferEncodedStream = EntityUtils.encode(canonicalOutstream, this.getContentTransferEncodingValue());){
            if (!this.isMainBody()) {
                HeaderIterator it = this.headerIterator();
                while (it.hasNext()) {
                    Header header = it.nextHeader();
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            transferEncodedStream.write(this.ediMessage.getBytes(this.getCharset()), 0, this.ediMessage.length());
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }
}

