/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.box.BoxCollaborationsManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxCommentsManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxEventLogsManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxEventsManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxFilesManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxFoldersManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxGroupsManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxSearchManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxTasksManagerEndpointConfiguration;
import org.apache.camel.component.box.BoxUsersManagerEndpointConfiguration;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.component.box.internal.BoxCollaborationsManagerApiMethod;
import org.apache.camel.component.box.internal.BoxCommentsManagerApiMethod;
import org.apache.camel.component.box.internal.BoxEventLogsManagerApiMethod;
import org.apache.camel.component.box.internal.BoxEventsManagerApiMethod;
import org.apache.camel.component.box.internal.BoxFilesManagerApiMethod;
import org.apache.camel.component.box.internal.BoxFoldersManagerApiMethod;
import org.apache.camel.component.box.internal.BoxGroupsManagerApiMethod;
import org.apache.camel.component.box.internal.BoxSearchManagerApiMethod;
import org.apache.camel.component.box.internal.BoxTasksManagerApiMethod;
import org.apache.camel.component.box.internal.BoxUsersManagerApiMethod;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethodHelper;

public final class BoxApiCollection
extends ApiCollection<BoxApiName, BoxConfiguration> {
    private static BoxApiCollection collection;

    private BoxApiCollection() {
        HashMap<String, String> aliases = new HashMap<String, String>();
        HashMap<BoxApiName, ApiMethodHelper> apiHelpers = new HashMap<BoxApiName, ApiMethodHelper>();
        HashMap<Class, BoxApiName> apiMethods = new HashMap<Class, BoxApiName>();
        aliases.clear();
        aliases.put("addFolderCollaboration", "add");
        aliases.put("addFolderCollaborationByEmail", "addByEmail");
        aliases.put("deleteCollaboration", "delete");
        aliases.put("getFolderCollaborations", "collaborations");
        aliases.put("getPendingCollaborations", "pendingCollaborations");
        aliases.put("getCollaborationInfo", "info");
        aliases.put("updateCollaborationInfo", "updateInfo");
        List<String> nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(BoxApiName.COLLABORATIONS, new ApiMethodHelper(BoxCollaborationsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxCollaborationsManagerApiMethod.class, BoxApiName.COLLABORATIONS);
        aliases.clear();
        aliases.put("addFileComment", "add");
        aliases.put("changeCommentMessage", "updateMessage");
        aliases.put("deleteComment", "delete");
        aliases.put("getCommentInfo", "info");
        aliases.put("getFileComments", "comments");
        aliases.put("replyToComment", "reply");
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(BoxApiName.COMMENTS, new ApiMethodHelper(BoxCommentsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxCommentsManagerApiMethod.class, BoxApiName.COMMENTS);
        aliases.clear();
        aliases.put("getEnterpriseEvents", "events");
        nullableArgs = Arrays.asList("position", "types");
        apiHelpers.put(BoxApiName.EVENT_LOGS, new ApiMethodHelper(BoxEventLogsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxEventLogsManagerApiMethod.class, BoxApiName.EVENT_LOGS);
        aliases.clear();
        aliases.put("uploadFile", "upload");
        aliases.put("downloadFile", "download");
        aliases.put("copyFile", "copy");
        aliases.put("moveFile", "move");
        aliases.put("renameFile", "rename");
        aliases.put("createFileSharedLink", "link");
        aliases.put("deleteFile", "delete");
        aliases.put("uploadNewFileVersion", "uploadVersion");
        aliases.put("promoteFileVersion", "promoteVersion");
        aliases.put("getFileVersions", "versions");
        aliases.put("downloadPreviousFileVersion", "downloadVersion");
        aliases.put("deleteFileVersion", "deleteVersion");
        aliases.put("getFileInfo", "info");
        aliases.put("updateFileInfo", "updateInfo");
        aliases.put("createFileMetadata", "createMetadata");
        aliases.put("getFileMetadata", "metadata");
        aliases.put("updateFileMetadata", "updateMetadata");
        aliases.put("deleteFileMetadata", "deleteMetadata");
        aliases.put("getDownloadUrl", "url");
        aliases.put("getPreviewLink", "preview");
        aliases.put("getFileThumbnail", "thumbnail");
        aliases.put("checkUpload", "canUpload");
        nullableArgs = Arrays.asList("fields", "created", "modified", "size", "fileSize", "rangeStart", "rangeEnd", "listener", "fileSize", "newName", "unshareDate", "permissions", "typeName", "check");
        apiHelpers.put(BoxApiName.FILES, new ApiMethodHelper(BoxFilesManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxFilesManagerApiMethod.class, BoxApiName.FILES);
        aliases.clear();
        aliases.put("getRootFolder", "root");
        aliases.put("createFolder", "create");
        aliases.put("copyFolder", "copy");
        aliases.put("moveFolder", "move");
        aliases.put("renameFolder", "rename");
        aliases.put("createFolderSharedLink", "link");
        aliases.put("deleteFolder", "delete");
        aliases.put("getFolder", "folder");
        aliases.put("getFolderInfo", "info");
        aliases.put("getFolderItems", "items");
        aliases.put("updateFolderInfo", "updateInfo");
        nullableArgs = Arrays.asList("offset", "limit", "fields", "newName");
        apiHelpers.put(BoxApiName.FOLDERS, new ApiMethodHelper(BoxFoldersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxFoldersManagerApiMethod.class, BoxApiName.FOLDERS);
        aliases.clear();
        aliases.put("createGroup", "create");
        aliases.put("deleteGroup", "delete");
        aliases.put("getAllGroups", "groups");
        aliases.put("getGroupInfo", "info");
        aliases.put("addGroupMembership", "addMembership");
        aliases.put("deleteGroupMembership", "deleteMembership");
        aliases.put("getGroupMemberships", "memberships");
        aliases.put("getGroupMembershipInfo", "membershipInfo");
        aliases.put("updateGroupMembershipInfo", "updateMembershipInfo");
        nullableArgs = Arrays.asList("role", "description", "provenance", "externalSyncIdentifier", "invitabilityLevel", "memberViewabilityLevel");
        apiHelpers.put(BoxApiName.GROUPS, new ApiMethodHelper(BoxGroupsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxGroupsManagerApiMethod.class, BoxApiName.GROUPS);
        aliases.clear();
        nullableArgs = Arrays.asList("startingPosition");
        apiHelpers.put(BoxApiName.EVENTS, new ApiMethodHelper(BoxEventsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxEventsManagerApiMethod.class, BoxApiName.EVENTS);
        aliases.clear();
        aliases.put("searchFolder", "search");
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(BoxApiName.SEARCH, new ApiMethodHelper(BoxSearchManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxSearchManagerApiMethod.class, BoxApiName.SEARCH);
        aliases.clear();
        aliases.put("addFileTask", "add");
        aliases.put("deleteTask", "delete");
        aliases.put("getFileTasks", "tasks");
        aliases.put("getTaskInfo", "info");
        aliases.put("updateTaskInfo", "updateInfo");
        aliases.put("addAssignmentToTask", "addAssignment");
        aliases.put("deleteTaskAssignment", "deleteAssignment");
        aliases.put("getTaskAssignments", "assignments");
        aliases.put("getTaskAssignmentInfo", "assignmentInfo");
        nullableArgs = Arrays.asList("message");
        apiHelpers.put(BoxApiName.TASKS, new ApiMethodHelper(BoxTasksManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxTasksManagerApiMethod.class, BoxApiName.TASKS);
        aliases.clear();
        aliases.put("getCurrentUser", "currentUser");
        aliases.put("getAllEnterpriseOrExternalUsers", "users");
        aliases.put("createAppUser", "create");
        aliases.put("createEnterpriseUser", "create");
        aliases.put("deleteUser", "delete");
        aliases.put("addUserEmailAlias", "addEmailAlias");
        aliases.put("getUserEmailAlias", "emailAlias");
        aliases.put("deleteUserEmailAlias", "deleteEmailAlias");
        aliases.put("getUserInfo", "info");
        aliases.put("updateUserInfo", "updateInfo");
        nullableArgs = Arrays.asList("filterTerm", "fields", "params");
        apiHelpers.put(BoxApiName.USERS, new ApiMethodHelper(BoxUsersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(BoxUsersManagerApiMethod.class, BoxApiName.USERS);
        this.setApiHelpers(apiHelpers);
        this.setApiMethods(apiMethods);
    }

    public BoxConfiguration getEndpointConfiguration(BoxApiName apiName) {
        BoxConfiguration result = null;
        switch (apiName) {
            case COLLABORATIONS: {
                result = new BoxCollaborationsManagerEndpointConfiguration();
                break;
            }
            case COMMENTS: {
                result = new BoxCommentsManagerEndpointConfiguration();
                break;
            }
            case EVENT_LOGS: {
                result = new BoxEventLogsManagerEndpointConfiguration();
                break;
            }
            case FILES: {
                result = new BoxFilesManagerEndpointConfiguration();
                break;
            }
            case FOLDERS: {
                result = new BoxFoldersManagerEndpointConfiguration();
                break;
            }
            case GROUPS: {
                result = new BoxGroupsManagerEndpointConfiguration();
                break;
            }
            case EVENTS: {
                result = new BoxEventsManagerEndpointConfiguration();
                break;
            }
            case SEARCH: {
                result = new BoxSearchManagerEndpointConfiguration();
                break;
            }
            case TASKS: {
                result = new BoxTasksManagerEndpointConfiguration();
                break;
            }
            case USERS: {
                result = new BoxUsersManagerEndpointConfiguration();
            }
        }
        return result;
    }

    public static synchronized BoxApiCollection getCollection() {
        if (collection == null) {
            collection = new BoxApiCollection();
        }
        return collection;
    }
}

