/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.common.AbstractTLSClientParameterConfigurer;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;

public class AbstractSslEndpointConfigurer
extends AbstractTLSClientParameterConfigurer {
    protected final SSLSocketFactory sslSocketFactory;

    public AbstractSslEndpointConfigurer(SSLContextParameters sslContextParameters, CamelContext camelContext) {
        this.sslSocketFactory = this.tryToGetSSLSocketFactory(sslContextParameters, camelContext);
    }

    protected void setupHttpConduit(HTTPConduit httpConduit) {
        TLSClientParameters tlsClientParameters = this.tryToGetTLSClientParametersFromConduit(httpConduit);
        tlsClientParameters.setSSLSocketFactory(this.sslSocketFactory);
        httpConduit.setTlsClientParameters(tlsClientParameters);
    }

    private SSLSocketFactory tryToGetSSLSocketFactory(SSLContextParameters sslContextParameters, CamelContext camelContext) {
        try {
            return sslContextParameters.createSSLContext(camelContext).getSocketFactory();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Setting SSL failed", e);
        }
    }
}

