/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hbase.HBaseEndpoint;
import org.apache.camel.component.hbase.HBaseHelper;
import org.apache.camel.component.hbase.filters.ModelAwareFilter;
import org.apache.camel.component.hbase.mapping.CellMappingStrategy;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseData;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseProducer
extends DefaultProducer {
    private HBaseEndpoint endpoint;
    private HBaseRow rowModel;

    public HBaseProducer(HBaseEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.rowModel = endpoint.getRowModel();
    }

    public void process(Exchange exchange) throws Exception {
        try (Table table = this.endpoint.getTable();){
            this.updateHeaders(exchange);
            String operation = (String)exchange.getIn().getHeader("CamelHBaseOperation");
            Integer maxScanResult = (Integer)exchange.getIn().getHeader("CamelHBaseMaxScanResults", Integer.class);
            String fromRowId = (String)exchange.getIn().getHeader("CamelHBaseStartRow");
            String stopRowId = (String)exchange.getIn().getHeader("CamelHBaseStopRow");
            CellMappingStrategy mappingStrategy = this.endpoint.getCellMappingStrategyFactory().getStrategy(exchange.getIn());
            HBaseData data = mappingStrategy.resolveModel(exchange.getIn());
            LinkedList<Put> putOperations = new LinkedList<Put>();
            LinkedList<Delete> deleteOperations = new LinkedList<Delete>();
            LinkedList<HBaseRow> getOperationResult = new LinkedList<HBaseRow>();
            List<HBaseRow> scanOperationResult = new LinkedList<HBaseRow>();
            for (HBaseRow hRow : data.getRows()) {
                hRow.apply(this.rowModel);
                if ("CamelHBasePut".equals(operation)) {
                    putOperations.add(this.createPut(hRow));
                    continue;
                }
                if ("CamelHBaseGet".equals(operation)) {
                    HBaseRow getResultRow = this.getCells(table, hRow);
                    getOperationResult.add(getResultRow);
                    continue;
                }
                if ("CamelHBaseDelete".equals(operation)) {
                    deleteOperations.add(this.createDeleteRow(hRow));
                    continue;
                }
                if (!"CamelHBaseScan".equals(operation)) continue;
                scanOperationResult = this.scanCells(table, hRow, fromRowId, stopRowId, maxScanResult, this.endpoint.getFilters());
            }
            if (!putOperations.isEmpty()) {
                table.put(putOperations);
            } else if (!deleteOperations.isEmpty()) {
                table.delete(deleteOperations);
            } else if (!getOperationResult.isEmpty()) {
                mappingStrategy.applyGetResults(exchange.getOut(), new HBaseData(getOperationResult));
            } else if (!scanOperationResult.isEmpty()) {
                mappingStrategy.applyScanResults(exchange.getOut(), new HBaseData(scanOperationResult));
            }
        }
    }

    private Put createPut(HBaseRow hRow) throws Exception {
        ObjectHelper.notNull((Object)hRow, (String)"HBase row");
        ObjectHelper.notNull((Object)hRow.getId(), (String)"HBase row id");
        ObjectHelper.notNull(hRow.getCells(), (String)"HBase cells");
        Put put = new Put((byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, hRow.getId()));
        Set<HBaseCell> cells = hRow.getCells();
        for (HBaseCell cell : cells) {
            String family = cell.getFamily();
            String column = cell.getQualifier();
            Object value = cell.getValue();
            ObjectHelper.notNull((Object)family, (String)"HBase column family", (Object)cell);
            ObjectHelper.notNull((Object)column, (String)"HBase column", (Object)cell);
            put.addColumn(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column), (byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, value));
        }
        return put;
    }

    private HBaseRow getCells(Table table, HBaseRow hRow) throws Exception {
        HBaseRow resultRow = new HBaseRow();
        ObjectHelper.notNull((Object)hRow, (String)"HBase row");
        ObjectHelper.notNull((Object)hRow.getId(), (String)"HBase row id");
        ObjectHelper.notNull(hRow.getCells(), (String)"HBase cells");
        resultRow.setId(hRow.getId());
        Get get = new Get((byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, hRow.getId()));
        Set<HBaseCell> cellModels = hRow.getCells();
        for (HBaseCell cellModel : cellModels) {
            String family = cellModel.getFamily();
            String column = cellModel.getQualifier();
            ObjectHelper.notNull((Object)family, (String)"HBase column family", (Object)cellModel);
            ObjectHelper.notNull((Object)column, (String)"HBase column", (Object)cellModel);
            get.addColumn(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
        }
        Result result = table.get(get);
        if (!result.isEmpty()) {
            resultRow.setTimestamp(result.rawCells()[0].getTimestamp());
        }
        for (HBaseCell cellModel : cellModels) {
            HBaseCell resultCell = new HBaseCell();
            String family = cellModel.getFamily();
            String column = cellModel.getQualifier();
            resultCell.setFamily(family);
            resultCell.setQualifier(column);
            List kvs = result.getColumnCells(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
            if (kvs != null && !kvs.isEmpty()) {
                resultCell.setValue(this.endpoint.getCamelContext().getTypeConverter().convertTo(cellModel.getValueType(), (Object)CellUtil.cloneValue((Cell)((Cell)kvs.get(0)))));
                resultCell.setTimestamp(((Cell)kvs.get(0)).getTimestamp());
            }
            resultRow.getCells().add(resultCell);
        }
        return resultRow;
    }

    private Delete createDeleteRow(HBaseRow hRow) throws Exception {
        ObjectHelper.notNull((Object)hRow, (String)"HBase row");
        ObjectHelper.notNull((Object)hRow.getId(), (String)"HBase row id");
        return new Delete((byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, hRow.getId()));
    }

    private List<HBaseRow> scanCells(Table table, HBaseRow model, String start, String stop, Integer maxRowScan, List<Filter> filters) throws Exception {
        LinkedList<HBaseRow> rowSet = new LinkedList<HBaseRow>();
        HBaseRow startRow = new HBaseRow(model.getCells());
        startRow.setId(start);
        Scan scan = new Scan();
        if (start != null) {
            scan.withStartRow(Bytes.toBytes((String)start));
        }
        if (ObjectHelper.isNotEmpty((Object)stop)) {
            scan.withStopRow(Bytes.toBytes((String)stop));
        }
        if (filters != null && !filters.isEmpty()) {
            for (int i = 0; i < filters.size(); ++i) {
                ((ModelAwareFilter)filters.get(i)).apply(this.endpoint.getCamelContext(), model);
                scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{((ModelAwareFilter)filters.get(i)).getFilteredList()}));
            }
        }
        Set<HBaseCell> cellModels = model.getCells();
        for (HBaseCell cellModel : cellModels) {
            String family = cellModel.getFamily();
            String column = cellModel.getQualifier();
            if (!ObjectHelper.isNotEmpty((Object)family) || !ObjectHelper.isNotEmpty((Object)column)) continue;
            scan.addColumn(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
        }
        ResultScanner resultScanner = table.getScanner(scan);
        Result result = resultScanner.next();
        for (int count = 0; result != null && count < maxRowScan; ++count) {
            HBaseRow resultRow = new HBaseRow();
            resultRow.setId(this.endpoint.getCamelContext().getTypeConverter().convertTo(model.getRowType(), (Object)result.getRow()));
            resultRow.setTimestamp(result.rawCells()[0].getTimestamp());
            cellModels = model.getCells();
            for (HBaseCell modelCell : cellModels) {
                HBaseCell resultCell = new HBaseCell();
                String family = modelCell.getFamily();
                String column = modelCell.getQualifier();
                resultRow.setId(this.endpoint.getCamelContext().getTypeConverter().convertTo(model.getRowType(), (Object)result.getRow()));
                resultCell.setValue(this.endpoint.getCamelContext().getTypeConverter().convertTo(modelCell.getValueType(), (Object)result.getValue(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column))));
                resultCell.setFamily(modelCell.getFamily());
                resultCell.setQualifier(modelCell.getQualifier());
                Cell cell = result.getColumnLatestCell(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
                if (cell != null) {
                    resultCell.setTimestamp(cell.getTimestamp());
                }
                resultRow.getCells().add(resultCell);
            }
            rowSet.add(resultRow);
            result = resultScanner.next();
        }
        return rowSet;
    }

    private void updateHeaders(Exchange exchange) {
        if (exchange != null && exchange.getIn() != null) {
            if (this.endpoint.getMaxResults() != 0 && exchange.getIn().getHeader("CamelHBaseMaxScanResults") == null) {
                exchange.getIn().setHeader("CamelHBaseMaxScanResults", (Object)this.endpoint.getMaxResults());
            }
            if (this.endpoint.getMappingStrategyName() != null && exchange.getIn().getHeader("CamelMappingStrategy") == null) {
                exchange.getIn().setHeader("CamelMappingStrategy", (Object)this.endpoint.getMappingStrategyName());
            }
            if (this.endpoint.getMappingStrategyName() != null && exchange.getIn().getHeader("CamelMappingStrategyClassName") == null) {
                exchange.getIn().setHeader("CamelMappingStrategyClassName", (Object)this.endpoint.getMappingStrategyClassName());
            }
            if (this.endpoint.getOperation() != null && exchange.getIn().getHeader("CamelHBaseOperation") == null) {
                exchange.getIn().setHeader("CamelHBaseOperation", (Object)this.endpoint.getOperation());
            } else if (this.endpoint.getOperation() == null && exchange.getIn().getHeader("CamelHBaseOperation") == null) {
                exchange.getIn().setHeader("CamelHBaseOperation", (Object)"CamelHBasePut");
            }
        }
    }
}

