/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.workitem;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.jbpm.workitem.AbstractCamelCommand;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.executor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentContextCamelCommand
extends AbstractCamelCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentContextCamelCommand.class);
    private final Map<String, ProducerTemplate> templates = new ConcurrentHashMap<String, ProducerTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProducerTemplate getProducerTemplate(CommandContext ctx) {
        String deploymentId = (String)ctx.getData("deploymentId");
        ProducerTemplate template = this.templates.get(deploymentId);
        if (template == null) {
            DeploymentContextCamelCommand deploymentContextCamelCommand = this;
            synchronized (deploymentContextCamelCommand) {
                template = this.templates.get(deploymentId);
                if (template == null) {
                    CamelContext deploymentCamelContext = (CamelContext)ServiceRegistry.get().service(deploymentId + "_CamelService");
                    template = deploymentCamelContext.createProducerTemplate();
                    this.templates.put(deploymentId, template);
                }
            }
        }
        return template;
    }

    public void close() {
        for (ProducerTemplate nextTemplate : this.templates.values()) {
            try {
                nextTemplate.stop();
            }
            catch (Exception e) {
                LOGGER.warn("Error encountered while closing the Camel Producer Template.", (Throwable)e);
            }
        }
    }
}

