/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.EnumMap;
import java.util.Map;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.Tag;

public class OpenTelemetrySpanAdapter
implements SpanAdapter {
    private static final String DEFAULT_EVENT_NAME = "log";
    private static Map<Tag, String> tagMap = new EnumMap<Tag, String>(Tag.class);
    private Baggage baggage;
    private Span span;

    OpenTelemetrySpanAdapter(Span span) {
        this.span = span;
    }

    OpenTelemetrySpanAdapter(Span span, Baggage baggage) {
        this.span = span;
        this.baggage = baggage;
    }

    Span getOpenTelemetrySpan() {
        return this.span;
    }

    public void setComponent(String component) {
        this.span.setAttribute("component", component);
    }

    public void setError(boolean error) {
        this.span.setAttribute("error", error);
    }

    public void setTag(Tag key, String value) {
        this.span.setAttribute(tagMap.get(key), value);
    }

    public void setTag(Tag key, Number value) {
        this.span.setAttribute(tagMap.get(key), (long)value.intValue());
    }

    public void setTag(String key, String value) {
        this.span.setAttribute(key, value);
    }

    public void setTag(String key, Number value) {
        this.span.setAttribute(key, (long)value.intValue());
    }

    public void setTag(String key, Boolean value) {
        this.span.setAttribute(key, value.booleanValue());
    }

    public void log(Map<String, String> fields) {
        this.span.addEvent(this.getEventNameFromFields(fields), this.convertToAttributes(fields));
    }

    public String traceId() {
        return this.span.getSpanContext().getTraceId();
    }

    public String spanId() {
        return this.span.getSpanContext().getSpanId();
    }

    public AutoCloseable makeCurrent() {
        return this.span.makeCurrent();
    }

    String getEventNameFromFields(Map<String, ?> fields) {
        Object eventValue;
        Object object = eventValue = fields == null ? null : (Object)fields.get("event");
        if (eventValue != null) {
            return eventValue.toString();
        }
        return DEFAULT_EVENT_NAME;
    }

    Attributes convertToAttributes(Map<String, ?> fields) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                attributesBuilder.put(key, ((Number)value).longValue());
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                attributesBuilder.put(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                attributesBuilder.put(key, ((Boolean)value).booleanValue());
                continue;
            }
            attributesBuilder.put(key, value.toString());
        }
        return attributesBuilder.build();
    }

    public Baggage getBaggage() {
        return this.baggage;
    }

    public void setBaggage(Baggage baggage) {
        this.baggage = baggage;
    }

    public void setCorrelationContextItem(String key, String value) {
        BaggageBuilder builder = Baggage.builder();
        if (this.baggage != null) {
            builder = Baggage.current().toBuilder();
        }
        this.baggage = builder.put(key, value).build();
    }

    public String getContextPropagationItem(String key) {
        if (this.baggage != null) {
            return this.baggage.getEntryValue(key);
        }
        return null;
    }

    static {
        tagMap.put(Tag.COMPONENT, "component");
        tagMap.put(Tag.DB_TYPE, SemanticAttributes.DB_SYSTEM.getKey());
        tagMap.put(Tag.DB_STATEMENT, SemanticAttributes.DB_STATEMENT.getKey());
        tagMap.put(Tag.DB_INSTANCE, SemanticAttributes.DB_NAME.getKey());
        tagMap.put(Tag.HTTP_METHOD, SemanticAttributes.HTTP_METHOD.getKey());
        tagMap.put(Tag.HTTP_STATUS, SemanticAttributes.HTTP_STATUS_CODE.getKey());
        tagMap.put(Tag.HTTP_URL, SemanticAttributes.HTTP_URL.getKey());
        tagMap.put(Tag.MESSAGE_BUS_DESTINATION, "message_bus.destination");
    }
}

