/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.paho.PahoComponent;
import org.apache.camel.component.paho.PahoConfiguration;
import org.apache.camel.component.paho.PahoConsumer;
import org.apache.camel.component.paho.PahoPersistence;
import org.apache.camel.component.paho.PahoProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;

@UriEndpoint(firstVersion="2.16.0", scheme="paho", title="Paho", category={Category.MESSAGING, Category.IOT}, syntax="paho:topic")
public class PahoEndpoint
extends DefaultEndpoint {
    @UriPath(description="Name of the topic")
    @Metadata(required=true)
    private final String topic;
    @UriParam
    private final PahoConfiguration configuration;
    @UriParam(label="advanced")
    private volatile MqttClient client;

    public PahoEndpoint(String uri, String topic, PahoComponent component, PahoConfiguration configuration) {
        super(uri, (Component)component);
        this.topic = topic;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        PahoProducer producer = new PahoProducer(this);
        producer.setClient(this.client);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        PahoConsumer consumer = new PahoConsumer((Endpoint)this, processor);
        consumer.setClient(this.client);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PahoComponent getComponent() {
        return (PahoComponent)super.getComponent();
    }

    public String getTopic() {
        return this.topic;
    }

    protected static MqttConnectOptions createMqttConnectOptions(PahoConfiguration config) {
        MqttConnectOptions mq = new MqttConnectOptions();
        if (ObjectHelper.isNotEmpty((Object)config.getUserName()) && ObjectHelper.isNotEmpty((Object)config.getPassword())) {
            mq.setUserName(config.getUserName());
            mq.setPassword(config.getPassword().toCharArray());
        }
        mq.setAutomaticReconnect(config.isAutomaticReconnect());
        mq.setCleanSession(config.isCleanSession());
        mq.setConnectionTimeout(config.getConnectionTimeout());
        mq.setExecutorServiceTimeout(config.getExecutorServiceTimeout());
        mq.setCustomWebSocketHeaders(config.getCustomWebSocketHeaders());
        mq.setHttpsHostnameVerificationEnabled(config.isHttpsHostnameVerificationEnabled());
        mq.setKeepAliveInterval(config.getKeepAliveInterval());
        mq.setMaxInflight(config.getMaxInflight());
        mq.setMaxReconnectDelay(config.getMaxReconnectDelay());
        mq.setMqttVersion(config.getMqttVersion());
        mq.setSocketFactory(config.getSocketFactory());
        mq.setSSLHostnameVerifier(config.getSslHostnameVerifier());
        mq.setSSLProperties(config.getSslClientProps());
        if (config.getWillTopic() != null && config.getWillPayload() != null) {
            mq.setWill(config.getWillTopic(), config.getWillPayload().getBytes(), config.getWillQos(), config.isWillRetained());
        }
        if (config.getServerURIs() != null) {
            mq.setServerURIs(config.getServerURIs().split(","));
        }
        return mq;
    }

    protected static MqttClientPersistence createMqttClientPersistence(PahoConfiguration configuration) {
        if (configuration.getPersistence() == PahoPersistence.MEMORY) {
            return new MemoryPersistence();
        }
        if (configuration.getFilePersistenceDirectory() != null) {
            return new MqttDefaultFilePersistence(configuration.getFilePersistenceDirectory());
        }
        return new MqttDefaultFilePersistence();
    }

    public PahoConfiguration getConfiguration() {
        return this.configuration;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }
}

