/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="platform-http", displayName="Platform HTTP", description="Embedded HTTP Server")
public class PlatformHttpConsole
extends AbstractDevConsole {
    public PlatformHttpConsole() {
        super("camel", "platform-http", "Platform HTTP", "Embedded HTTP Server");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        PlatformHttpComponent http = (PlatformHttpComponent)this.getCamelContext().hasComponent("platform-http");
        if (http != null) {
            Object server = "http://0.0.0.0";
            int port = http.getEngine().getServerPort();
            if (port > 0) {
                server = (String)server + ":" + port;
            }
            Set<HttpEndpointModel> models = http.getHttpEndpoints();
            for (HttpEndpointModel model : models) {
                if (model.getVerbs() != null) {
                    sb.append(String.format("    %s%s (%s)\n", server, model.getUri(), model.getVerbs()));
                    continue;
                }
                sb.append(String.format("    %s%s\n", server, model.getUri()));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        PlatformHttpComponent http = (PlatformHttpComponent)this.getCamelContext().hasComponent("platform-http");
        if (http != null) {
            Object server = "http://0.0.0.0";
            int port = http.getEngine().getServerPort();
            if (port > 0) {
                server = (String)server + ":" + port;
            }
            root.put((Object)"server", server);
            List<JsonObject> list = PlatformHttpConsole.buildEndpointList(http, (String)server);
            if (!list.isEmpty()) {
                root.put((Object)"endpoints", list);
            }
        }
        return root;
    }

    private static List<JsonObject> buildEndpointList(PlatformHttpComponent http, String server) {
        Set<HttpEndpointModel> models = http.getHttpEndpoints();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (HttpEndpointModel model : models) {
            JsonObject jo = new JsonObject();
            Object uri = model.getUri();
            if (!((String)uri).startsWith("/")) {
                uri = "/" + (String)uri;
            }
            jo.put((Object)"url", (Object)(server + (String)uri));
            jo.put((Object)"path", (Object)model.getUri());
            if (model.getVerbs() != null) {
                jo.put((Object)"verbs", (Object)model.getVerbs());
            }
            if (model.getConsumes() != null) {
                jo.put((Object)"consumes", (Object)model.getConsumes());
            }
            if (model.getProduces() != null) {
                jo.put((Object)"produces", (Object)model.getProduces());
            }
            list.add(jo);
        }
        return list;
    }
}

