/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.api.DispatchCallback;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class UnwrappingPublisher
implements Publisher<Exchange> {
    private final Publisher<Exchange> delegate;

    public UnwrappingPublisher(Publisher<Exchange> delegate) {
        Objects.requireNonNull(delegate, "delegate publisher cannot be null");
        this.delegate = delegate;
    }

    public void subscribe(final Subscriber<? super Exchange> subscriber) {
        this.delegate.subscribe((Subscriber)new Subscriber<Exchange>(){
            private Subscription subscription;

            public void onSubscribe(Subscription newSubscription) {
                if (newSubscription == null) {
                    throw new NullPointerException("subscription is null");
                }
                if (newSubscription == this.subscription) {
                    throw new IllegalArgumentException("already subscribed to the subscription: " + String.valueOf(newSubscription));
                }
                if (this.subscription != null) {
                    newSubscription.cancel();
                } else {
                    this.subscription = newSubscription;
                    subscriber.onSubscribe(newSubscription);
                }
            }

            public void onNext(Exchange payload) {
                Exception error = null;
                try {
                    subscriber.onNext((Object)payload);
                }
                catch (Exception t) {
                    error = t;
                }
                DispatchCallback<Exchange> callback = ReactiveStreamsHelper.getCallback(payload);
                if (callback != null) {
                    callback.processed(payload, error);
                }
            }

            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }
}

