/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import java.util.Arrays;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFilePollingConsumer;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.component.smb.SmbComponent;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbConstants;
import org.apache.camel.component.smb.SmbConsumer;
import org.apache.camel.component.smb.SmbDefaultMoveExistingFileStrategy;
import org.apache.camel.component.smb.SmbOperations;
import org.apache.camel.component.smb.SmbProducer;
import org.apache.camel.component.smb.strategy.SmbProcessStrategyFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="4.3.0", scheme="smb", title="SMB", syntax="smb:hostname:port/shareName", headersClass=SmbConstants.class, category={Category.FILE})
@Metadata(excludeProperties="appendChars,readLockIdempotentReleaseAsync,readLockIdempotentReleaseAsyncPoolSize,readLockIdempotentReleaseDelay,readLockIdempotentReleaseExecutorService,directoryMustExist,extendedAttributes,probeContentType,startingDirectoryMustHaveAccess,chmodDirectory,forceWrites,copyAndDeleteOnRenameFail,renameUsingCopy,synchronous")
public class SmbEndpoint
extends GenericFileEndpoint<FileIdBothDirectoryInformation>
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(SmbEndpoint.class);
    @UriParam
    private SmbConfiguration configuration;

    protected SmbEndpoint(String uri, SmbComponent component, SmbConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public boolean isSingletonProducer() {
        return false;
    }

    public String getScheme() {
        return "smb";
    }

    public char getFileSeparator() {
        return '/';
    }

    public boolean isAbsolute(String name) {
        return name.startsWith("/");
    }

    protected GenericFileProcessStrategy<FileIdBothDirectoryInformation> createGenericFileStrategy() {
        return new SmbProcessStrategyFactory().createGenericFileProcessStrategy(this.getCamelContext(), this.getParamsAsMap());
    }

    public GenericFileProducer<FileIdBothDirectoryInformation> createProducer() throws Exception {
        try {
            if (this.getMoveExistingFileStrategy() == null) {
                this.setMoveExistingFileStrategy(this.createDefaultFtpMoveExistingFileStrategy());
            }
            return new SmbProducer(this, this.createOperations());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException((Endpoint)this, (Throwable)e);
        }
    }

    public String getServiceUrl() {
        return this.configuration.getProtocol() + ":" + this.configuration.getHostname() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return this.configuration.getProtocol();
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getUsername() != null) {
            return Map.of("username", this.configuration.getUsername());
        }
        return null;
    }

    public SmbConfiguration getConfiguration() {
        return this.configuration;
    }

    private FileMoveExistingStrategy createDefaultFtpMoveExistingFileStrategy() {
        return new SmbDefaultMoveExistingFileStrategy();
    }

    public GenericFileConsumer<FileIdBothDirectoryInformation> createConsumer(Processor processor) throws Exception {
        if (this.isNoop() && !this.isIdempotentSet()) {
            LOG.info("Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotentSet() && Boolean.TRUE.equals(this.isIdempotent()) && this.idempotentRepository == null) {
            LOG.info("Using default memory based idempotent repository with cache max size: {}", (Object)1000);
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository((int)1000);
        }
        if (ObjectHelper.isNotEmpty((String)this.getReadLock())) {
            this.readLockCheck();
        }
        SmbConsumer consumer = new SmbConsumer(this, processor, this.createOperations(), this.processStrategy != null ? this.processStrategy : this.createGenericFileStrategy());
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setEagerLimitMaxMessagesPerPoll(this.isEagerMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    private void readLockCheck() {
        String valid = "none,rename,changed";
        String[] arr = valid.split(",");
        boolean matched = Arrays.stream(arr).anyMatch(n -> n.equals(this.getReadLock()));
        if (!matched) {
            throw new IllegalArgumentException("ReadLock invalid: " + this.getReadLock() + ", must be one of: " + valid);
        }
    }

    public GenericFileOperations<FileIdBothDirectoryInformation> createOperations() {
        SmbOperations operations = new SmbOperations(this.configuration);
        operations.setEndpoint(this);
        return operations;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating GenericFilePollingConsumer with queueSize: {} blockWhenFull: {} blockTimeout: {}", new Object[]{this.getPollingConsumerQueueSize(), this.isPollingConsumerBlockWhenFull(), this.getPollingConsumerBlockTimeout()});
        }
        GenericFilePollingConsumer result = new GenericFilePollingConsumer((GenericFileEndpoint)this);
        result.setBlockWhenFull(this.isPollingConsumerBlockWhenFull());
        result.setBlockTimeout(this.getPollingConsumerBlockTimeout());
        return result;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("SmbConfiguration expected");
        }
        this.configuration = (SmbConfiguration)configuration;
        super.setConfiguration(configuration);
    }

    public Exchange createExchange(GenericFile<FileIdBothDirectoryInformation> file) {
        Exchange answer = super.createExchange();
        if (file != null) {
            file.bindToExchange(answer);
        }
        return answer;
    }
}

