/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.ext.PropertyPlaceholderExt;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.BlueprintContainerBeanRepository;
import org.apache.camel.blueprint.BlueprintPropertiesSource;
import org.apache.camel.blueprint.CamelConsumerTemplateFactoryBean;
import org.apache.camel.blueprint.CamelEndpointFactoryBean;
import org.apache.camel.blueprint.CamelErrorHandlerFactoryBean;
import org.apache.camel.blueprint.CamelFluentProducerTemplateFactoryBean;
import org.apache.camel.blueprint.CamelProducerTemplateFactoryBean;
import org.apache.camel.blueprint.CamelProxyFactoryBean;
import org.apache.camel.blueprint.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.blueprint.CamelThreadPoolFactoryBean;
import org.apache.camel.blueprint.ContextScanRouteBuilderFinder;
import org.apache.camel.blueprint.PackageScanRouteBuilderFinder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiEventAdminNotifier;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelRouteControllerDefinition;
import org.apache.camel.core.xml.CamelServiceExporterDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.GlobalOptionsDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateContextRefDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformersDefinition;
import org.apache.camel.model.validator.ValidatorsDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.StringHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends AbstractCamelContextFactoryBean<BlueprintCamelContext> {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBean.class);
    @XmlAttribute(name="depends-on")
    private String dependsOn;
    @XmlAttribute
    @Metadata(defaultValue="Default")
    private StartupSummaryLevel startupSummaryLevel;
    @XmlAttribute
    private String trace;
    @XmlAttribute
    private String backlogTrace;
    @XmlAttribute
    private String tracePattern;
    @XmlAttribute
    private String debug;
    @XmlAttribute
    private String messageHistory;
    @XmlAttribute
    private String logMask;
    @XmlAttribute
    private String logExhaustedMessageBody;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String streamCache = "false";
    @XmlAttribute
    private String delayer;
    @XmlAttribute
    private String errorHandlerRef;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String autoStartup = "true";
    @XmlAttribute
    private String useMDCLogging;
    @XmlAttribute
    private String mdcLoggingKeysPattern;
    @XmlAttribute
    private String useDataType;
    @XmlAttribute
    private String useBreadcrumb;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String beanPostProcessorEnabled;
    @XmlAttribute
    private String allowUseOriginalMessage;
    @XmlAttribute
    private String caseInsensitiveHeaders;
    @XmlAttribute
    private String autowiredEnabled;
    @XmlAttribute
    private String runtimeEndpointRegistryEnabled;
    @XmlAttribute
    private String managementNamePattern;
    @XmlAttribute
    private String threadNamePattern;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean useBlueprintPropertyResolver;
    @XmlAttribute
    private ShutdownRoute shutdownRoute;
    @XmlAttribute
    private ShutdownRunningTask shutdownRunningTask;
    @XmlAttribute
    private String loadTypeConverters;
    @XmlAttribute
    private String typeConverterStatisticsEnabled;
    @XmlAttribute
    private String inflightRepositoryBrowseEnabled;
    @XmlAttribute
    private TypeConverterExists typeConverterExists;
    @XmlAttribute
    private LoggingLevel typeConverterExistsLoggingLevel;
    @XmlElement(name="globalOptions")
    private GlobalOptionsDefinition globalOptions;
    @XmlElement(name="propertyPlaceholder", type=CamelPropertyPlaceholderDefinition.class)
    private CamelPropertyPlaceholderDefinition camelPropertyPlaceholder;
    @XmlElement(name="package")
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class)
    private PackageScanDefinition packageScan;
    @XmlElement(name="contextScan", type=ContextScanDefinition.class)
    private ContextScanDefinition contextScan;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class)
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElement(name="streamCaching", type=CamelStreamCachingStrategyDefinition.class)
    private CamelStreamCachingStrategyDefinition camelStreamCachingStrategy;
    @XmlElement(name="routeController", type=CamelRouteControllerDefinition.class)
    private CamelRouteControllerDefinition camelRouteController;
    @XmlElements(value={@XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class), @XmlElement(name="fluentTemplate", type=CamelFluentProducerTemplateFactoryBean.class), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class), @XmlElement(name="proxy", type=CamelProxyFactoryBean.class), @XmlElement(name="errorHandler", type=CamelErrorHandlerFactoryBean.class)})
    private List<AbstractCamelFactoryBean<?>> beansFactory;
    @XmlElements(value={@XmlElement(name="export", type=CamelServiceExporterDefinition.class)})
    private List<?> beans;
    @XmlElement(name="defaultServiceCallConfiguration")
    private ServiceCallConfigurationDefinition defaultServiceCallConfiguration;
    @XmlElement(name="serviceCallConfiguration", type=ServiceCallConfigurationDefinition.class)
    private List<ServiceCallConfigurationDefinition> serviceCallConfigurations;
    @XmlElement(name="defaultHystrixConfiguration")
    private HystrixConfigurationDefinition defaultHystrixConfiguration;
    @XmlElement(name="hystrixConfiguration", type=HystrixConfigurationDefinition.class)
    private List<HystrixConfigurationDefinition> hystrixConfigurations;
    @XmlElement(name="defaultResilience4jConfiguration")
    private Resilience4jConfigurationDefinition defaultResilience4jConfiguration;
    @XmlElement(name="resilience4jConfiguration", type=Resilience4jConfigurationDefinition.class)
    private List<Resilience4jConfigurationDefinition> resilience4jConfigurations;
    @XmlElement(name="defaultFaultToleranceConfiguration")
    private FaultToleranceConfigurationDefinition defaultFaultToleranceConfiguration;
    @XmlElement(name="faultToleranceConfiguration", type=FaultToleranceConfigurationDefinition.class)
    private List<FaultToleranceConfigurationDefinition> faultToleranceConfigurations;
    @XmlElement(name="routeTemplateContextRef")
    private List<RouteTemplateContextRefDefinition> routeTemplateRefs = new ArrayList<RouteTemplateContextRefDefinition>();
    @XmlElement(name="routeBuilder")
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="routeContextRef")
    private List<RouteContextRefDefinition> routeRefs = new ArrayList<RouteContextRefDefinition>();
    @XmlElement(name="restContextRef")
    private List<RestContextRefDefinition> restRefs = new ArrayList<RestContextRefDefinition>();
    @XmlElement(name="threadPoolProfile")
    private List<ThreadPoolProfileDefinition> threadPoolProfiles;
    @XmlElement(name="threadPool")
    private List<CamelThreadPoolFactoryBean> threadPools;
    @XmlElement(name="endpoint")
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats")
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="transformers")
    private TransformersDefinition transformers;
    @XmlElement(name="validators")
    private ValidatorsDefinition validators;
    @XmlElement(name="redeliveryPolicyProfile")
    private List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies;
    @XmlElement(name="onException")
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion")
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept")
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom")
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint")
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="restConfiguration")
    private RestConfigurationDefinition restConfiguration;
    @XmlElement(name="rest")
    private List<RestDefinition> rests = new ArrayList<RestDefinition>();
    @XmlElement(name="routeTemplate")
    private List<RouteTemplateDefinition> routeTemplates = new ArrayList<RouteTemplateDefinition>();
    @XmlElement(name="route")
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private BlueprintCamelContext context;
    @XmlTransient
    private BlueprintContainer blueprintContainer;
    @XmlTransient
    private BundleContext bundleContext;
    @XmlTransient
    private boolean implicitId;
    @XmlTransient
    private OsgiCamelContextPublisher osgiCamelContextPublisher;

    public Class<BlueprintCamelContext> getObjectType() {
        return BlueprintCamelContext.class;
    }

    public BlueprintCamelContext getContext(boolean create) {
        if (this.context == null && create) {
            this.context = this.createContext();
            if (!this.isImplicitId()) {
                this.context.setName(this.getId());
            }
        }
        return this.context;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected BlueprintCamelContext createContext() {
        return new BlueprintCamelContext(this.bundleContext, this.blueprintContainer);
    }

    protected void initCustomRegistry(BlueprintCamelContext context) {
        Registry registry = this.getBeanForType(Registry.class);
        if (registry != null) {
            LOG.info("Using custom Registry: {}", (Object)registry);
            context.setRegistry(registry);
        }
    }

    protected <S> S getBeanForType(Class<S> clazz) {
        Collection<S> objects = BlueprintContainerBeanRepository.lookupByType(this.blueprintContainer, clazz).values();
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        return null;
    }

    protected void initPropertyPlaceholder() throws Exception {
        super.initPropertyPlaceholder();
        if (this.isUseBlueprintPropertyResolver()) {
            Properties extra;
            PropertiesComponent pc = (PropertiesComponent)((BlueprintCamelContext)this.getContext()).getPropertiesComponent();
            ServiceReference ref = this.bundleContext.getServiceReference(PropertiesComponent.OVERRIDE_PROPERTIES);
            if (ref != null && (extra = (Properties)this.bundleContext.getService(ref)) != null) {
                pc.setOverrideProperties(extra);
            }
            ArrayList<String> ids = new ArrayList();
            for (String bp : pc.getLocations()) {
                String resolver = StringHelper.before((String)bp, (String)":");
                String path = StringHelper.after((String)bp, (String)":");
                if (!"blueprint".equals(resolver)) continue;
                ids.add(path);
            }
            if (ids.isEmpty()) {
                ids = this.lookupPropertyPlaceholderIds();
            }
            pc.addPropertiesSource((PropertiesSource)new BlueprintPropertiesSource(this.blueprintContainer, ids));
        }
    }

    private List<String> lookupPropertyPlaceholderIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object componentId : this.blueprintContainer.getComponentIds()) {
            Class clazz;
            String id = (String)componentId;
            ComponentMetadata meta = this.blueprintContainer.getComponentMetadata(id);
            if (!(meta instanceof ExtendedBeanMetadata) || (clazz = ((ExtendedBeanMetadata)meta).getRuntimeClass()) == null || !PropertyPlaceholderExt.class.isAssignableFrom(clazz)) continue;
            ids.add(id);
        }
        return ids;
    }

    protected void initBeanPostProcessor(BlueprintCamelContext context) {
    }

    protected void postProcessBeforeInit(RouteBuilder builder) {
    }

    protected void findRouteBuildersByPackageScan(String[] packages, PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ((BlueprintCamelContext)this.getContext()).getPackageScanClassResolver().addFilter(filter);
        BundleDelegatingClassLoader classLoader = new BundleDelegatingClassLoader(this.bundleContext.getBundle());
        PackageScanRouteBuilderFinder finder = new PackageScanRouteBuilderFinder((BlueprintCamelContext)this.getContext(), packages, (ClassLoader)classLoader, ((BlueprintCamelContext)this.getContext()).getPackageScanClassResolver());
        finder.appendBuilders(builders);
        ((BlueprintCamelContext)this.getContext()).getPackageScanClassResolver().removeFilter(filter);
    }

    protected void findRouteBuildersByContextScan(PackageScanFilter filter, boolean includeNonSingletons, List<RoutesBuilder> builders) throws Exception {
        ContextScanRouteBuilderFinder finder = new ContextScanRouteBuilderFinder((BlueprintCamelContext)this.getContext(), filter, includeNonSingletons);
        finder.appendBuilders(builders);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        BundleDelegatingClassLoader cl = new BundleDelegatingClassLoader(this.bundleContext.getBundle());
        LOG.debug("Set the application context classloader to: {}", (Object)cl);
        ((BlueprintCamelContext)this.getContext()).setApplicationContextClassLoader((ClassLoader)cl);
        this.osgiCamelContextPublisher = new OsgiCamelContextPublisher(this.bundleContext);
        this.osgiCamelContextPublisher.start();
        ((BlueprintCamelContext)this.getContext()).getManagementStrategy().addEventNotifier((EventNotifier)this.osgiCamelContextPublisher);
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            ((BlueprintCamelContext)this.getContext()).getManagementStrategy().addEventNotifier((EventNotifier)new OsgiEventAdminNotifier(this.bundleContext));
        }
        catch (Throwable t) {
            LOG.debug("EventAdmin package is not available, just don't use it");
        }
        this.setupRoutes();
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.osgiCamelContextPublisher != null) {
            this.osgiCamelContextPublisher.shutdown();
        }
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getUseMDCLogging() {
        return this.useMDCLogging;
    }

    public void setUseMDCLogging(String useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    public String getMDCLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    public void setMDCLoggingKeysPattern(String mdcLoggingKeysPattern) {
        this.mdcLoggingKeysPattern = mdcLoggingKeysPattern;
    }

    public String getUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(String useDataType) {
        this.useDataType = useDataType;
    }

    public String getUseBreadcrumb() {
        return this.useBreadcrumb;
    }

    public void setUseBreadcrumb(String useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    public String getBeanPostProcessorEnabled() {
        return this.beanPostProcessorEnabled;
    }

    public void setBeanPostProcessorEnabled(String beanPostProcessorEnabled) {
        this.beanPostProcessorEnabled = beanPostProcessorEnabled;
    }

    public String getAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage;
    }

    public void setAllowUseOriginalMessage(String allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    public String getCaseInsensitiveHeaders() {
        return this.caseInsensitiveHeaders;
    }

    public void setCaseInsensitiveHeaders(String caseInsensitiveHeaders) {
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    public String getAutowiredEnabled() {
        return this.autowiredEnabled;
    }

    public void setAutowiredEnabled(String autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getRuntimeEndpointRegistryEnabled() {
        return this.runtimeEndpointRegistryEnabled;
    }

    public void setRuntimeEndpointRegistryEnabled(String runtimeEndpointRegistryEnabled) {
        this.runtimeEndpointRegistryEnabled = runtimeEndpointRegistryEnabled;
    }

    public String getManagementNamePattern() {
        return this.managementNamePattern;
    }

    public void setManagementNamePattern(String managementNamePattern) {
        this.managementNamePattern = managementNamePattern;
    }

    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    public String getLoadTypeConverters() {
        return this.loadTypeConverters;
    }

    public void setLoadTypeConverters(String loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    public String getTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled;
    }

    public void setTypeConverterStatisticsEnabled(String typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this.camelPropertyPlaceholder;
    }

    public void setCamelPropertyPlaceholder(CamelPropertyPlaceholderDefinition camelPropertyPlaceholder) {
        this.camelPropertyPlaceholder = camelPropertyPlaceholder;
    }

    public List<RouteTemplateContextRefDefinition> getRouteTemplateRefs() {
        return this.routeTemplateRefs;
    }

    public void setRouteTemplateRefs(List<RouteTemplateContextRefDefinition> routeTemplateRefs) {
        this.routeTemplateRefs = routeTemplateRefs;
    }

    public List<RouteContextRefDefinition> getRouteRefs() {
        return this.routeRefs;
    }

    public void setRouteRefs(List<RouteContextRefDefinition> routeRefs) {
        this.routeRefs = routeRefs;
    }

    public List<RestContextRefDefinition> getRestRefs() {
        return this.restRefs;
    }

    public void setRestRefs(List<RestContextRefDefinition> restRefs) {
        this.restRefs = restRefs;
    }

    public List<CamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies() {
        return this.redeliveryPolicies;
    }

    public void setRedeliveryPolicies(List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies) {
        this.redeliveryPolicies = redeliveryPolicies;
    }

    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this.threadPoolProfiles;
    }

    public void setThreadPoolProfiles(List<ThreadPoolProfileDefinition> threadPoolProfiles) {
        this.threadPoolProfiles = threadPoolProfiles;
    }

    public List<CamelThreadPoolFactoryBean> getThreadPools() {
        return this.threadPools;
    }

    public void setThreadPools(List<CamelThreadPoolFactoryBean> threadPools) {
        this.threadPools = threadPools;
    }

    public StartupSummaryLevel getStartupSummaryLevel() {
        return this.startupSummaryLevel;
    }

    public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
        this.startupSummaryLevel = startupSummaryLevel;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public String getBacklogTrace() {
        return this.backlogTrace;
    }

    public void setBacklogTrace(String backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    public String getTracePattern() {
        return this.tracePattern;
    }

    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public String getMessageHistory() {
        return this.messageHistory;
    }

    public void setMessageHistory(String messageHistory) {
        this.messageHistory = messageHistory;
    }

    public String getLogMask() {
        return this.logMask;
    }

    public void setLogMask(String logMask) {
        this.logMask = logMask;
    }

    public String getLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(String logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public String getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    public String getDelayer() {
        return this.delayer;
    }

    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public GlobalOptionsDefinition getGlobalOptions() {
        return this.globalOptions;
    }

    public void setGlobalOptions(GlobalOptionsDefinition globalOptions) {
        this.globalOptions = globalOptions;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    public ContextScanDefinition getContextScan() {
        return this.contextScan;
    }

    public void setContextScan(ContextScanDefinition contextScan) {
        this.contextScan = contextScan;
    }

    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition camelJMXAgent) {
        this.camelJMXAgent = camelJMXAgent;
    }

    public CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy() {
        return this.camelStreamCachingStrategy;
    }

    public void setCamelStreamCachingStrategy(CamelStreamCachingStrategyDefinition camelStreamCachingStrategy) {
        this.camelStreamCachingStrategy = camelStreamCachingStrategy;
    }

    public CamelRouteControllerDefinition getCamelRouteController() {
        return this.camelRouteController;
    }

    public void setCamelRouteController(CamelRouteControllerDefinition camelRouteController) {
        this.camelRouteController = camelRouteController;
    }

    public List<AbstractCamelFactoryBean<?>> getBeansFactory() {
        return this.beansFactory;
    }

    public void setBeansFactory(List<AbstractCamelFactoryBean<?>> beansFactory) {
        this.beansFactory = beansFactory;
    }

    public List<?> getBeans() {
        return this.beans;
    }

    public void setBeans(List<?> beans) {
        this.beans = beans;
    }

    public ServiceCallConfigurationDefinition getDefaultServiceCallConfiguration() {
        return this.defaultServiceCallConfiguration;
    }

    public void setDefaultServiceCallConfiguration(ServiceCallConfigurationDefinition defaultServiceCallConfiguration) {
        this.defaultServiceCallConfiguration = defaultServiceCallConfiguration;
    }

    public List<ServiceCallConfigurationDefinition> getServiceCallConfigurations() {
        return this.serviceCallConfigurations;
    }

    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> serviceCallConfigurations) {
        this.serviceCallConfigurations = serviceCallConfigurations;
    }

    public HystrixConfigurationDefinition getDefaultHystrixConfiguration() {
        return this.defaultHystrixConfiguration;
    }

    public void setDefaultHystrixConfiguration(HystrixConfigurationDefinition defaultHystrixConfiguration) {
        this.defaultHystrixConfiguration = defaultHystrixConfiguration;
    }

    public List<HystrixConfigurationDefinition> getHystrixConfigurations() {
        return this.hystrixConfigurations;
    }

    public void setHystrixConfigurations(List<HystrixConfigurationDefinition> hystrixConfigurations) {
        this.hystrixConfigurations = hystrixConfigurations;
    }

    public Resilience4jConfigurationDefinition getDefaultResilience4jConfiguration() {
        return this.defaultResilience4jConfiguration;
    }

    public void setDefaultResilience4jConfiguration(Resilience4jConfigurationDefinition defaultResilience4jConfiguration) {
        this.defaultResilience4jConfiguration = defaultResilience4jConfiguration;
    }

    public List<Resilience4jConfigurationDefinition> getResilience4jConfigurations() {
        return this.resilience4jConfigurations;
    }

    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> resilience4jConfigurations) {
        this.resilience4jConfigurations = resilience4jConfigurations;
    }

    public FaultToleranceConfigurationDefinition getDefaultFaultToleranceConfiguration() {
        return this.defaultFaultToleranceConfiguration;
    }

    public void setDefaultFaultToleranceConfiguration(FaultToleranceConfigurationDefinition defaultFaultToleranceConfiguration) {
        this.defaultFaultToleranceConfiguration = defaultFaultToleranceConfiguration;
    }

    public List<FaultToleranceConfigurationDefinition> getFaultToleranceConfigurations() {
        return this.faultToleranceConfigurations;
    }

    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> faultToleranceConfigurations) {
        this.faultToleranceConfigurations = faultToleranceConfigurations;
    }

    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    public List<CamelEndpointFactoryBean> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<CamelEndpointFactoryBean> endpoints) {
        this.endpoints = endpoints;
    }

    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    public void setTransformers(TransformersDefinition transformers) {
        this.transformers = transformers;
    }

    public TransformersDefinition getTransformers() {
        return this.transformers;
    }

    public void setValidators(ValidatorsDefinition validators) {
        this.validators = validators;
    }

    public ValidatorsDefinition getValidators() {
        return this.validators;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    public List<RouteTemplateDefinition> getRouteTemplates() {
        return this.routeTemplates;
    }

    public void setRouteTemplates(List<RouteTemplateDefinition> routeTemplates) {
        this.routeTemplates = routeTemplates;
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public List<RestDefinition> getRests() {
        return this.rests;
    }

    public void setRests(List<RestDefinition> rests) {
        this.rests = rests;
    }

    public RestConfigurationDefinition getRestConfiguration() {
        return this.restConfiguration;
    }

    public void setRestConfiguration(RestConfigurationDefinition restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    public boolean isImplicitId() {
        return this.implicitId;
    }

    public void setImplicitId(boolean flag) {
        this.implicitId = flag;
    }

    public Boolean getUseBlueprintPropertyResolver() {
        return this.useBlueprintPropertyResolver;
    }

    public void setUseBlueprintPropertyResolver(Boolean useBlueprintPropertyResolver) {
        this.useBlueprintPropertyResolver = useBlueprintPropertyResolver;
    }

    public boolean isUseBlueprintPropertyResolver() {
        return this.useBlueprintPropertyResolver == null || this.useBlueprintPropertyResolver != false;
    }

    public String getInflightRepositoryBrowseEnabled() {
        return this.inflightRepositoryBrowseEnabled;
    }

    public void setInflightRepositoryBrowseEnabled(String inflightRepositoryBrowseEnabled) {
        this.inflightRepositoryBrowseEnabled = inflightRepositoryBrowseEnabled;
    }
}

