/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.AllowAllAuthorizer;
import org.apache.cassandra.auth.AllowAllInternodeAuthenticator;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DefsTables;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.IAllocator;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointSnitchInfo;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.scheduler.NoScheduler;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.memory.HeapPool;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.apache.cassandra.utils.memory.NativePool;
import org.apache.cassandra.utils.memory.SlabPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseDescriptor.class);
    private static final int MAX_NUM_TOKENS = 1536;
    private static IEndpointSnitch snitch;
    private static InetAddress listenAddress;
    private static InetAddress broadcastAddress;
    private static InetAddress rpcAddress;
    private static InetAddress broadcastRpcAddress;
    private static SeedProvider seedProvider;
    private static IInternodeAuthenticator internodeAuthenticator;
    private static IPartitioner partitioner;
    private static String paritionerName;
    private static Config.DiskAccessMode indexAccessMode;
    private static Config conf;
    private static IAuthenticator authenticator;
    private static IAuthorizer authorizer;
    private static IRequestScheduler requestScheduler;
    private static Config.RequestSchedulerId requestSchedulerId;
    private static RequestSchedulerOptions requestSchedulerOptions;
    private static long keyCacheSizeInMB;
    private static long counterCacheSizeInMB;
    private static IAllocator memoryAllocator;
    private static long indexSummaryCapacityInMB;
    private static String localDC;
    private static Comparator<InetAddress> localComparator;

    @VisibleForTesting
    public static Config loadConfig() throws ConfigurationException {
        String loaderClass = System.getProperty("cassandra.config.loader");
        ConfigurationLoader loader = loaderClass == null ? new YamlConfigurationLoader() : (ConfigurationLoader)FBUtilities.construct(loaderClass, "configuration loading");
        return loader.loadConfig();
    }

    private static InetAddress getNetworkInterfaceAddress(String intf, String configName, boolean preferIPv6) throws ConfigurationException {
        try {
            NetworkInterface ni = NetworkInterface.getByName(intf);
            if (ni == null) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" could not be found");
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" was found, but had no addresses");
            }
            InetAddress retval = null;
            while (addrs.hasMoreElements()) {
                InetAddress temp = addrs.nextElement();
                if (preferIPv6 && temp.getClass() == Inet6Address.class) {
                    return temp;
                }
                if (!preferIPv6 && temp.getClass() == Inet4Address.class) {
                    return temp;
                }
                if (retval != null) continue;
                retval = temp;
            }
            return retval;
        }
        catch (SocketException e) {
            throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" caused an exception", e);
        }
    }

    @VisibleForTesting
    static void applyAddressConfig(Config config) throws ConfigurationException {
        listenAddress = null;
        rpcAddress = null;
        broadcastAddress = null;
        broadcastRpcAddress = null;
        if (config.listen_address != null && config.listen_interface != null) {
            throw new ConfigurationException("Set listen_address OR listen_interface, not both");
        }
        if (config.listen_address != null) {
            try {
                listenAddress = InetAddress.getByName(config.listen_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown listen_address '" + config.listen_address + "'");
            }
            if (listenAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("listen_address cannot be a wildcard address (" + config.listen_address + ")!");
            }
        } else if (config.listen_interface != null) {
            listenAddress = DatabaseDescriptor.getNetworkInterfaceAddress(config.listen_interface, "listen_interface", config.listen_interface_prefer_ipv6);
        }
        if (config.broadcast_address != null) {
            try {
                broadcastAddress = InetAddress.getByName(config.broadcast_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_address '" + config.broadcast_address + "'");
            }
            if (broadcastAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_address cannot be a wildcard address (" + config.broadcast_address + ")!");
            }
        }
        if (config.rpc_address != null && config.rpc_interface != null) {
            throw new ConfigurationException("Set rpc_address OR rpc_interface, not both");
        }
        if (config.rpc_address != null) {
            try {
                rpcAddress = InetAddress.getByName(config.rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host in rpc_address " + config.rpc_address);
            }
        } else {
            rpcAddress = config.rpc_interface != null ? DatabaseDescriptor.getNetworkInterfaceAddress(config.rpc_interface, "rpc_interface", config.rpc_interface_prefer_ipv6) : FBUtilities.getLocalAddress();
        }
        if (config.broadcast_rpc_address != null) {
            try {
                broadcastRpcAddress = InetAddress.getByName(config.broadcast_rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_rpc_address '" + config.broadcast_rpc_address + "'");
            }
            if (broadcastRpcAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_rpc_address cannot be a wildcard address (" + config.broadcast_rpc_address + ")!");
            }
        } else {
            if (rpcAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("If rpc_address is set to a wildcard address (" + config.rpc_address + "), then " + "you must set broadcast_rpc_address to a value other than " + config.rpc_address);
            }
            broadcastRpcAddress = rpcAddress;
        }
    }

    private static void applyConfig(Config config) throws ConfigurationException {
        conf = config;
        if (DatabaseDescriptor.conf.commitlog_sync == null) {
            throw new ConfigurationException("Missing required directive CommitLogSync");
        }
        if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.batch) {
            if (DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms == null) {
                throw new ConfigurationException("Missing value for commitlog_sync_batch_window_in_ms: Double expected.");
            }
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms != null) {
                throw new ConfigurationException("Batch sync specified, but commitlog_sync_period_in_ms found. Only specify commitlog_sync_batch_window_in_ms when using batch sync");
            }
            logger.debug("Syncing log with a batch window of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms);
        } else {
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms == null) {
                throw new ConfigurationException("Missing value for commitlog_sync_period_in_ms: Integer expected");
            }
            if (DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms != null) {
                throw new ConfigurationException("commitlog_sync_period_in_ms specified, but commitlog_sync_batch_window_in_ms found.  Only specify commitlog_sync_period_in_ms when using periodic sync.");
            }
            logger.debug("Syncing log with a period of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_period_in_ms);
        }
        if (DatabaseDescriptor.conf.commitlog_total_space_in_mb == null) {
            DatabaseDescriptor.conf.commitlog_total_space_in_mb = DatabaseDescriptor.hasLargeAddressSpace() ? 8192 : 32;
        }
        if (FBUtilities.isWindows()) {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
            logger.info("Windows environment detected.  DiskAccessMode set to {}, indexAccessMode {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.auto) {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = DatabaseDescriptor.hasLargeAddressSpace() ? Config.DiskAccessMode.mmap : Config.DiskAccessMode.standard;
            logger.info("DiskAccessMode 'auto' determined to be {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap_index_only) {
            DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
            indexAccessMode = Config.DiskAccessMode.mmap;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        }
        if (DatabaseDescriptor.conf.authenticator != null) {
            authenticator = FBUtilities.newAuthenticator(DatabaseDescriptor.conf.authenticator);
        }
        if (DatabaseDescriptor.conf.authorizer != null) {
            authorizer = FBUtilities.newAuthorizer(DatabaseDescriptor.conf.authorizer);
        }
        if (authenticator instanceof AllowAllAuthenticator && !(authorizer instanceof AllowAllAuthorizer)) {
            throw new ConfigurationException("AllowAllAuthenticator can't be used with " + DatabaseDescriptor.conf.authorizer);
        }
        internodeAuthenticator = DatabaseDescriptor.conf.internode_authenticator != null ? (IInternodeAuthenticator)FBUtilities.construct(DatabaseDescriptor.conf.internode_authenticator, "internode_authenticator") : new AllowAllInternodeAuthenticator();
        authenticator.validateConfiguration();
        authorizer.validateConfiguration();
        internodeAuthenticator.validateConfiguration();
        if (DatabaseDescriptor.conf.partitioner == null) {
            throw new ConfigurationException("Missing directive: partitioner");
        }
        try {
            partitioner = FBUtilities.newPartitioner(System.getProperty("cassandra.partitioner", DatabaseDescriptor.conf.partitioner));
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid partitioner class " + DatabaseDescriptor.conf.partitioner);
        }
        paritionerName = partitioner.getClass().getCanonicalName();
        if (DatabaseDescriptor.conf.gc_warn_threshold_in_ms < 0) {
            throw new ConfigurationException("gc_warn_threshold_in_ms must be a positive integer");
        }
        if (DatabaseDescriptor.conf.max_hint_window_in_ms == null) {
            throw new ConfigurationException("max_hint_window_in_ms cannot be set to null");
        }
        if (DatabaseDescriptor.conf.phi_convict_threshold < 5.0 || DatabaseDescriptor.conf.phi_convict_threshold > 16.0) {
            throw new ConfigurationException("phi_convict_threshold must be between 5 and 16");
        }
        if (DatabaseDescriptor.conf.concurrent_reads != null && DatabaseDescriptor.conf.concurrent_reads < 2) {
            throw new ConfigurationException("concurrent_reads must be at least 2");
        }
        if (DatabaseDescriptor.conf.concurrent_writes != null && DatabaseDescriptor.conf.concurrent_writes < 2) {
            throw new ConfigurationException("concurrent_writes must be at least 2");
        }
        if (DatabaseDescriptor.conf.concurrent_counter_writes != null && DatabaseDescriptor.conf.concurrent_counter_writes < 2) {
            throw new ConfigurationException("concurrent_counter_writes must be at least 2");
        }
        if (DatabaseDescriptor.conf.concurrent_replicates != null) {
            logger.warn("concurrent_replicates has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.file_cache_size_in_mb == null) {
            DatabaseDescriptor.conf.file_cache_size_in_mb = Math.min(512, (int)(Runtime.getRuntime().maxMemory() / 0x400000L));
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb == null) {
            DatabaseDescriptor.conf.memtable_offheap_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x400000L);
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb < 0) {
            throw new ConfigurationException("memtable_offheap_space_in_mb must be positive");
        }
        if (DatabaseDescriptor.conf.memtable_heap_space_in_mb == null) {
            DatabaseDescriptor.conf.memtable_heap_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x400000L);
        }
        if (DatabaseDescriptor.conf.memtable_heap_space_in_mb <= 0) {
            throw new ConfigurationException("memtable_heap_space_in_mb must be positive");
        }
        logger.info("Global memtable on-heap threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_heap_space_in_mb);
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb == 0) {
            logger.info("Global memtable off-heap threshold is disabled, HeapAllocator will be used instead");
        } else {
            logger.info("Global memtable off-heap threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_offheap_space_in_mb);
        }
        DatabaseDescriptor.applyAddressConfig(config);
        if (DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb <= 0) {
            throw new ConfigurationException("thrift_framed_transport_size_in_mb must be positive");
        }
        if (DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb <= 0) {
            throw new ConfigurationException("native_transport_max_frame_size_in_mb must be positive");
        }
        if ("hsha".equals(DatabaseDescriptor.conf.rpc_server_type) && DatabaseDescriptor.conf.rpc_max_threads == Integer.MAX_VALUE) {
            throw new ConfigurationException("The hsha rpc_server_type is not compatible with an rpc_max_threads setting of 'unlimited'.  Please see the comments in cassandra.yaml for rpc_server_type and rpc_max_threads.");
        }
        if ("hsha".equals(DatabaseDescriptor.conf.rpc_server_type) && DatabaseDescriptor.conf.rpc_max_threads > FBUtilities.getAvailableProcessors() * 2 + 1024) {
            logger.warn("rpc_max_threads setting of {} may be too high for the hsha server and cause unnecessary thread contention, reducing performance", (Object)DatabaseDescriptor.conf.rpc_max_threads);
        }
        if (DatabaseDescriptor.conf.endpoint_snitch == null) {
            throw new ConfigurationException("Missing endpoint_snitch directive");
        }
        snitch = DatabaseDescriptor.createEndpointSnitch(DatabaseDescriptor.conf.endpoint_snitch);
        EndpointSnitchInfo.create();
        localDC = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
        localComparator = new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress endpoint1, InetAddress endpoint2) {
                boolean local1 = localDC.equals(snitch.getDatacenter(endpoint1));
                boolean local2 = localDC.equals(snitch.getDatacenter(endpoint2));
                if (local1 && !local2) {
                    return -1;
                }
                if (local2 && !local1) {
                    return 1;
                }
                return 0;
            }
        };
        requestSchedulerOptions = DatabaseDescriptor.conf.request_scheduler_options;
        if (DatabaseDescriptor.conf.request_scheduler != null) {
            try {
                if (requestSchedulerOptions == null) {
                    requestSchedulerOptions = new RequestSchedulerOptions();
                }
                Class<?> cls = Class.forName(DatabaseDescriptor.conf.request_scheduler);
                requestScheduler = (IRequestScheduler)cls.getConstructor(RequestSchedulerOptions.class).newInstance(requestSchedulerOptions);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Invalid Request Scheduler class " + DatabaseDescriptor.conf.request_scheduler);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate request scheduler", e);
            }
        } else {
            requestScheduler = new NoScheduler();
        }
        requestSchedulerId = DatabaseDescriptor.conf.request_scheduler_id == Config.RequestSchedulerId.keyspace ? DatabaseDescriptor.conf.request_scheduler_id : Config.RequestSchedulerId.keyspace;
        if (DatabaseDescriptor.conf.commitlog_directory == null) {
            DatabaseDescriptor.conf.commitlog_directory = System.getProperty("cassandra.storagedir", null);
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory is missing and -Dcassandra.storagedir is not set");
            }
            DatabaseDescriptor.conf.commitlog_directory = DatabaseDescriptor.conf.commitlog_directory + File.separator + "commitlog";
        }
        if (DatabaseDescriptor.conf.saved_caches_directory == null) {
            DatabaseDescriptor.conf.saved_caches_directory = System.getProperty("cassandra.storagedir", null);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory is missing and -Dcassandra.storagedir is not set");
            }
            DatabaseDescriptor.conf.saved_caches_directory = DatabaseDescriptor.conf.saved_caches_directory + File.separator + "saved_caches";
        }
        if (DatabaseDescriptor.conf.data_file_directories == null) {
            String defaultDataDir = System.getProperty("cassandra.storagedir", null);
            if (defaultDataDir == null) {
                throw new ConfigurationException("data_file_directories is not missing and -Dcassandra.storagedir is not set");
            }
            DatabaseDescriptor.conf.data_file_directories = new String[]{(String)defaultDataDir + File.separator + "data"};
        }
        for (String datadir : DatabaseDescriptor.conf.data_file_directories) {
            if (datadir.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                throw new ConfigurationException("commitlog_directory must not be the same as any data_file_directories");
            }
            if (!datadir.equals(DatabaseDescriptor.conf.saved_caches_directory)) continue;
            throw new ConfigurationException("saved_caches_directory must not be the same as any data_file_directories");
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the commitlog_directory");
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers == null) {
            DatabaseDescriptor.conf.memtable_flush_writers = Math.min(8, Math.max(2, Math.min(FBUtilities.getAvailableProcessors(), DatabaseDescriptor.conf.data_file_directories.length)));
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers < 1) {
            throw new ConfigurationException("memtable_flush_writers must be at least 1");
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold == null) {
            DatabaseDescriptor.conf.memtable_cleanup_threshold = Float.valueOf((float)(1.0 / (double)(1 + DatabaseDescriptor.conf.memtable_flush_writers)));
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.01f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be >= 0.01");
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() > 0.99f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be <= 0.99");
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.1f) {
            logger.warn("memtable_cleanup_threshold is set very low, which may cause performance degradation");
        }
        if (DatabaseDescriptor.conf.concurrent_compactors == null) {
            DatabaseDescriptor.conf.concurrent_compactors = Math.min(8, Math.max(2, Math.min(FBUtilities.getAvailableProcessors(), DatabaseDescriptor.conf.data_file_directories.length)));
        }
        if (DatabaseDescriptor.conf.concurrent_compactors <= 0) {
            throw new ConfigurationException("concurrent_compactors should be strictly greater than 0");
        }
        if (DatabaseDescriptor.conf.initial_token != null) {
            for (String token : DatabaseDescriptor.tokensFromString(DatabaseDescriptor.conf.initial_token)) {
                partitioner.getTokenFactory().validate(token);
            }
        }
        if (DatabaseDescriptor.conf.num_tokens == null) {
            DatabaseDescriptor.conf.num_tokens = 1;
        } else if (DatabaseDescriptor.conf.num_tokens > 1536) {
            throw new ConfigurationException(String.format("A maximum number of %d tokens per node is supported", 1536));
        }
        try {
            long l = keyCacheSizeInMB = DatabaseDescriptor.conf.key_cache_size_in_mb == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)), 100) : DatabaseDescriptor.conf.key_cache_size_in_mb;
            if (keyCacheSizeInMB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("key_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.key_cache_size_in_mb + "', supported values are <integer> >= 0.");
        }
        try {
            long l = counterCacheSizeInMB = DatabaseDescriptor.conf.counter_cache_size_in_mb == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.025 / 1024.0 / 1024.0)), 50) : DatabaseDescriptor.conf.counter_cache_size_in_mb;
            if (counterCacheSizeInMB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("counter_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.counter_cache_size_in_mb + "', supported values are <integer> >= 0.");
        }
        long l = indexSummaryCapacityInMB = DatabaseDescriptor.conf.index_summary_capacity_in_mb == null ? (long)Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)) : DatabaseDescriptor.conf.index_summary_capacity_in_mb;
        if (indexSummaryCapacityInMB < 0L) {
            throw new ConfigurationException("index_summary_capacity_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.index_summary_capacity_in_mb + "', it should be a non-negative integer.");
        }
        memoryAllocator = FBUtilities.newOffHeapAllocator(DatabaseDescriptor.conf.memory_allocator);
        if (DatabaseDescriptor.conf.encryption_options != null) {
            logger.warn("Please rename encryption_options as server_encryption_options in the yaml");
            DatabaseDescriptor.conf.server_encryption_options = DatabaseDescriptor.conf.encryption_options;
        }
        List<KSMetaData> systemKeyspaces = Arrays.asList(KSMetaData.systemKeyspace());
        assert (systemKeyspaces.size() == Schema.systemKeyspaceNames.size());
        for (KSMetaData ksmd : systemKeyspaces) {
            Schema.instance.load(ksmd);
        }
        if (DatabaseDescriptor.conf.seed_provider == null) {
            throw new ConfigurationException("seeds configuration is missing; a minimum of one seed is required.");
        }
        try {
            Class<?> seedProviderClass = Class.forName(DatabaseDescriptor.conf.seed_provider.class_name);
            seedProvider = (SeedProvider)seedProviderClass.getConstructor(Map.class).newInstance(DatabaseDescriptor.conf.seed_provider.parameters);
        }
        catch (Exception e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        if (seedProvider.getSeeds().size() == 0) {
            throw new ConfigurationException("The seed provider lists no seeds.");
        }
    }

    private static IEndpointSnitch createEndpointSnitch(String snitchClassName) throws ConfigurationException {
        if (!snitchClassName.contains(".")) {
            snitchClassName = "org.apache.cassandra.locator." + snitchClassName;
        }
        IEndpointSnitch snitch = (IEndpointSnitch)FBUtilities.construct(snitchClassName, "snitch");
        return DatabaseDescriptor.conf.dynamic_snitch != false ? new DynamicEndpointSnitch(snitch) : snitch;
    }

    public static void loadSchemas() {
        DatabaseDescriptor.loadSchemas(true);
    }

    public static void loadSchemas(boolean updateVersion) {
        ColumnFamilyStore schemaCFS = SystemKeyspace.schemaCFS("schema_keyspaces");
        if (schemaCFS.estimateKeys() == 0L) {
            logger.info("Couldn't detect any schema definitions in local storage.");
            if (DatabaseDescriptor.hasExistingNoSystemTables()) {
                logger.info("Found keyspace data in data directories. Consider using cqlsh to define your schema.");
            } else {
                logger.info("To create keyspaces and column families, see 'help create' in cqlsh.");
            }
        } else {
            Schema.instance.load(DefsTables.loadFromKeyspace());
        }
        if (updateVersion) {
            Schema.instance.updateVersion();
        }
    }

    private static boolean hasExistingNoSystemTables() {
        for (String dataDir : DatabaseDescriptor.getAllDataFileLocations()) {
            int dirCount;
            File dataPath = new File(dataDir);
            if (!dataPath.exists() || !dataPath.isDirectory() || (dirCount = dataPath.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !Schema.systemKeyspaceNames.contains((Object)pathname.getName());
                }
            }).length) <= 0) continue;
            return true;
        }
        return false;
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static IAuthorizer getAuthorizer() {
        return authorizer;
    }

    public static int getPermissionsValidity() {
        return DatabaseDescriptor.conf.permissions_validity_in_ms;
    }

    public static void setPermissionsValidity(int timeout) {
        DatabaseDescriptor.conf.permissions_validity_in_ms = timeout;
    }

    public static int getPermissionsCacheMaxEntries() {
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static int getPermissionsUpdateInterval() {
        return DatabaseDescriptor.conf.permissions_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.permissions_validity_in_ms : DatabaseDescriptor.conf.permissions_update_interval_in_ms;
    }

    public static void setPermissionsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.permissions_update_interval_in_ms = updateInterval;
    }

    public static int getThriftFramedTransportSize() {
        return DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb * 1024 * 1024;
    }

    public static void createAllDirectories() {
        try {
            if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified");
            }
            for (String dataFileDirectory : DatabaseDescriptor.conf.data_file_directories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory must be specified");
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.commitlog_directory);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory must be specified");
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.saved_caches_directory);
        }
        catch (ConfigurationException e) {
            logger.error("Fatal error: {}", (Object)e.getMessage());
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
        catch (FSWriteError e) {
            logger.error("Fatal error: {}", (Object)e.getMessage());
            System.err.println(e.getCause().getMessage() + "; unable to start server");
            System.exit(1);
        }
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static String getPartitionerName() {
        return paritionerName;
    }

    public static void setPartitioner(IPartitioner newPartitioner) {
        partitioner = newPartitioner;
    }

    public static IEndpointSnitch getEndpointSnitch() {
        return snitch;
    }

    public static void setEndpointSnitch(IEndpointSnitch eps) {
        snitch = eps;
    }

    public static IRequestScheduler getRequestScheduler() {
        return requestScheduler;
    }

    public static RequestSchedulerOptions getRequestSchedulerOptions() {
        return requestSchedulerOptions;
    }

    public static Config.RequestSchedulerId getRequestSchedulerId() {
        return requestSchedulerId;
    }

    public static int getColumnIndexSize() {
        return DatabaseDescriptor.conf.column_index_size_in_kb * 1024;
    }

    public static int getBatchSizeWarnThreshold() {
        return DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb * 1024;
    }

    public static Collection<String> getInitialTokens() {
        return DatabaseDescriptor.tokensFromString(System.getProperty("cassandra.initial_token", DatabaseDescriptor.conf.initial_token));
    }

    public static Collection<String> tokensFromString(String tokenString) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (tokenString != null) {
            for (String token : tokenString.split(",")) {
                tokens.add(token.replaceAll("^\\s+", "").replaceAll("\\s+$", ""));
            }
        }
        return tokens;
    }

    public static Integer getNumTokens() {
        return DatabaseDescriptor.conf.num_tokens;
    }

    public static InetAddress getReplaceAddress() {
        try {
            if (System.getProperty("cassandra.replace_address", null) != null) {
                return InetAddress.getByName(System.getProperty("cassandra.replace_address", null));
            }
            if (System.getProperty("cassandra.replace_address_first_boot", null) != null) {
                return InetAddress.getByName(System.getProperty("cassandra.replace_address_first_boot", null));
            }
            return null;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static Collection<String> getReplaceTokens() {
        return DatabaseDescriptor.tokensFromString(System.getProperty("cassandra.replace_token", null));
    }

    public static UUID getReplaceNode() {
        try {
            return UUID.fromString(System.getProperty("cassandra.replace_node", null));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static boolean isReplacing() {
        if (System.getProperty("cassandra.replace_address_first_boot", null) != null && SystemKeyspace.bootstrapComplete()) {
            logger.info("Replace address on first boot requested; this node is already bootstrapped");
            return false;
        }
        return DatabaseDescriptor.getReplaceAddress() != null;
    }

    public static String getClusterName() {
        return DatabaseDescriptor.conf.cluster_name;
    }

    public static int getMaxStreamingRetries() {
        return DatabaseDescriptor.conf.max_streaming_retries;
    }

    public static int getStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.storage_port", DatabaseDescriptor.conf.storage_port.toString()));
    }

    public static int getSSLStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.ssl_storage_port", DatabaseDescriptor.conf.ssl_storage_port.toString()));
    }

    public static int getRpcPort() {
        return Integer.parseInt(System.getProperty("cassandra.rpc_port", DatabaseDescriptor.conf.rpc_port.toString()));
    }

    public static int getRpcListenBacklog() {
        return DatabaseDescriptor.conf.rpc_listen_backlog;
    }

    public static long getRpcTimeout() {
        return DatabaseDescriptor.conf.request_timeout_in_ms;
    }

    public static void setRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.request_timeout_in_ms = timeOutInMillis;
    }

    public static long getReadRpcTimeout() {
        return DatabaseDescriptor.conf.read_request_timeout_in_ms;
    }

    public static void setReadRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.read_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getRangeRpcTimeout() {
        return DatabaseDescriptor.conf.range_request_timeout_in_ms;
    }

    public static void setRangeRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.range_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getWriteRpcTimeout() {
        return DatabaseDescriptor.conf.write_request_timeout_in_ms;
    }

    public static void setWriteRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.write_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getCounterWriteRpcTimeout() {
        return DatabaseDescriptor.conf.counter_write_request_timeout_in_ms;
    }

    public static void setCounterWriteRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.counter_write_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getCasContentionTimeout() {
        return DatabaseDescriptor.conf.cas_contention_timeout_in_ms;
    }

    public static void setCasContentionTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.cas_contention_timeout_in_ms = timeOutInMillis;
    }

    public static long getTruncateRpcTimeout() {
        return DatabaseDescriptor.conf.truncate_request_timeout_in_ms;
    }

    public static void setTruncateRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.truncate_request_timeout_in_ms = timeOutInMillis;
    }

    public static boolean hasCrossNodeTimeout() {
        return DatabaseDescriptor.conf.cross_node_timeout;
    }

    public static long getTimeout(MessagingService.Verb verb) {
        switch (verb) {
            case READ: {
                return DatabaseDescriptor.getReadRpcTimeout();
            }
            case RANGE_SLICE: {
                return DatabaseDescriptor.getRangeRpcTimeout();
            }
            case TRUNCATE: {
                return DatabaseDescriptor.getTruncateRpcTimeout();
            }
            case READ_REPAIR: 
            case MUTATION: 
            case PAXOS_COMMIT: 
            case PAXOS_PREPARE: 
            case PAXOS_PROPOSE: {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
            case COUNTER_MUTATION: {
                return DatabaseDescriptor.getCounterWriteRpcTimeout();
            }
        }
        return DatabaseDescriptor.getRpcTimeout();
    }

    public static long getMinRpcTimeout() {
        return Longs.min((long[])new long[]{DatabaseDescriptor.getRpcTimeout(), DatabaseDescriptor.getReadRpcTimeout(), DatabaseDescriptor.getRangeRpcTimeout(), DatabaseDescriptor.getWriteRpcTimeout(), DatabaseDescriptor.getCounterWriteRpcTimeout(), DatabaseDescriptor.getTruncateRpcTimeout()});
    }

    public static double getPhiConvictThreshold() {
        return DatabaseDescriptor.conf.phi_convict_threshold;
    }

    public static void setPhiConvictThreshold(double phiConvictThreshold) {
        DatabaseDescriptor.conf.phi_convict_threshold = phiConvictThreshold;
    }

    public static int getConcurrentReaders() {
        return DatabaseDescriptor.conf.concurrent_reads;
    }

    public static int getConcurrentWriters() {
        return DatabaseDescriptor.conf.concurrent_writes;
    }

    public static int getConcurrentCounterWriters() {
        return DatabaseDescriptor.conf.concurrent_counter_writes;
    }

    public static int getFlushWriters() {
        return DatabaseDescriptor.conf.memtable_flush_writers;
    }

    public static int getConcurrentCompactors() {
        return DatabaseDescriptor.conf.concurrent_compactors;
    }

    public static int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.conf.compaction_throughput_mb_per_sec;
    }

    public static void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.conf.compaction_throughput_mb_per_sec = value;
    }

    public static int getCompactionLargePartitionWarningThreshold() {
        return DatabaseDescriptor.conf.compaction_large_partition_warning_threshold_mb * 1024 * 1024;
    }

    public static boolean getDisableSTCSInL0() {
        return Boolean.getBoolean("cassandra.disable_stcs_in_l0");
    }

    public static int getStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec;
    }

    public static void setStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec = value;
    }

    public static int getInterDCStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound_megabits_per_sec;
    }

    public static void setInterDCStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound_megabits_per_sec = value;
    }

    public static String[] getAllDataFileLocations() {
        return DatabaseDescriptor.conf.data_file_directories;
    }

    public static String getCommitLogLocation() {
        return DatabaseDescriptor.conf.commitlog_directory;
    }

    public static int getTombstoneWarnThreshold() {
        return DatabaseDescriptor.conf.tombstone_warn_threshold;
    }

    public static void setTombstoneWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_warn_threshold = threshold;
    }

    public static int getTombstoneFailureThreshold() {
        return DatabaseDescriptor.conf.tombstone_failure_threshold;
    }

    public static void setTombstoneFailureThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_failure_threshold = threshold;
    }

    public static boolean getCommitLogSegmentRecyclingEnabled() {
        return DatabaseDescriptor.conf.commitlog_segment_recycling;
    }

    public static int getCommitLogSegmentSize() {
        return DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 * 1024;
    }

    public static String getSavedCachesLocation() {
        return DatabaseDescriptor.conf.saved_caches_directory;
    }

    public static Set<InetAddress> getSeeds() {
        return ImmutableSet.builder().addAll(seedProvider.getSeeds()).build();
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static InetAddress getBroadcastAddress() {
        return broadcastAddress;
    }

    public static IInternodeAuthenticator getInternodeAuthenticator() {
        return internodeAuthenticator;
    }

    public static void setBroadcastAddress(InetAddress broadcastAdd) {
        broadcastAddress = broadcastAdd;
    }

    public static boolean startRpc() {
        return DatabaseDescriptor.conf.start_rpc;
    }

    public static InetAddress getRpcAddress() {
        return rpcAddress;
    }

    public static void setBroadcastRpcAddress(InetAddress broadcastRPCAddr) {
        broadcastRpcAddress = broadcastRPCAddr;
    }

    public static InetAddress getBroadcastRpcAddress() {
        return broadcastRpcAddress;
    }

    public static String getRpcServerType() {
        return DatabaseDescriptor.conf.rpc_server_type;
    }

    public static boolean getRpcKeepAlive() {
        return DatabaseDescriptor.conf.rpc_keepalive;
    }

    public static Integer getRpcMinThreads() {
        return DatabaseDescriptor.conf.rpc_min_threads;
    }

    public static Integer getRpcMaxThreads() {
        return DatabaseDescriptor.conf.rpc_max_threads;
    }

    public static Integer getRpcSendBufferSize() {
        return DatabaseDescriptor.conf.rpc_send_buff_size_in_bytes;
    }

    public static Integer getRpcRecvBufferSize() {
        return DatabaseDescriptor.conf.rpc_recv_buff_size_in_bytes;
    }

    public static Integer getInternodeSendBufferSize() {
        return DatabaseDescriptor.conf.internode_send_buff_size_in_bytes;
    }

    public static Integer getInternodeRecvBufferSize() {
        return DatabaseDescriptor.conf.internode_recv_buff_size_in_bytes;
    }

    public static boolean startNativeTransport() {
        return DatabaseDescriptor.conf.start_native_transport;
    }

    public static int getNativeTransportPort() {
        return Integer.parseInt(System.getProperty("cassandra.native_transport_port", DatabaseDescriptor.conf.native_transport_port.toString()));
    }

    public static Integer getNativeTransportMaxThreads() {
        return DatabaseDescriptor.conf.native_transport_max_threads;
    }

    public static int getNativeTransportMaxFrameSize() {
        return DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb * 1024 * 1024;
    }

    public static Long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections;
    }

    public static void setNativeTransportMaxConcurrentConnections(long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections = nativeTransportMaxConcurrentConnections;
    }

    public static Long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip;
    }

    public static void setNativeTransportMaxConcurrentConnectionsPerIp(long native_transport_max_concurrent_connections_per_ip) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip = native_transport_max_concurrent_connections_per_ip;
    }

    public static double getCommitLogSyncBatchWindow() {
        return DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms;
    }

    public static int getCommitLogSyncPeriod() {
        return DatabaseDescriptor.conf.commitlog_sync_period_in_ms;
    }

    public static int getCommitLogPeriodicQueueSize() {
        return DatabaseDescriptor.conf.commitlog_periodic_queue_size;
    }

    public static Config.CommitLogSync getCommitLogSync() {
        return DatabaseDescriptor.conf.commitlog_sync;
    }

    public static Config.DiskAccessMode getDiskAccessMode() {
        return DatabaseDescriptor.conf.disk_access_mode;
    }

    public static Config.DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    public static void setDiskFailurePolicy(Config.DiskFailurePolicy policy) {
        DatabaseDescriptor.conf.disk_failure_policy = policy;
    }

    public static Config.DiskFailurePolicy getDiskFailurePolicy() {
        return DatabaseDescriptor.conf.disk_failure_policy;
    }

    public static void setCommitFailurePolicy(Config.CommitFailurePolicy policy) {
        DatabaseDescriptor.conf.commit_failure_policy = policy;
    }

    public static Config.CommitFailurePolicy getCommitFailurePolicy() {
        return DatabaseDescriptor.conf.commit_failure_policy;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return DatabaseDescriptor.conf.snapshot_before_compaction;
    }

    public static boolean isAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    @VisibleForTesting
    public static void setAutoSnapshot(boolean autoSnapshot) {
        DatabaseDescriptor.conf.auto_snapshot = autoSnapshot;
    }

    public static boolean isAutoBootstrap() {
        return Boolean.parseBoolean(System.getProperty("cassandra.auto_bootstrap", DatabaseDescriptor.conf.auto_bootstrap.toString()));
    }

    public static void setHintedHandoffEnabled(boolean hintedHandoffEnabled) {
        DatabaseDescriptor.conf.hinted_handoff_enabled_global = hintedHandoffEnabled;
        DatabaseDescriptor.conf.hinted_handoff_enabled_by_dc.clear();
    }

    public static void setHintedHandoffEnabled(String dcNames) {
        List<String> dcNameList;
        try {
            dcNameList = Config.parseHintedHandoffEnabledDCs(dcNames);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read csv of dcs for hinted handoff enable. " + dcNames, e);
        }
        if (dcNameList.isEmpty()) {
            throw new IllegalArgumentException("Empty list of Dcs for hinted handoff enable");
        }
        DatabaseDescriptor.conf.hinted_handoff_enabled_by_dc.clear();
        DatabaseDescriptor.conf.hinted_handoff_enabled_by_dc.addAll(dcNameList);
    }

    public static boolean hintedHandoffEnabled() {
        return DatabaseDescriptor.conf.hinted_handoff_enabled_global;
    }

    public static Set<String> hintedHandoffEnabledByDC() {
        return Collections.unmodifiableSet(DatabaseDescriptor.conf.hinted_handoff_enabled_by_dc);
    }

    public static boolean shouldHintByDC() {
        return !DatabaseDescriptor.conf.hinted_handoff_enabled_by_dc.isEmpty();
    }

    public static boolean hintedHandoffEnabled(String dcName) {
        return DatabaseDescriptor.conf.hinted_handoff_enabled_by_dc.contains(dcName);
    }

    public static void setMaxHintWindow(int ms) {
        DatabaseDescriptor.conf.max_hint_window_in_ms = ms;
    }

    public static int getMaxHintWindow() {
        return DatabaseDescriptor.conf.max_hint_window_in_ms;
    }

    @Deprecated
    public static Integer getIndexInterval() {
        return DatabaseDescriptor.conf.index_interval;
    }

    public static File getSerializedCachePath(CacheService.CacheType cacheType, String version) {
        String name = cacheType.toString() + (version == null ? "" : "-" + version + ".db");
        return new File(DatabaseDescriptor.conf.saved_caches_directory, name);
    }

    public static int getDynamicUpdateInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms;
    }

    public static void setDynamicUpdateInterval(Integer dynamicUpdateInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms = dynamicUpdateInterval;
    }

    public static int getDynamicResetInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms;
    }

    public static void setDynamicResetInterval(Integer dynamicResetInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms = dynamicResetInterval;
    }

    public static double getDynamicBadnessThreshold() {
        return DatabaseDescriptor.conf.dynamic_snitch_badness_threshold;
    }

    public static void setDynamicBadnessThreshold(Double dynamicBadnessThreshold) {
        DatabaseDescriptor.conf.dynamic_snitch_badness_threshold = dynamicBadnessThreshold;
    }

    public static EncryptionOptions.ServerEncryptionOptions getServerEncryptionOptions() {
        return DatabaseDescriptor.conf.server_encryption_options;
    }

    public static EncryptionOptions.ClientEncryptionOptions getClientEncryptionOptions() {
        return DatabaseDescriptor.conf.client_encryption_options;
    }

    public static int getHintedHandoffThrottleInKB() {
        return DatabaseDescriptor.conf.hinted_handoff_throttle_in_kb;
    }

    public static int getBatchlogReplayThrottleInKB() {
        return DatabaseDescriptor.conf.batchlog_replay_throttle_in_kb;
    }

    public static void setHintedHandoffThrottleInKB(Integer throttleInKB) {
        DatabaseDescriptor.conf.hinted_handoff_throttle_in_kb = throttleInKB;
    }

    public static int getMaxHintsThread() {
        return DatabaseDescriptor.conf.max_hints_delivery_threads;
    }

    public static boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.conf.incremental_backups;
    }

    public static void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.conf.incremental_backups = value;
    }

    public static int getFileCacheSizeInMB() {
        return DatabaseDescriptor.conf.file_cache_size_in_mb;
    }

    public static long getTotalCommitlogSpaceInMB() {
        return DatabaseDescriptor.conf.commitlog_total_space_in_mb.intValue();
    }

    public static int getSSTablePreempiveOpenIntervalInMB() {
        return DatabaseDescriptor.conf.sstable_preemptive_open_interval_in_mb;
    }

    public static boolean getTrickleFsync() {
        return DatabaseDescriptor.conf.trickle_fsync;
    }

    public static int getTrickleFsyncIntervalInKb() {
        return DatabaseDescriptor.conf.trickle_fsync_interval_in_kb;
    }

    public static long getKeyCacheSizeInMB() {
        return keyCacheSizeInMB;
    }

    public static long getIndexSummaryCapacityInMB() {
        return indexSummaryCapacityInMB;
    }

    public static int getKeyCacheSavePeriod() {
        return DatabaseDescriptor.conf.key_cache_save_period;
    }

    public static void setKeyCacheSavePeriod(int keyCacheSavePeriod) {
        DatabaseDescriptor.conf.key_cache_save_period = keyCacheSavePeriod;
    }

    public static int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.conf.key_cache_keys_to_save;
    }

    public static void setKeyCacheKeysToSave(int keyCacheKeysToSave) {
        DatabaseDescriptor.conf.key_cache_keys_to_save = keyCacheKeysToSave;
    }

    public static long getRowCacheSizeInMB() {
        return DatabaseDescriptor.conf.row_cache_size_in_mb;
    }

    @VisibleForTesting
    public static void setRowCacheSizeInMB(long val) {
        DatabaseDescriptor.conf.row_cache_size_in_mb = val;
    }

    public static int getRowCacheSavePeriod() {
        return DatabaseDescriptor.conf.row_cache_save_period;
    }

    public static void setRowCacheSavePeriod(int rowCacheSavePeriod) {
        DatabaseDescriptor.conf.row_cache_save_period = rowCacheSavePeriod;
    }

    public static int getRowCacheKeysToSave() {
        return DatabaseDescriptor.conf.row_cache_keys_to_save;
    }

    public static long getCounterCacheSizeInMB() {
        return counterCacheSizeInMB;
    }

    public static int getCounterCacheSavePeriod() {
        return DatabaseDescriptor.conf.counter_cache_save_period;
    }

    public static void setCounterCacheSavePeriod(int counterCacheSavePeriod) {
        DatabaseDescriptor.conf.counter_cache_save_period = counterCacheSavePeriod;
    }

    public static int getCounterCacheKeysToSave() {
        return DatabaseDescriptor.conf.counter_cache_keys_to_save;
    }

    public static void setCounterCacheKeysToSave(int counterCacheKeysToSave) {
        DatabaseDescriptor.conf.counter_cache_keys_to_save = counterCacheKeysToSave;
    }

    public static IAllocator getoffHeapMemoryAllocator() {
        return memoryAllocator;
    }

    public static void setRowCacheKeysToSave(int rowCacheKeysToSave) {
        DatabaseDescriptor.conf.row_cache_keys_to_save = rowCacheKeysToSave;
    }

    public static int getStreamingSocketTimeout() {
        return DatabaseDescriptor.conf.streaming_socket_timeout_in_ms;
    }

    public static String getLocalDataCenter() {
        return localDC;
    }

    public static Comparator<InetAddress> getLocalComparator() {
        return localComparator;
    }

    public static Config.InternodeCompression internodeCompression() {
        return DatabaseDescriptor.conf.internode_compression;
    }

    public static boolean getInterDCTcpNoDelay() {
        return DatabaseDescriptor.conf.inter_dc_tcp_nodelay;
    }

    public static MemtablePool getMemtableAllocatorPool() {
        long heapLimit = (long)DatabaseDescriptor.conf.memtable_heap_space_in_mb.intValue() << 20;
        long offHeapLimit = (long)DatabaseDescriptor.conf.memtable_offheap_space_in_mb.intValue() << 20;
        switch (DatabaseDescriptor.conf.memtable_allocation_type) {
            case unslabbed_heap_buffers: {
                return new HeapPool(heapLimit, DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue(), new ColumnFamilyStore.FlushLargestColumnFamily());
            }
            case heap_buffers: {
                return new SlabPool(heapLimit, 0L, DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue(), new ColumnFamilyStore.FlushLargestColumnFamily());
            }
            case offheap_buffers: {
                if (!FileUtils.isCleanerAvailable()) {
                    logger.error("Could not free direct byte buffer: offheap_buffers is not a safe memtable_allocation_type without this ability, please adjust your config. This feature is only guaranteed to work on an Oracle JVM. Refusing to start.");
                    System.exit(-1);
                }
                return new SlabPool(heapLimit, offHeapLimit, DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue(), new ColumnFamilyStore.FlushLargestColumnFamily());
            }
            case offheap_objects: {
                return new NativePool(heapLimit, offHeapLimit, DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue(), new ColumnFamilyStore.FlushLargestColumnFamily());
            }
        }
        throw new AssertionError();
    }

    public static int getIndexSummaryResizeIntervalInMinutes() {
        return DatabaseDescriptor.conf.index_summary_resize_interval_in_minutes;
    }

    public static boolean hasLargeAddressSpace() {
        String arch;
        String datamodel = System.getProperty("sun.arch.data.model");
        if (datamodel != null) {
            switch (datamodel) {
                case "64": {
                    return true;
                }
                case "32": {
                    return false;
                }
            }
        }
        return (arch = System.getProperty("os.arch")).contains("64") || arch.contains("sparcv9");
    }

    public static String getOtcCoalescingStrategy() {
        return DatabaseDescriptor.conf.otc_coalescing_strategy;
    }

    public static int getOtcCoalescingWindow() {
        return DatabaseDescriptor.conf.otc_coalescing_window_us;
    }

    public static long getGCWarnThreshold() {
        return DatabaseDescriptor.conf.gc_warn_threshold_in_ms;
    }

    static {
        authenticator = new AllowAllAuthenticator();
        authorizer = new AllowAllAuthorizer();
        try {
            if (Config.isClientMode()) {
                conf = new Config();
                memoryAllocator = FBUtilities.newOffHeapAllocator(DatabaseDescriptor.conf.memory_allocator);
            } else {
                DatabaseDescriptor.applyConfig(DatabaseDescriptor.loadConfig());
            }
        }
        catch (ConfigurationException e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start. See log for stacktrace.");
            System.exit(1);
        }
        catch (Exception e) {
            logger.error("Fatal error during configuration loading", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal error during configuration loading; unable to start. See log for stacktrace.");
            JVMStabilityInspector.inspectThrowable(e);
            System.exit(1);
        }
    }
}

