/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.utils.BatchRemoveIterator;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ArrayBackedSortedColumns
extends ColumnFamily {
    private static final Cell[] EMPTY_ARRAY = new Cell[0];
    private static final int MINIMAL_CAPACITY = 10;
    private final boolean reversed;
    private DeletionInfo deletionInfo;
    private Cell[] cells;
    private int size;
    private int sortedSize;
    private volatile boolean isSorted;
    public static final ColumnFamily.Factory<ArrayBackedSortedColumns> factory = new ColumnFamily.Factory<ArrayBackedSortedColumns>(){

        @Override
        public ArrayBackedSortedColumns create(CFMetaData metadata, boolean insertReversed, int initialCapacity) {
            return new ArrayBackedSortedColumns(metadata, insertReversed, initialCapacity == 0 ? EMPTY_ARRAY : new Cell[initialCapacity], 0, 0);
        }
    };

    private ArrayBackedSortedColumns(CFMetaData metadata, boolean reversed, Cell[] cells, int size, int sortedSize) {
        super(metadata);
        this.reversed = reversed;
        this.deletionInfo = DeletionInfo.live();
        this.cells = cells;
        this.size = size;
        this.sortedSize = sortedSize;
        this.isSorted = size == sortedSize;
    }

    protected ArrayBackedSortedColumns(CFMetaData metadata, boolean reversed) {
        this(metadata, reversed, EMPTY_ARRAY, 0, 0);
    }

    private ArrayBackedSortedColumns(ArrayBackedSortedColumns original) {
        super(original.metadata);
        this.reversed = original.reversed;
        this.deletionInfo = DeletionInfo.live();
        this.cells = Arrays.copyOf(original.cells, original.size);
        this.size = original.size;
        this.sortedSize = original.sortedSize;
        this.isSorted = original.isSorted;
    }

    public static ArrayBackedSortedColumns localCopy(ColumnFamily original, AbstractAllocator allocator) {
        ArrayBackedSortedColumns copy = new ArrayBackedSortedColumns(original.metadata, false, new Cell[original.getColumnCount()], 0, 0);
        for (Cell cell : original) {
            copy.internalAdd(cell.localCopy(original.metadata, allocator));
        }
        copy.sortedSize = copy.size;
        copy.delete(original);
        return copy;
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new ArrayBackedSortedColumns(this);
    }

    @Override
    public boolean isInsertReversed() {
        return this.reversed;
    }

    @Override
    public BatchRemoveIterator<Cell> batchRemoveIterator() {
        this.maybeSortCells();
        return new BatchRemoveIterator<Cell>(){
            private final Iterator<Cell> iter;
            private BitSet removedIndexes;
            private int idx;
            private boolean shouldCallNext;
            private boolean isCommitted;
            private boolean removedAnything;
            {
                this.iter = ArrayBackedSortedColumns.this.iterator();
                this.removedIndexes = new BitSet(ArrayBackedSortedColumns.this.size);
                this.idx = -1;
                this.shouldCallNext = false;
                this.isCommitted = false;
                this.removedAnything = false;
            }

            @Override
            public void commit() {
                int clearIdx;
                if (this.isCommitted) {
                    throw new IllegalStateException();
                }
                this.isCommitted = true;
                if (!this.removedAnything) {
                    return;
                }
                int retainedCount = 0;
                int setIdx = -1;
                while ((clearIdx = this.removedIndexes.nextClearBit(setIdx + 1)) < ArrayBackedSortedColumns.this.size) {
                    setIdx = this.removedIndexes.nextSetBit(clearIdx + 1);
                    if (setIdx < 0) {
                        setIdx = ArrayBackedSortedColumns.this.size;
                    }
                    if (retainedCount != clearIdx) {
                        System.arraycopy(ArrayBackedSortedColumns.this.cells, clearIdx, ArrayBackedSortedColumns.this.cells, retainedCount, setIdx - clearIdx);
                    }
                    retainedCount += setIdx - clearIdx;
                }
                for (int i = retainedCount; i < ArrayBackedSortedColumns.this.size; ++i) {
                    ((ArrayBackedSortedColumns)ArrayBackedSortedColumns.this).cells[i] = null;
                }
                ArrayBackedSortedColumns.this.size = (ArrayBackedSortedColumns.this.sortedSize = retainedCount);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Cell next() {
                ++this.idx;
                this.shouldCallNext = false;
                return this.iter.next();
            }

            @Override
            public void remove() {
                if (this.shouldCallNext) {
                    throw new IllegalStateException();
                }
                this.removedIndexes.set(ArrayBackedSortedColumns.this.reversed ? ArrayBackedSortedColumns.this.size - this.idx - 1 : this.idx);
                this.removedAnything = true;
                this.shouldCallNext = true;
            }
        };
    }

    private Comparator<Composite> internalComparator() {
        return this.reversed ? this.getComparator().reverseComparator() : this.getComparator();
    }

    private void maybeSortCells() {
        if (!this.isSorted) {
            this.sortCells();
        }
    }

    private synchronized void sortCells() {
        if (this.isSorted) {
            return;
        }
        Comparator<Cell> comparator = this.reversed ? this.getComparator().columnReverseComparator() : this.getComparator().columnComparator(false);
        Arrays.sort(this.cells, this.sortedSize, this.size, comparator);
        int pos = this.binarySearch(0, this.sortedSize, this.cells[this.sortedSize].name(), this.internalComparator());
        if (pos < 0) {
            pos = -pos - 1;
        }
        Cell[] leftCopy = pos == this.sortedSize ? EMPTY_ARRAY : Arrays.copyOfRange(this.cells, pos, this.sortedSize);
        int rightStart = this.sortedSize;
        int rightEnd = this.size;
        this.size = this.sortedSize = pos;
        int l = 0;
        int r = rightStart;
        while (l < leftCopy.length && r < rightEnd) {
            int cmp = comparator.compare(leftCopy[l], this.cells[r]);
            if (cmp < 0) {
                this.append(leftCopy[l++]);
                continue;
            }
            if (cmp == 0) {
                this.append(leftCopy[l++].reconcile(this.cells[r++]));
                continue;
            }
            this.appendOrReconcile(this.cells[r++]);
        }
        while (l < leftCopy.length) {
            this.append(leftCopy[l++]);
        }
        while (r < rightEnd) {
            this.appendOrReconcile(this.cells[r++]);
        }
        for (int i = this.size; i < rightEnd; ++i) {
            this.cells[i] = null;
        }
        this.isSorted = true;
    }

    private void appendOrReconcile(Cell cell) {
        if (this.size > 0 && this.cells[this.size - 1].name().equals(cell.name())) {
            this.reconcileWith(this.size - 1, cell);
        } else {
            this.append(cell);
        }
    }

    private void append(Cell cell) {
        this.cells[this.size] = cell;
        ++this.size;
        ++this.sortedSize;
    }

    @Override
    public Cell getColumn(CellName name) {
        this.maybeSortCells();
        int pos = this.binarySearch(name);
        return pos >= 0 ? this.cells[pos] : null;
    }

    @Override
    public void maybeAppendColumn(Cell cell, DeletionInfo.InOrderTester tester, int gcBefore) {
        if (cell.getLocalDeletionTime() >= gcBefore && !tester.isDeleted(cell)) {
            this.internalAdd(cell);
            ++this.sortedSize;
        }
    }

    @Override
    public void addColumn(Cell cell) {
        if (this.size == 0) {
            this.internalAdd(cell);
            ++this.sortedSize;
            return;
        }
        if (!this.isSorted) {
            this.internalAdd(cell);
            return;
        }
        int c = this.internalComparator().compare(this.cells[this.size - 1].name(), cell.name());
        if (c < 0) {
            this.internalAdd(cell);
            ++this.sortedSize;
        } else if (c == 0) {
            this.reconcileWith(this.size - 1, cell);
        } else {
            int pos = this.binarySearch(cell.name());
            if (pos >= 0) {
                this.reconcileWith(pos, cell);
            } else {
                this.internalAdd(cell);
                this.isSorted = false;
            }
        }
    }

    @Override
    public void addAll(ColumnFamily other) {
        this.delete(other.deletionInfo());
        if (!other.hasColumns()) {
            return;
        }
        if (this.size == 0 && other instanceof ArrayBackedSortedColumns) {
            this.fastAddAll((ArrayBackedSortedColumns)other);
        } else {
            Iterator<Cell> iterator;
            Iterator<Cell> iterator2 = iterator = this.reversed ? other.reverseIterator() : other.iterator();
            while (iterator.hasNext()) {
                this.addColumn(iterator.next());
            }
        }
    }

    private void fastAddAll(ArrayBackedSortedColumns other) {
        if (other.isInsertReversed() == this.isInsertReversed()) {
            this.cells = Arrays.copyOf(other.cells, other.cells.length);
            this.size = other.size;
            this.sortedSize = other.sortedSize;
            this.isSorted = other.isSorted;
        } else {
            Iterator<Cell> iterator;
            if (this.cells.length < other.getColumnCount()) {
                this.cells = new Cell[Math.max(10, other.getColumnCount())];
            }
            Iterator<Cell> iterator2 = iterator = this.reversed ? other.reverseIterator() : other.iterator();
            while (iterator.hasNext()) {
                this.cells[this.size++] = iterator.next();
            }
            this.sortedSize = this.size;
            this.isSorted = true;
        }
    }

    private void internalAdd(Cell cell) {
        if (this.cells.length == this.size) {
            this.cells = Arrays.copyOf(this.cells, Math.max(10, this.size * 3 / 2 + 1));
        }
        this.cells[this.size++] = cell;
    }

    private void internalRemove(int index) {
        int moving = this.size - index - 1;
        if (moving > 0) {
            System.arraycopy(this.cells, index + 1, this.cells, index, moving);
        }
        this.cells[--this.size] = null;
    }

    private void reconcileWith(int i, Cell cell) {
        this.cells[i] = cell.reconcile(this.cells[i]);
    }

    private int binarySearch(CellName name) {
        return this.binarySearch(0, this.size, name, this.internalComparator());
    }

    private int binarySearch(int fromIndex, int toIndex, Composite name, Comparator<Composite> comparator) {
        int low = fromIndex;
        int mid = toIndex;
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(name, this.cells[mid].name());
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    @Override
    public Collection<Cell> getSortedColumns() {
        return new CellCollection(this.reversed);
    }

    @Override
    public Collection<Cell> getReverseSortedColumns() {
        return new CellCollection(!this.reversed);
    }

    @Override
    public int getColumnCount() {
        this.maybeSortCells();
        return this.size;
    }

    @Override
    public boolean hasColumns() {
        return this.size > 0;
    }

    @Override
    public void clear() {
        this.setDeletionInfo(DeletionInfo.live());
        for (int i = 0; i < this.size; ++i) {
            this.cells[i] = null;
        }
        this.sortedSize = 0;
        this.size = 0;
        this.isSorted = true;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public void delete(DeletionTime delTime) {
        this.deletionInfo.add(delTime);
    }

    @Override
    public void delete(DeletionInfo newInfo) {
        this.deletionInfo.add(newInfo);
    }

    @Override
    protected void delete(RangeTombstone tombstone) {
        this.deletionInfo.add(tombstone, this.getComparator());
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.deletionInfo = newInfo;
    }

    @Override
    public void purgeTombstones(int gcBefore) {
        this.deletionInfo.purge(gcBefore);
    }

    @Override
    public Iterable<CellName> getColumnNames() {
        return Iterables.transform((Iterable)new CellCollection(false), (Function)new Function<Cell, CellName>(){

            public CellName apply(Cell cell) {
                return cell.name();
            }
        });
    }

    @Override
    public Iterator<Cell> iterator(ColumnSlice[] slices) {
        this.maybeSortCells();
        return slices.length == 1 ? this.slice(slices[0], this.reversed, null) : new SlicesIterator(slices, this.reversed);
    }

    @Override
    public Iterator<Cell> reverseIterator(ColumnSlice[] slices) {
        this.maybeSortCells();
        return slices.length == 1 ? this.slice(slices[0], !this.reversed, null) : new SlicesIterator(slices, !this.reversed);
    }

    private Iterator<Cell> slice(ColumnSlice slice, boolean invert, SlicesIterator iter) {
        Composite start = invert ? slice.finish : slice.start;
        Composite finish = invert ? slice.start : slice.finish;
        int lowerBound = 0;
        int upperBound = this.size;
        if (iter != null) {
            if (invert) {
                upperBound = iter.previousSliceEnd;
            } else {
                lowerBound = iter.previousSliceEnd;
            }
        }
        if (!start.isEmpty() && (lowerBound = this.binarySearch(lowerBound, upperBound, start, this.internalComparator())) < 0) {
            lowerBound = -lowerBound - 1;
        }
        if (!finish.isEmpty()) {
            int n = upperBound = (upperBound = this.binarySearch(lowerBound, upperBound, finish, this.internalComparator())) < 0 ? -upperBound - 1 : upperBound + 1;
        }
        if (iter != null) {
            iter.previousSliceEnd = invert ? lowerBound : upperBound;
        }
        return invert ? new BackwardsCellIterator(lowerBound, upperBound) : new ForwardsCellIterator(lowerBound, upperBound);
    }

    private final class CellCollection
    extends AbstractCollection<Cell> {
        private final boolean invert;

        private CellCollection(boolean invert) {
            this.invert = invert;
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.getColumnCount();
        }

        @Override
        public Iterator<Cell> iterator() {
            ArrayBackedSortedColumns.this.maybeSortCells();
            return this.invert ? new BackwardsCellIterator(0, ArrayBackedSortedColumns.this.size) : new ForwardsCellIterator(0, ArrayBackedSortedColumns.this.size);
        }
    }

    private final class ForwardsCellIterator
    implements Iterator<Cell> {
        private int idx;
        private int end;
        private boolean shouldCallNext = true;

        private ForwardsCellIterator(int lowerBound, int upperBound) {
            this.idx = lowerBound;
            this.end = upperBound;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.end;
        }

        @Override
        public Cell next() {
            this.shouldCallNext = false;
            return ArrayBackedSortedColumns.this.cells[this.idx++];
        }

        @Override
        public void remove() {
            if (this.shouldCallNext) {
                throw new IllegalStateException();
            }
            this.shouldCallNext = true;
            ArrayBackedSortedColumns.this.internalRemove(--this.idx);
            ArrayBackedSortedColumns.this.sortedSize--;
            --this.end;
        }
    }

    private final class BackwardsCellIterator
    implements Iterator<Cell> {
        private int idx;
        private int end;
        private boolean shouldCallNext = true;

        private BackwardsCellIterator(int lowerBound, int upperBound) {
            this.idx = upperBound - 1;
            this.end = lowerBound - 1;
        }

        @Override
        public boolean hasNext() {
            return this.idx > this.end;
        }

        @Override
        public Cell next() {
            this.shouldCallNext = false;
            return ArrayBackedSortedColumns.this.cells[this.idx--];
        }

        @Override
        public void remove() {
            if (this.shouldCallNext) {
                throw new IllegalStateException();
            }
            this.shouldCallNext = true;
            ArrayBackedSortedColumns.this.internalRemove(this.idx + 1);
            ArrayBackedSortedColumns.this.sortedSize--;
        }
    }

    private class SlicesIterator
    extends AbstractIterator<Cell> {
        private final ColumnSlice[] slices;
        private final boolean invert;
        private int idx = 0;
        private int previousSliceEnd;
        private Iterator<Cell> currentSlice;

        public SlicesIterator(ColumnSlice[] slices, boolean invert) {
            this.slices = slices;
            this.invert = invert;
            this.previousSliceEnd = invert ? ArrayBackedSortedColumns.this.size : 0;
        }

        protected Cell computeNext() {
            if (this.currentSlice == null) {
                if (this.idx >= this.slices.length) {
                    return (Cell)this.endOfData();
                }
                this.currentSlice = ArrayBackedSortedColumns.this.slice(this.slices[this.idx++], this.invert, this);
            }
            if (this.currentSlice.hasNext()) {
                return this.currentSlice.next();
            }
            this.currentSlice = null;
            return this.computeNext();
        }
    }
}

