/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.Interval;

public class RangeTombstone
extends Interval<Composite, DeletionTime>
implements OnDiskAtom {
    public RangeTombstone(Composite start, Composite stop, long markedForDeleteAt, int localDeletionTime) {
        this(start, stop, new DeletionTime(markedForDeleteAt, localDeletionTime));
    }

    public RangeTombstone(Composite start, Composite stop, DeletionTime delTime) {
        super(start, stop, delTime);
    }

    @Override
    public Composite name() {
        return (Composite)this.min;
    }

    @Override
    public int getLocalDeletionTime() {
        return ((DeletionTime)this.data).localDeletionTime;
    }

    @Override
    public long timestamp() {
        return ((DeletionTime)this.data).markedForDeleteAt;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate((Composite)this.min);
        metadata.comparator.validate((Composite)this.max);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(((Composite)this.min).toByteBuffer().duplicate());
        digest.update(((Composite)this.max).toByteBuffer().duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(((DeletionTime)this.data).markedForDeleteAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    public boolean supersedes(RangeTombstone rt, Comparator<Composite> comparator) {
        if (((DeletionTime)rt.data).markedForDeleteAt > ((DeletionTime)this.data).markedForDeleteAt) {
            return false;
        }
        return comparator.compare((Composite)this.min, (Composite)rt.min) <= 0 && comparator.compare((Composite)this.max, (Composite)rt.max) >= 0;
    }

    public boolean includes(Comparator<Composite> comparator, Composite name) {
        return comparator.compare(name, (Composite)this.min) >= 0 && comparator.compare(name, (Composite)this.max) <= 0;
    }

    public static class Serializer
    implements ISSTableSerializer<RangeTombstone> {
        private final CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        @Override
        public void serializeForSSTable(RangeTombstone t, DataOutputPlus out) throws IOException {
            this.type.serializer().serialize(t.min, out);
            out.writeByte(16);
            this.type.serializer().serialize(t.max, out);
            DeletionTime.serializer.serialize((DeletionTime)t.data, out);
        }

        @Override
        public RangeTombstone deserializeFromSSTable(DataInput in, Descriptor.Version version) throws IOException {
            Composite min = (Composite)this.type.serializer().deserialize(in);
            int b = in.readUnsignedByte();
            assert ((b & 0x10) != 0);
            return this.deserializeBody(in, min, version);
        }

        public RangeTombstone deserializeBody(DataInput in, Composite min, Descriptor.Version version) throws IOException {
            Composite max = (Composite)this.type.serializer().deserialize(in);
            DeletionTime dt = DeletionTime.serializer.deserialize(in);
            Composite minEnd = min.end();
            max = minEnd.equals(max) ? minEnd : max;
            return new RangeTombstone(min, max, dt);
        }

        public void skipBody(DataInput in, Descriptor.Version version) throws IOException {
            this.type.serializer().skip(in);
            DeletionTime.serializer.skip(in);
        }

        public long serializedSizeForSSTable(RangeTombstone t) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            return this.type.serializer().serializedSize(t.min, typeSizes) + 1L + this.type.serializer().serializedSize(t.max, typeSizes) + DeletionTime.serializer.serializedSize((DeletionTime)t.data, typeSizes);
        }
    }

    public static class Tracker {
        private final Comparator<Composite> comparator;
        private final List<RangeTombstone> openedTombstones = new LinkedList<RangeTombstone>();
        private final Set<RangeTombstone> unwrittenTombstones = new LinkedHashSet<RangeTombstone>();
        private int atomCount;

        public Tracker(Comparator<Composite> comparator) {
            this.comparator = comparator;
        }

        public long writeOpenedMarkers(Composite startPos, DataOutputPlus out, OnDiskAtom.Serializer atomSerializer) throws IOException {
            long size = 0L;
            for (RangeTombstone rt : this.openedTombstones) {
                if (rt instanceof ExpiredRangeTombstone || this.comparator.compare((Composite)rt.max, startPos) < 0) continue;
                size += this.writeTombstone(rt, out, atomSerializer);
            }
            return size;
        }

        public long writeUnwrittenTombstones(DataOutputPlus out, OnDiskAtom.Serializer atomSerializer) throws IOException {
            long size = 0L;
            for (RangeTombstone rt : this.unwrittenTombstones) {
                size += this.writeTombstone(rt, out, atomSerializer);
            }
            this.unwrittenTombstones.clear();
            return size;
        }

        private long writeTombstone(RangeTombstone rt, DataOutputPlus out, OnDiskAtom.Serializer atomSerializer) throws IOException {
            long size = atomSerializer.serializedSizeForSSTable(rt);
            ++this.atomCount;
            if (out != null) {
                atomSerializer.serializeForSSTable(rt, out);
            }
            return size;
        }

        public int writtenAtom() {
            return this.atomCount;
        }

        public boolean update(OnDiskAtom atom, boolean isExpired) {
            ListIterator<RangeTombstone> iterator = this.openedTombstones.listIterator();
            while (iterator.hasNext()) {
                RangeTombstone t = iterator.next();
                if (this.comparator.compare(atom.name(), (Composite)t.max) > 0) {
                    iterator.remove();
                    continue;
                }
                iterator.previous();
                break;
            }
            if (atom instanceof RangeTombstone) {
                RangeTombstone toAdd = (RangeTombstone)atom;
                while (iterator.hasNext()) {
                    RangeTombstone existing = iterator.next();
                    int cmp = this.comparator.compare((Composite)toAdd.max, (Composite)existing.max);
                    if (cmp > 0) {
                        if (((DeletionTime)existing.data).supersedes((DeletionTime)toAdd.data)) continue;
                        iterator.remove();
                        if (this.comparator.compare((Composite)toAdd.min, (Composite)existing.min) != 0) continue;
                        this.unwrittenTombstones.remove(existing);
                        continue;
                    }
                    if (!((DeletionTime)toAdd.data).supersedes((DeletionTime)existing.data)) {
                        return false;
                    }
                    if (cmp == 0) {
                        iterator.remove();
                        if (this.comparator.compare((Composite)toAdd.min, (Composite)existing.min) != 0) break;
                        this.unwrittenTombstones.remove(existing);
                        break;
                    }
                    iterator.previous();
                    break;
                }
                if (isExpired) {
                    iterator.add(new ExpiredRangeTombstone(toAdd));
                } else {
                    iterator.add(toAdd);
                    this.unwrittenTombstones.add(toAdd);
                }
                return false;
            }
            return true;
        }

        public boolean isDeleted(Cell cell) {
            for (RangeTombstone tombstone : this.openedTombstones) {
                if (this.comparator.compare(cell.name(), (Composite)tombstone.max) > 0 || tombstone.timestamp() < cell.timestamp()) continue;
                return true;
            }
            return false;
        }

        public boolean hasUnwrittenTombstones() {
            return !this.unwrittenTombstones.isEmpty();
        }

        private static class ExpiredRangeTombstone
        extends RangeTombstone {
            private ExpiredRangeTombstone(RangeTombstone tombstone) {
                super((Composite)tombstone.min, (Composite)tombstone.max, (DeletionTime)tombstone.data);
            }
        }
    }
}

