// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: src/java/org/apache/cassandra/index/sasi/analyzer/StandardTokenizerImpl.jflex

package org.apache.cassandra.index.sasi.analyzer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Arrays;

/**
 * This class implements Word Break rules from the Unicode Text Segmentation 
 * algorithm, as specified in 
 * <a href="http://unicode.org/reports/tr29/">Unicode Standard Annex #29</a>. 
 * <p/>
 * Tokens produced are of the following types:
 * <ul>
 *   <li>&lt;ALPHANUM&gt;: A sequence of alphabetic and numeric characters</li>
 *   <li>&lt;NUM&gt;: A number</li>
 *   <li>&lt;SOUTHEAST_ASIAN&gt;: A sequence of characters from South and Southeast
 *       Asian languages, including Thai, Lao, Myanmar, and Khmer</li>
 *   <li>&lt;IDEOGRAPHIC&gt;: A single CJKV ideographic character</li>
 *   <li>&lt;HIRAGANA&gt;: A single hiragana character</li>
 *   <li>&lt;KATAKANA&gt;: A sequence of katakana characters</li>
 *   <li>&lt;HANGUL&gt;: A sequence of Hangul characters</li>
 * </ul>
 */

// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings("FallThrough")
public final class StandardTokenizerImpl implements StandardTokenizerInterface {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 4096;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u1100\1\u1200\1\u1300\1\u1400\1\u0100\1\u1500\1\u1600"+
    "\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u1c00\1\u0100\1\u1d00"+
    "\1\u1e00\1\u1f00\2\u2000\1\u2100\7\u2000\1\u2200\1\u2300\1\u2400"+
    "\1\u2500\1\u2600\1\u2700\1\u2800\1\u2900\31\u2a00\1\u2b00\121\u2a00"+
    "\1\u2c00\4\u0100\1\u2d00\1\u0100\1\u2e00\1\u2f00\1\u3000\1\u3100"+
    "\1\u3200\1\u3300\53\u1100\1\u3400\1\u3500\2\u2000\1\u3600\1\u3700"+
    "\1\u3800\1\u3900\1\u3a00\31\u2000\1\u2a00\1\u3b00\1\u3c00\1\u0100"+
    "\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u4100\1\u4200\1\u4300\1\u4400"+
    "\3\u2000\1\u4500\1\u4600\1\u4700\1\u4800\1\u4900\3\u2000\1\u4a00"+
    "\1\u4b00\4\u2000\1\u4c00\11\u2000\3\u0100\1\u4d00\1\u4e00\13\u2000"+
    "\4\u0100\1\u4f00\63\u2000\2\u0100\1\u5000\4\u2000\1\u5100\100\u2000"+
    "\1\u5200\40\u2000\1\u5300\1\u5400\1\u2000\1\u5500\1\u5600\1\u5700"+
    "\1\u5800\26\u2000\1\u5900\2\u2000\1\u5a00\1\u5b00\15\u2000\246\u2a00"+
    "\1\u5c00\20\u2a00\1\u5d00\1\u5e00\77\u2000\2\u2a00\1\u5e00\u0b05\u2000"+
    "\1\u5f00\1\u6000\u02fe\u2000";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\42\0\1\1\4\0\1\2\4\0\1\3\1\0\1\4"+
    "\1\0\12\5\1\6\1\3\5\0\32\7\4\0\1\10"+
    "\1\0\32\7\57\0\1\7\2\0\1\11\7\0\1\7"+
    "\1\0\1\6\2\0\1\7\5\0\27\7\1\0\37\7"+
    "\1\0\u01ca\7\4\0\14\7\5\0\1\6\10\0\5\7"+
    "\7\0\1\7\1\0\1\7\21\0\160\11\5\7\1\0"+
    "\2\7\2\0\4\7\1\3\7\0\1\7\1\6\3\7"+
    "\1\0\1\7\1\0\24\7\1\0\123\7\1\0\213\7"+
    "\1\0\7\11\236\7\11\0\46\7\2\0\1\7\7\0"+
    "\47\7\1\0\1\3\7\0\55\11\1\0\1\11\1\0"+
    "\2\11\1\0\2\11\1\0\1\11\10\0\33\12\5\0"+
    "\3\12\1\7\1\6\13\0\5\11\7\0\2\3\2\0"+
    "\13\11\1\0\1\11\3\0\53\7\25\11\12\5\1\0"+
    "\1\5\1\3\1\0\2\7\1\11\143\7\1\0\1\7"+
    "\10\11\1\0\6\11\2\7\2\11\1\0\4\11\2\7"+
    "\12\5\3\7\2\0\1\7\17\0\1\11\1\7\1\11"+
    "\36\7\33\11\2\0\131\7\13\11\1\7\16\0\12\5"+
    "\41\7\11\11\2\7\2\0\1\3\1\0\1\7\5\0"+
    "\26\7\4\11\1\7\11\11\1\7\3\11\1\7\5\11"+
    "\22\0\31\7\3\11\104\0\1\7\1\0\13\7\67\0"+
    "\33\11\1\0\4\11\66\7\3\11\1\7\22\11\1\7"+
    "\7\11\12\7\2\11\2\0\12\5\1\0\7\7\1\0"+
    "\7\7\1\0\3\11\1\0\10\7\2\0\2\7\2\0"+
    "\26\7\1\0\7\7\1\0\1\7\3\0\4\7\2\0"+
    "\1\11\1\7\7\11\2\0\2\11\2\0\3\11\1\7"+
    "\10\0\1\11\4\0\2\7\1\0\3\7\2\11\2\0"+
    "\12\5\2\7\17\0\3\11\1\0\6\7\4\0\2\7"+
    "\2\0\26\7\1\0\7\7\1\0\2\7\1\0\2\7"+
    "\1\0\2\7\2\0\1\11\1\0\5\11\4\0\2\11"+
    "\2\0\3\11\3\0\1\11\7\0\4\7\1\0\1\7"+
    "\7\0\12\5\2\11\3\7\1\11\13\0\3\11\1\0"+
    "\11\7\1\0\3\7\1\0\26\7\1\0\7\7\1\0"+
    "\2\7\1\0\5\7\2\0\1\11\1\7\10\11\1\0"+
    "\3\11\1\0\3\11\2\0\1\7\17\0\2\7\2\11"+
    "\2\0\12\5\21\0\3\11\1\0\10\7\2\0\2\7"+
    "\2\0\26\7\1\0\7\7\1\0\2\7\1\0\5\7"+
    "\2\0\1\11\1\7\7\11\2\0\2\11\2\0\3\11"+
    "\10\0\2\11\4\0\2\7\1\0\3\7\2\11\2\0"+
    "\12\5\1\0\1\7\20\0\1\11\1\7\1\0\6\7"+
    "\3\0\3\7\1\0\4\7\3\0\2\7\1\0\1\7"+
    "\1\0\2\7\3\0\2\7\3\0\3\7\3\0\14\7"+
    "\4\0\5\11\3\0\3\11\1\0\4\11\2\0\1\7"+
    "\6\0\1\11\16\0\12\5\21\0\3\11\1\0\10\7"+
    "\1\0\3\7\1\0\27\7\1\0\12\7\1\0\5\7"+
    "\3\0\1\7\7\11\1\0\3\11\1\0\4\11\7\0"+
    "\2\11\1\0\2\7\6\0\2\7\2\11\2\0\12\5"+
    "\22\0\2\11\1\0\10\7\1\0\3\7\1\0\27\7"+
    "\1\0\12\7\1\0\5\7\2\0\1\11\1\7\7\11"+
    "\1\0\3\11\1\0\4\11\7\0\2\11\7\0\1\7"+
    "\1\0\2\7\2\11\2\0\12\5\1\0\2\7\17\0"+
    "\2\11\1\0\10\7\1\0\3\7\1\0\51\7\2\0"+
    "\1\7\7\11\1\0\3\11\1\0\4\11\1\7\10\0"+
    "\1\11\10\0\2\7\2\11\2\0\12\5\12\0\6\7"+
    "\2\0\2\11\1\0\22\7\3\0\30\7\1\0\11\7"+
    "\1\0\1\7\2\0\7\7\3\0\1\11\4\0\6\11"+
    "\1\0\1\11\1\0\10\11\22\0\2\11\15\0\60\13"+
    "\1\14\2\13\7\14\5\0\7\13\10\14\1\0\12\5"+
    "\47\0\2\13\1\0\1\13\2\0\2\13\1\0\1\13"+
    "\2\0\1\13\6\0\4\13\1\0\7\13\1\0\3\13"+
    "\1\0\1\13\1\0\1\13\2\0\2\13\1\0\4\13"+
    "\1\14\2\13\6\14\1\0\2\14\1\13\2\0\5\13"+
    "\1\0\1\13\1\0\6\14\2\0\12\5\2\0\4\13"+
    "\40\0\1\7\27\0\2\11\6\0\12\5\13\0\1\11"+
    "\1\0\1\11\1\0\1\11\4\0\2\11\10\7\1\0"+
    "\44\7\4\0\24\11\1\0\2\11\5\7\13\11\1\0"+
    "\44\11\11\0\1\11\71\0\53\13\24\14\1\13\12\5"+
    "\6\0\6\13\4\14\4\13\3\14\1\13\3\14\2\13"+
    "\7\14\3\13\4\14\15\13\14\14\1\13\1\14\12\5"+
    "\4\14\2\13\46\7\1\0\1\7\5\0\1\7\2\0"+
    "\53\7\1\0\4\7\u0100\15\111\7\1\0\4\7\2\0"+
    "\7\7\1\0\1\7\1\0\4\7\2\0\51\7\1\0"+
    "\4\7\2\0\41\7\1\0\4\7\2\0\7\7\1\0"+
    "\1\7\1\0\4\7\2\0\17\7\1\0\71\7\1\0"+
    "\4\7\2\0\103\7\2\0\3\11\40\0\20\7\20\0"+
    "\125\7\14\0\u016c\7\2\0\21\7\1\0\32\7\5\0"+
    "\113\7\3\0\3\7\17\0\15\7\1\0\4\7\3\11"+
    "\13\0\22\7\3\11\13\0\22\7\2\11\14\0\15\7"+
    "\1\0\3\7\1\0\2\11\14\0\64\13\40\14\3\0"+
    "\1\13\4\0\1\13\1\14\2\0\12\5\41\0\4\11"+
    "\1\0\12\5\6\0\130\7\10\0\51\7\1\11\1\7"+
    "\5\0\106\7\12\0\35\7\3\0\14\11\4\0\14\11"+
    "\12\0\12\5\36\13\2\0\5\13\13\0\54\13\4\0"+
    "\21\14\7\13\2\14\6\0\12\5\1\13\3\0\2\13"+
    "\40\0\27\7\5\11\4\0\65\13\12\14\1\0\35\14"+
    "\2\0\1\11\12\5\6\0\12\5\6\0\16\13\122\0"+
    "\5\11\57\7\21\11\7\7\4\0\12\5\21\0\11\11"+
    "\14\0\3\11\36\7\15\11\2\7\12\5\54\7\16\11"+
    "\14\0\44\7\24\11\10\0\12\5\3\0\3\7\12\5"+
    "\44\7\122\0\3\11\1\0\25\11\4\7\1\11\4\7"+
    "\3\11\2\7\11\0\300\7\47\11\25\0\4\11\26\7"+
    "\2\0\6\7\2\0\46\7\2\0\6\7\2\0\10\7"+
    "\1\0\1\7\1\0\1\7\1\0\1\7\1\0\37\7"+
    "\2\0\65\7\1\0\7\7\1\0\1\7\3\0\3\7"+
    "\1\0\7\7\3\0\4\7\2\0\6\7\4\0\15\7"+
    "\5\0\3\7\1\0\7\7\17\0\4\11\10\0\2\4"+
    "\12\0\1\4\2\0\1\6\2\0\5\11\20\0\2\10"+
    "\3\0\1\3\17\0\1\10\13\0\5\11\1\0\12\11"+
    "\1\0\1\7\15\0\1\7\20\0\15\7\63\0\41\11"+
    "\21\0\1\7\4\0\1\7\2\0\12\7\1\0\1\7"+
    "\3\0\5\7\6\0\1\7\1\0\1\7\1\0\1\7"+
    "\1\0\4\7\1\0\13\7\2\0\4\7\5\0\5\7"+
    "\4\0\1\7\21\0\51\7\u022d\0\64\7\26\0\57\7"+
    "\1\0\57\7\1\0\205\7\6\0\4\7\3\11\2\7"+
    "\14\0\46\7\1\0\1\7\5\0\1\7\2\0\70\7"+
    "\7\0\1\7\17\0\1\11\27\7\11\0\7\7\1\0"+
    "\7\7\1\0\7\7\1\0\7\7\1\0\7\7\1\0"+
    "\7\7\1\0\7\7\1\0\7\7\1\0\40\11\57\0"+
    "\1\7\120\0\32\16\1\0\131\16\14\0\326\16\57\0"+
    "\1\7\1\0\1\16\31\0\11\16\6\11\1\0\5\17"+
    "\2\0\3\16\2\7\4\0\126\20\2\0\2\11\2\17"+
    "\3\20\133\17\1\0\4\17\5\0\51\7\3\0\136\15"+
    "\21\0\33\7\65\0\20\17\320\0\57\17\1\0\130\17"+
    "\250\0\u01b6\16\112\0\315\16\63\0\215\7\103\0\56\7"+
    "\2\0\15\7\3\0\20\7\12\5\2\7\24\0\57\7"+
    "\4\11\1\0\12\11\1\0\31\7\7\0\1\11\120\7"+
    "\2\11\45\0\11\7\2\0\147\7\2\0\4\7\1\0"+
    "\4\7\14\0\13\7\115\0\12\7\1\11\3\7\1\11"+
    "\4\7\1\11\27\7\5\11\30\0\64\7\14\0\2\11"+
    "\62\7\21\11\13\0\12\5\6\0\22\11\6\7\3\0"+
    "\1\7\4\0\12\5\34\7\10\11\2\0\27\7\15\11"+
    "\14\0\35\15\3\0\4\11\57\7\16\11\16\0\1\7"+
    "\12\5\46\0\51\7\16\11\11\0\3\7\1\11\10\7"+
    "\2\11\2\0\12\5\6\0\33\13\1\14\4\0\60\13"+
    "\1\14\1\13\3\14\2\13\2\14\5\13\2\14\1\13"+
    "\1\14\1\13\30\0\5\13\13\7\5\11\2\0\3\7"+
    "\2\11\12\0\6\7\2\0\6\7\2\0\6\7\11\0"+
    "\7\7\1\0\7\7\221\0\43\7\10\11\1\0\2\11"+
    "\2\0\12\5\6\0\244\15\14\0\27\15\4\0\61\15"+
    "\4\0\1\21\1\22\1\23\1\24\1\25\1\26\2\0"+
    "\1\27\1\30\2\0\1\31\1\32\14\0\1\33\1\34"+
    "\20\0\1\35\7\0\1\36\1\37\5\0\1\40\1\41"+
    "\3\0\51\42\1\43\3\42\1\44\1\45\17\0\1\46"+
    "\301\0\1\47\277\0\1\50\1\51\1\52\3\53\2\54"+
    "\1\53\1\54\2\53\1\55\21\53\2\56\7\57\1\60"+
    "\7\57\7\61\1\62\1\61\1\63\2\64\1\65\1\63"+
    "\1\64\1\65\10\63\2\66\5\67\2\70\5\67\1\71"+
    "\10\72\5\73\3\74\12\75\20\74\3\76\32\77\1\100"+
    "\2\101\2\102\1\103\2\102\2\103\2\102\1\103\3\101"+
    "\1\104\2\101\12\105\1\106\1\107\1\110\1\105\6\107"+
    "\1\110\13\107\31\101\7\107\12\111\1\107\5\112\3\113"+
    "\3\114\1\115\4\114\2\115\10\114\1\115\7\116\1\117"+
    "\2\116\7\114\16\113\1\120\4\121\1\122\4\123\1\122"+
    "\5\124\1\125\1\124\3\125\7\124\1\125\23\124\5\126"+
    "\3\124\10\126\13\127\3\130\2\114\7\131\36\114\4\131"+
    "\5\114\5\113\6\132\2\113\1\132\4\116\13\133\12\123"+
    "\14\133\12\134\15\135\1\136\2\135\1\137\3\140\1\112"+
    "\2\140\5\141\4\140\4\142\1\141\3\142\1\141\5\142"+
    "\2\143\1\144\2\143\1\144\1\143\2\144\1\143\1\144"+
    "\12\143\1\144\4\145\1\146\1\147\1\150\1\151\3\152"+
    "\1\150\2\152\1\153\2\154\2\152\1\151\1\152\1\151"+
    "\1\152\1\151\1\152\3\151\1\152\2\151\1\152\1\151"+
    "\2\152\1\151\1\152\1\151\1\152\1\151\1\152\1\151"+
    "\1\152\1\151\1\155\2\156\1\155\1\156\2\155\4\156"+
    "\1\155\7\156\1\155\4\156\1\155\4\156\1\152\1\151"+
    "\1\152\12\157\1\160\21\157\1\160\3\161\1\160\3\157"+
    "\1\160\1\157\2\162\2\157\1\160\15\163\4\164\4\165"+
    "\1\166\1\167\10\166\7\165\6\152\4\170\1\171\37\170"+
    "\1\171\4\170\25\172\1\173\11\172\21\174\5\172\1\175"+
    "\12\176\5\172\6\177\4\155\1\200\1\174\5\201\12\202"+
    "\17\201\1\203\3\204\14\205\1\206\11\207\1\210\5\207"+
    "\4\211\13\212\2\213\11\207\1\210\31\207\1\210\4\206"+
    "\4\207\2\210\2\214\1\215\5\214\52\215\156\16\2\0"+
    "\152\16\46\0\7\7\14\0\5\7\5\0\1\12\1\11"+
    "\12\12\1\0\15\12\1\0\5\12\1\0\1\12\1\0"+
    "\2\12\1\0\2\12\1\0\12\12\142\7\41\0\153\7"+
    "\22\0\100\7\2\0\66\7\50\0\14\7\4\0\20\11"+
    "\1\3\2\0\1\6\1\3\13\0\7\11\14\0\2\10"+
    "\30\0\3\10\1\3\1\0\1\4\1\0\1\3\1\6"+
    "\32\0\5\7\1\0\207\7\2\0\1\11\7\0\1\4"+
    "\4\0\1\3\1\0\1\4\1\0\12\5\1\6\1\3"+
    "\5\0\32\7\4\0\1\10\1\0\32\7\13\0\70\17"+
    "\2\11\37\15\3\0\6\15\2\0\6\15\2\0\6\15"+
    "\2\0\3\15\34\0\3\11\4\0\14\7\1\0\32\7"+
    "\1\0\23\7\1\0\2\7\1\0\17\7\2\0\16\7"+
    "\42\0\173\7\105\0\65\7\210\0\1\11\202\0\35\7"+
    "\3\0\61\7\57\0\37\7\21\0\33\7\65\0\36\7"+
    "\2\0\44\7\4\0\10\7\1\0\5\7\52\0\236\7"+
    "\2\0\12\5\126\0\6\7\2\0\1\7\1\0\54\7"+
    "\1\0\2\7\3\0\1\7\2\0\27\7\252\0\26\7"+
    "\12\0\32\7\106\0\70\7\6\0\2\7\100\0\1\7"+
    "\3\11\1\0\2\11\5\0\4\11\4\7\1\0\3\7"+
    "\1\0\33\7\4\0\3\11\4\0\1\11\40\0\35\7"+
    "\203\0\66\7\12\0\26\7\12\0\23\7\215\0\111\7"+
    "\267\0\3\11\65\7\17\11\37\0\12\5\20\0\3\11"+
    "\55\7\13\11\2\0\1\11\22\0\31\7\7\0\12\5"+
    "\6\0\3\11\44\7\16\11\1\0\12\5\100\0\3\11"+
    "\60\7\16\11\4\7\13\0\12\5\246\0\53\7\15\11"+
    "\10\0\12\5\66\0\157\7\221\0\143\7\235\0\57\7"+
    "\321\0\71\7\307\0\105\7\13\0\1\7\56\11\20\0"+
    "\4\11\15\7\140\0\1\17\1\20\u0163\0\5\11\3\0"+
    "\26\11\2\0\7\11\36\0\4\11\224\0\3\11\273\0"+
    "\125\7\1\0\107\7\1\0\2\7\2\0\1\7\2\0"+
    "\2\7\2\0\4\7\1\0\14\7\1\0\1\7\1\0"+
    "\7\7\1\0\101\7\1\0\4\7\2\0\10\7\1\0"+
    "\7\7\1\0\34\7\1\0\4\7\1\0\5\7\1\0"+
    "\1\7\3\0\7\7\1\0\u0154\7\2\0\31\7\1\0"+
    "\31\7\1\0\37\7\1\0\31\7\1\0\37\7\1\0"+
    "\31\7\1\0\37\7\1\0\31\7\1\0\37\7\1\0"+
    "\31\7\1\0\10\7\2\0\62\5\4\7\1\0\33\7"+
    "\1\0\2\7\1\0\1\7\2\0\1\7\1\0\12\7"+
    "\1\0\4\7\1\0\1\7\1\0\1\7\6\0\1\7"+
    "\4\0\1\7\1\0\1\7\1\0\1\7\1\0\3\7"+
    "\1\0\2\7\1\0\1\7\2\0\1\7\1\0\1\7"+
    "\1\0\1\7\1\0\1\7\1\0\1\7\1\0\2\7"+
    "\1\0\1\7\2\0\4\7\1\0\7\7\1\0\4\7"+
    "\1\0\4\7\1\0\1\7\1\0\12\7\1\0\21\7"+
    "\5\0\3\7\1\0\5\7\1\0\21\7\u012a\0\32\216"+
    "\1\20\377\0\327\16\51\0\65\16\13\0\336\16\343\0"+
    "\1\11\36\0\140\11\200\0\360\11\20\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[24832];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\1\1\3\1\4\1\5"+
    "\1\6\1\7\1\10\26\1\1\0\1\2\21\0\2\3"+
    "\12\0\1\3\11\0\1\3\55\0\1\1\115\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[198];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\217\0\u011e\0\u01ad\0\u023c\0\u02cb\0\u035a\0\u03e9"+
    "\0\u0478\0\u0507\0\u0596\0\u0625\0\u06b4\0\u0743\0\u07d2\0\u0861"+
    "\0\u08f0\0\u097f\0\u0a0e\0\u0a9d\0\u0b2c\0\u0bbb\0\u0c4a\0\u0cd9"+
    "\0\u0d68\0\u0df7\0\u0e86\0\u0f15\0\u0fa4\0\u1033\0\u10c2\0\u1151"+
    "\0\u11e0\0\u126f\0\u12fe\0\u138d\0\u06b4\0\u141c\0\u07d2\0\u14ab"+
    "\0\u153a\0\u097f\0\u0a0e\0\u0a9d\0\u0b2c\0\u0bbb\0\u15c9\0\u1658"+
    "\0\u0d68\0\u0df7\0\u16e7\0\u1776\0\u1805\0\u1894\0\u1923\0\u19b2"+
    "\0\u1a41\0\u1ad0\0\u1b5f\0\u1bee\0\u1c7d\0\u1d0c\0\u1d9b\0\u023c"+
    "\0\u1e2a\0\u1eb9\0\u1f48\0\u1fd7\0\u2066\0\u20f5\0\u2184\0\u2213"+
    "\0\u22a2\0\u2331\0\u23c0\0\u244f\0\u24de\0\u256d\0\u25fc\0\u268b"+
    "\0\u271a\0\u27a9\0\u2838\0\u28c7\0\u2956\0\u29e5\0\u2a74\0\u2b03"+
    "\0\u2b92\0\u2c21\0\u2cb0\0\u2d3f\0\u2dce\0\u2e5d\0\u2eec\0\u2f7b"+
    "\0\u300a\0\u3099\0\u3128\0\u31b7\0\u3246\0\u32d5\0\u3364\0\u33f3"+
    "\0\u3482\0\u3511\0\u35a0\0\u362f\0\u36be\0\u374d\0\u37dc\0\u11e0"+
    "\0\u386b\0\u38fa\0\u3989\0\u3a18\0\u3aa7\0\u3b36\0\u3bc5\0\u3c54"+
    "\0\u3ce3\0\u3d72\0\u3e01\0\u3e90\0\u3f1f\0\u3fae\0\u403d\0\u40cc"+
    "\0\u415b\0\u41ea\0\u4279\0\u4308\0\u4397\0\u4426\0\u44b5\0\u4544"+
    "\0\u45d3\0\u4662\0\u46f1\0\u4780\0\u480f\0\u489e\0\u492d\0\u49bc"+
    "\0\u4a4b\0\u4ada\0\u4b69\0\u4bf8\0\u4c87\0\u4d16\0\u4da5\0\u4e34"+
    "\0\u4ec3\0\u4f52\0\u4fe1\0\u5070\0\u50ff\0\u518e\0\u521d\0\u52ac"+
    "\0\u533b\0\u53ca\0\u5459\0\u54e8\0\u5577\0\u5606\0\u5695\0\u5724"+
    "\0\u57b3\0\u5842\0\u58d1\0\u5960\0\u59ef\0\u5a7e\0\u5b0d\0\u5b9c"+
    "\0\u5c2b\0\u5cba\0\u5d49\0\u5dd8\0\u5e67\0\u5ef6\0\u5f85\0\u6014"+
    "\0\u60a3\0\u6132\0\u61c1\0\u6250\0\u62df\0\u636e\0\u63fd\0\u648c"+
    "\0\u651b\0\u65aa\0\u6639\0\u66c8\0\u6757\0\u67e6";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[198];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\5\2\1\3\1\2\1\4\1\5\1\2\1\6\2\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\2\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\147\2\1\41\221\0\3\42\1\3\1\0"+
    "\1\4\1\43\1\3\1\6\1\0\1\3\1\4\3\0"+
    "\1\44\1\45\1\46\1\47\1\50\1\51\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\0\1\60\1\61\1\62"+
    "\6\0\1\63\151\0\1\64\1\0\1\64\1\65\1\64"+
    "\1\4\1\66\1\4\1\6\1\0\2\4\3\0\1\67"+
    "\1\70\1\71\1\47\1\72\1\73\1\52\1\53\1\54"+
    "\1\55\1\56\1\74\1\0\1\75\1\76\1\62\6\0"+
    "\1\77\154\0\1\3\1\0\1\4\2\100\1\6\1\0"+
    "\1\100\1\4\1\0\1\101\1\0\1\102\1\45\1\103"+
    "\1\47\1\104\1\105\1\52\1\53\1\54\1\55\1\56"+
    "\1\106\1\107\1\110\1\61\1\62\6\0\1\111\150\0"+
    "\1\112\1\113\1\0\1\64\1\65\1\64\1\4\1\66"+
    "\2\6\1\0\1\6\1\4\3\0\1\114\1\70\1\115"+
    "\1\47\1\116\1\117\1\52\1\53\1\54\1\55\1\56"+
    "\1\120\1\0\1\121\1\76\1\62\6\0\1\122\162\0"+
    "\2\7\204\0\1\64\1\0\1\64\1\65\1\64\1\4"+
    "\1\66\1\10\1\6\1\0\2\10\3\0\1\123\1\70"+
    "\1\124\1\47\1\125\1\126\1\52\1\53\1\54\1\55"+
    "\1\56\1\127\1\0\1\130\1\76\1\62\6\0\1\131"+
    "\160\0\1\11\2\0\1\11\4\0\1\132\1\0\1\133"+
    "\1\0\1\134\1\135\5\0\1\136\1\0\1\137\10\0"+
    "\1\140\157\0\1\66\1\12\2\0\1\12\2\0\1\12"+
    "\1\0\1\141\1\0\1\142\1\0\1\143\1\144\5\0"+
    "\1\145\1\146\1\147\10\0\1\150\160\0\1\13\2\0"+
    "\1\13\4\0\1\151\1\0\1\152\1\0\1\153\1\154"+
    "\5\0\1\155\1\0\1\156\10\0\1\157\217\0\5\4"+
    "\1\0\2\4\1\0\4\4\1\0\2\4\1\0\2\4"+
    "\3\0\14\4\12\0\3\4\30\0\2\4\1\0\6\4"+
    "\2\0\2\4\1\0\3\4\7\0\4\4\1\0\1\4"+
    "\52\0\31\4\1\0\2\3\163\0\4\4\1\0\5\4"+
    "\1\0\1\4\2\0\4\4\21\0\3\4\2\0\2\4"+
    "\6\0\2\4\5\0\1\4\2\0\3\4\10\0\2\4"+
    "\13\0\4\4\1\0\3\4\1\0\2\4\62\0\17\4"+
    "\203\0\10\4\12\0\1\3\1\0\6\4\4\0\1\3"+
    "\2\0\4\4\1\0\3\3\5\0\1\4\244\0\4\4"+
    "\3\0\2\3\77\0\133\4\64\0\24\4\173\0\146\4"+
    "\51\0\11\4\206\0\77\4\242\0\5\4\13\0\2\4"+
    "\53\0\1\12\1\13\215\0\21\4\1\0\6\4\1\0"+
    "\1\4\1\0\1\4\1\0\1\4\1\0\1\4\1\0"+
    "\4\4\1\0\1\4\1\0\2\4\1\0\2\4\1\0"+
    "\34\4\1\0\4\4\1\0\1\4\1\0\1\4\1\0"+
    "\1\4\1\0\2\4\1\0\2\4\1\0\4\4\1\0"+
    "\3\4\2\3\140\0\5\4\1\0\1\4\1\0\1\4"+
    "\1\0\1\4\1\0\1\4\2\0\2\4\2\0\3\4"+
    "\166\0\3\160\1\13\127\0\146\11\51\0\120\11\2\0"+
    "\24\11\51\0\125\11\2\0\17\11\51\0\6\11\211\0"+
    "\73\11\65\0\1\160\2\0\1\160\4\0\1\161\1\0"+
    "\1\162\1\0\1\163\1\164\5\0\1\165\1\0\1\166"+
    "\2\0\1\167\5\0\1\170\146\0\1\171\5\0\1\3"+
    "\3\0\1\42\2\0\1\42\4\0\1\172\1\173\1\174"+
    "\1\0\1\175\1\176\5\0\1\177\1\0\1\200\1\201"+
    "\7\0\1\202\154\0\1\3\1\0\1\4\2\43\1\6"+
    "\1\0\1\43\1\4\1\0\1\101\1\0\1\203\1\45"+
    "\1\204\1\47\1\205\1\206\1\52\1\53\1\54\1\55"+
    "\1\56\1\207\1\107\1\210\1\61\1\62\6\0\1\211"+
    "\217\0\5\4\1\0\2\4\1\0\4\4\1\0\2\4"+
    "\1\0\2\4\3\0\14\4\12\0\3\4\7\0\1\3"+
    "\20\0\2\4\1\0\6\4\2\0\2\4\1\0\3\4"+
    "\7\0\4\4\1\0\1\4\52\0\4\4\1\0\5\4"+
    "\1\0\1\4\2\0\4\4\21\0\3\4\2\0\2\4"+
    "\6\0\2\4\5\0\1\4\1\3\1\0\3\4\1\0"+
    "\3\3\4\0\2\4\13\0\4\4\1\0\3\4\1\0"+
    "\2\4\62\0\3\3\10\4\3\3\7\0\2\3\6\4"+
    "\2\3\2\0\1\3\1\0\1\3\4\4\1\0\3\3"+
    "\4\0\1\3\1\4\1\3\243\0\4\4\1\3\2\0"+
    "\2\3\221\0\5\4\2\0\5\3\3\0\1\3\2\4"+
    "\131\0\4\3\21\0\2\3\113\0\1\3\5\0\17\3"+
    "\15\0\22\3\71\0\1\4\1\0\1\64\1\4\1\0"+
    "\1\64\1\4\3\0\1\212\1\213\1\214\1\47\1\215"+
    "\1\216\1\52\1\53\1\54\1\55\1\56\1\217\1\0"+
    "\1\220\1\221\1\62\6\0\1\222\151\0\3\223\1\65"+
    "\1\0\1\4\1\66\1\65\1\6\1\0\1\65\1\4"+
    "\3\0\1\224\1\70\1\225\1\47\1\226\1\227\1\52"+
    "\1\53\1\54\1\55\1\56\1\230\1\0\1\231\1\76"+
    "\1\62\6\0\1\232\154\0\1\65\1\0\1\4\2\66"+
    "\1\6\1\0\1\66\1\4\1\0\1\101\1\0\1\233"+
    "\1\70\1\234\1\47\1\235\1\236\1\52\1\53\1\54"+
    "\1\55\1\56\1\237\1\107\1\240\1\76\1\62\6\0"+
    "\1\241\217\0\5\4\1\0\2\4\1\0\4\4\1\0"+
    "\2\4\1\0\2\4\3\0\14\4\12\0\3\4\7\0"+
    "\1\4\20\0\2\4\1\0\6\4\2\0\2\4\1\0"+
    "\3\4\7\0\4\4\1\0\1\4\52\0\31\4\1\0"+
    "\2\65\163\0\4\4\1\0\5\4\1\0\1\4\2\0"+
    "\4\4\21\0\3\4\2\0\2\4\6\0\2\4\5\0"+
    "\2\4\1\0\3\4\1\0\3\4\4\0\2\4\13\0"+
    "\4\4\1\0\3\4\1\0\2\4\62\0\16\4\7\0"+
    "\1\65\11\4\2\0\1\65\1\0\5\4\1\0\3\65"+
    "\4\0\3\4\243\0\5\4\2\0\2\65\221\0\5\4"+
    "\2\0\5\4\3\0\3\4\131\0\4\4\21\0\2\4"+
    "\112\0\21\4\1\0\6\4\1\0\1\4\1\0\1\4"+
    "\1\0\1\4\1\0\1\4\1\0\4\4\1\0\1\4"+
    "\1\0\2\4\1\0\2\4\1\0\34\4\1\0\4\4"+
    "\1\0\1\4\1\0\1\4\1\0\1\4\1\0\2\4"+
    "\1\0\2\4\1\0\4\4\1\0\3\4\2\65\52\0"+
    "\1\4\5\0\17\4\15\0\22\4\72\0\1\66\1\101"+
    "\2\0\1\101\2\0\1\101\1\0\1\242\1\0\1\243"+
    "\1\0\1\244\1\245\5\0\1\246\1\107\1\247\10\0"+
    "\1\250\217\0\5\4\1\0\2\4\1\0\4\4\1\0"+
    "\2\4\1\0\2\4\3\0\14\4\12\0\3\4\7\0"+
    "\1\100\20\0\2\4\1\0\6\4\2\0\2\4\1\0"+
    "\3\4\7\0\4\4\1\0\1\4\52\0\4\4\1\0"+
    "\5\4\1\0\1\4\2\0\4\4\21\0\3\4\2\0"+
    "\2\4\6\0\2\4\5\0\1\4\1\100\1\0\3\4"+
    "\1\0\3\100\4\0\2\4\13\0\4\4\1\0\3\4"+
    "\1\0\2\4\62\0\3\100\10\4\3\100\7\0\1\3"+
    "\1\100\6\4\2\100\2\0\1\3\1\0\1\100\4\4"+
    "\1\0\3\3\4\0\1\100\1\4\1\100\243\0\4\4"+
    "\1\100\2\0\2\3\221\0\5\4\2\0\5\100\3\0"+
    "\1\100\2\4\53\0\1\101\274\0\4\100\21\0\2\100"+
    "\113\0\1\100\5\0\17\100\15\0\22\100\73\0\1\112"+
    "\1\113\1\0\1\112\4\0\1\251\1\0\1\252\1\0"+
    "\1\253\1\254\5\0\1\255\1\0\1\256\10\0\1\257"+
    "\154\0\1\65\1\0\1\4\1\66\1\113\1\6\1\0"+
    "\1\113\1\4\3\0\1\260\1\70\1\261\1\47\1\262"+
    "\1\263\1\52\1\53\1\54\1\55\1\56\1\264\1\0"+
    "\1\265\1\76\1\62\6\0\1\266\217\0\5\4\1\0"+
    "\2\4\1\0\4\4\1\0\2\4\1\0\2\4\3\0"+
    "\14\4\12\0\3\4\7\0\1\6\20\0\2\4\1\0"+
    "\6\4\2\0\2\4\1\0\3\4\7\0\4\4\1\0"+
    "\1\4\52\0\4\4\1\0\5\4\1\0\1\4\2\0"+
    "\4\4\21\0\3\4\2\0\2\4\6\0\2\4\5\0"+
    "\1\4\1\6\1\0\3\4\1\0\3\6\4\0\2\4"+
    "\13\0\4\4\1\0\3\4\1\0\2\4\62\0\3\6"+
    "\10\4\3\6\7\0\1\65\1\6\6\4\2\6\2\0"+
    "\1\65\1\0\1\6\4\4\1\0\3\65\4\0\1\6"+
    "\1\4\1\6\243\0\4\4\1\6\2\0\2\65\221\0"+
    "\5\4\2\0\5\6\3\0\1\6\2\4\131\0\4\6"+
    "\21\0\2\6\113\0\1\6\5\0\17\6\15\0\22\6"+
    "\132\0\5\4\1\0\2\4\1\0\4\4\1\0\2\4"+
    "\1\0\2\4\3\0\14\4\12\0\3\4\7\0\1\10"+
    "\20\0\2\4\1\0\6\4\2\0\2\4\1\0\3\4"+
    "\7\0\4\4\1\0\1\4\52\0\4\4\1\0\5\4"+
    "\1\0\1\4\2\0\4\4\21\0\3\4\2\0\2\4"+
    "\6\0\2\4\5\0\1\4\1\10\1\0\3\4\1\0"+
    "\3\10\4\0\2\4\13\0\4\4\1\0\3\4\1\0"+
    "\2\4\62\0\3\10\10\4\3\10\7\0\1\65\1\10"+
    "\6\4\2\10\2\0\1\65\1\0\1\10\4\4\1\0"+
    "\3\65\4\0\1\10\1\4\1\10\243\0\4\4\1\10"+
    "\2\0\2\65\221\0\5\4\2\0\5\10\3\0\1\10"+
    "\2\4\131\0\4\10\21\0\2\10\113\0\1\10\5\0"+
    "\17\10\15\0\22\10\220\0\1\11\220\0\1\11\5\0"+
    "\3\11\116\0\3\11\10\0\3\11\10\0\1\11\6\0"+
    "\2\11\4\0\1\11\14\0\1\11\1\0\1\11\247\0"+
    "\1\11\234\0\5\11\3\0\1\11\133\0\4\11\21\0"+
    "\2\11\113\0\1\11\5\0\17\11\15\0\22\11\220\0"+
    "\1\12\220\0\1\12\5\0\3\12\116\0\3\12\10\0"+
    "\3\12\10\0\1\12\6\0\2\12\4\0\1\12\14\0"+
    "\1\12\1\0\1\12\247\0\1\12\234\0\5\12\3\0"+
    "\1\12\55\0\1\12\274\0\4\12\21\0\2\12\113\0"+
    "\1\12\5\0\17\12\15\0\22\12\220\0\1\13\220\0"+
    "\1\13\5\0\3\13\116\0\3\13\10\0\3\13\10\0"+
    "\1\13\6\0\2\13\4\0\1\13\14\0\1\13\1\0"+
    "\1\13\247\0\1\13\234\0\5\13\3\0\1\13\133\0"+
    "\4\13\21\0\2\13\113\0\1\13\5\0\17\13\15\0"+
    "\22\13\220\0\1\160\220\0\1\160\5\0\3\160\116\0"+
    "\3\160\10\0\3\160\10\0\1\160\6\0\2\160\4\0"+
    "\1\160\14\0\1\160\1\0\1\160\247\0\1\160\234\0"+
    "\5\160\3\0\1\160\133\0\4\160\21\0\2\160\176\0"+
    "\3\171\131\0\1\160\5\0\17\160\15\0\22\160\73\0"+
    "\1\171\2\0\1\171\4\0\1\267\1\0\1\270\1\0"+
    "\1\271\1\272\5\0\1\273\1\0\1\274\2\0\1\167"+
    "\5\0\1\275\146\0\1\171\136\0\1\42\162\0\2\3"+
    "\253\0\1\42\5\0\3\42\116\0\3\42\10\0\3\42"+
    "\7\0\1\3\1\42\6\0\2\42\2\0\1\3\1\0"+
    "\1\42\5\0\3\3\4\0\1\42\1\0\1\42\247\0"+
    "\1\42\2\0\2\3\230\0\5\42\3\0\1\42\133\0"+
    "\4\42\21\0\2\42\256\0\2\3\52\0\1\42\5\0"+
    "\17\42\15\0\22\42\132\0\5\4\1\0\2\4\1\0"+
    "\4\4\1\0\2\4\1\0\2\4\3\0\14\4\12\0"+
    "\3\4\7\0\1\43\20\0\2\4\1\0\6\4\2\0"+
    "\2\4\1\0\3\4\7\0\4\4\1\0\1\4\52\0"+
    "\4\4\1\0\5\4\1\0\1\4\2\0\4\4\21\0"+
    "\3\4\2\0\2\4\6\0\2\4\5\0\1\4\1\43"+
    "\1\0\3\4\1\0\3\43\4\0\2\4\13\0\4\4"+
    "\1\0\3\4\1\0\2\4\62\0\3\43\10\4\3\43"+
    "\7\0\1\3\1\43\6\4\2\43\2\0\1\3\1\0"+
    "\1\43\4\4\1\0\3\3\4\0\1\43\1\4\1\43"+
    "\243\0\4\4\1\43\2\0\2\3\221\0\5\4\2\0"+
    "\5\43\3\0\1\43\2\4\131\0\4\43\21\0\2\43"+
    "\113\0\1\43\5\0\17\43\15\0\22\43\132\0\5\4"+
    "\1\0\2\4\1\0\4\4\1\0\2\4\1\0\2\4"+
    "\3\0\14\4\12\0\3\4\7\0\1\64\20\0\2\4"+
    "\1\0\6\4\2\0\2\4\1\0\3\4\7\0\4\4"+
    "\1\0\1\4\52\0\31\4\166\0\4\4\1\0\5\4"+
    "\1\0\1\4\2\0\4\4\21\0\3\4\2\0\2\4"+
    "\6\0\2\4\5\0\1\4\1\64\1\0\3\4\1\0"+
    "\3\64\4\0\2\4\13\0\4\4\1\0\3\4\1\0"+
    "\2\4\62\0\3\64\10\4\3\64\10\0\1\64\6\4"+
    "\2\64\4\0\1\64\4\4\10\0\1\64\1\4\1\64"+
    "\243\0\4\4\1\64\225\0\5\4\2\0\5\64\3\0"+
    "\1\64\2\4\131\0\4\64\21\0\2\64\112\0\21\4"+
    "\1\0\6\4\1\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\1\4\1\0\4\4\1\0\1\4\1\0\2\4"+
    "\1\0\2\4\1\0\34\4\1\0\4\4\1\0\1\4"+
    "\1\0\1\4\1\0\1\4\1\0\2\4\1\0\2\4"+
    "\1\0\4\4\1\0\3\4\54\0\1\64\5\0\17\64"+
    "\15\0\22\64\67\0\1\65\3\0\1\223\2\0\1\223"+
    "\4\0\1\276\1\277\1\300\1\0\1\301\1\302\5\0"+
    "\1\303\1\0\1\304\1\305\7\0\1\306\217\0\5\4"+
    "\1\0\2\4\1\0\4\4\1\0\2\4\1\0\2\4"+
    "\3\0\14\4\12\0\3\4\7\0\1\65\20\0\2\4"+
    "\1\0\6\4\2\0\2\4\1\0\3\4\7\0\4\4"+
    "\1\0\1\4\52\0\4\4\1\0\5\4\1\0\1\4"+
    "\2\0\4\4\21\0\3\4\2\0\2\4\6\0\2\4"+
    "\5\0\1\4\1\65\1\0\3\4\1\0\3\65\4\0"+
    "\2\4\13\0\4\4\1\0\3\4\1\0\2\4\62\0"+
    "\3\65\10\4\3\65\7\0\2\65\6\4\2\65\2\0"+
    "\1\65\1\0\1\65\4\4\1\0\3\65\4\0\1\65"+
    "\1\4\1\65\243\0\4\4\1\65\2\0\2\65\221\0"+
    "\5\4\2\0\5\65\3\0\1\65\2\4\131\0\4\65"+
    "\21\0\2\65\113\0\1\65\5\0\17\65\15\0\22\65"+
    "\132\0\5\4\1\0\2\4\1\0\4\4\1\0\2\4"+
    "\1\0\2\4\3\0\14\4\12\0\3\4\7\0\1\66"+
    "\20\0\2\4\1\0\6\4\2\0\2\4\1\0\3\4"+
    "\7\0\4\4\1\0\1\4\52\0\4\4\1\0\5\4"+
    "\1\0\1\4\2\0\4\4\21\0\3\4\2\0\2\4"+
    "\6\0\2\4\5\0\1\4\1\66\1\0\3\4\1\0"+
    "\3\66\4\0\2\4\13\0\4\4\1\0\3\4\1\0"+
    "\2\4\62\0\3\66\10\4\3\66\7\0\1\65\1\66"+
    "\6\4\2\66\2\0\1\65\1\0\1\66\4\4\1\0"+
    "\3\65\4\0\1\66\1\4\1\66\243\0\4\4\1\66"+
    "\2\0\2\65\221\0\5\4\2\0\5\66\3\0\1\66"+
    "\2\4\131\0\4\66\21\0\2\66\113\0\1\66\5\0"+
    "\17\66\15\0\22\66\220\0\1\101\220\0\1\101\5\0"+
    "\3\101\116\0\3\101\10\0\3\101\10\0\1\101\6\0"+
    "\2\101\4\0\1\101\14\0\1\101\1\0\1\101\247\0"+
    "\1\101\234\0\5\101\3\0\1\101\133\0\4\101\21\0"+
    "\2\101\113\0\1\101\5\0\17\101\15\0\22\101\220\0"+
    "\1\112\220\0\1\112\5\0\3\112\116\0\3\112\10\0"+
    "\3\112\10\0\1\112\6\0\2\112\4\0\1\112\14\0"+
    "\1\112\1\0\1\112\247\0\1\112\234\0\5\112\3\0"+
    "\1\112\133\0\4\112\21\0\2\112\113\0\1\112\5\0"+
    "\17\112\15\0\22\112\132\0\5\4\1\0\2\4\1\0"+
    "\4\4\1\0\2\4\1\0\2\4\3\0\14\4\12\0"+
    "\3\4\7\0\1\113\20\0\2\4\1\0\6\4\2\0"+
    "\2\4\1\0\3\4\7\0\4\4\1\0\1\4\52\0"+
    "\4\4\1\0\5\4\1\0\1\4\2\0\4\4\21\0"+
    "\3\4\2\0\2\4\6\0\2\4\5\0\1\4\1\113"+
    "\1\0\3\4\1\0\3\113\4\0\2\4\13\0\4\4"+
    "\1\0\3\4\1\0\2\4\62\0\3\113\10\4\3\113"+
    "\7\0\1\65\1\113\6\4\2\113\2\0\1\65\1\0"+
    "\1\113\4\4\1\0\3\65\4\0\1\113\1\4\1\113"+
    "\243\0\4\4\1\113\2\0\2\65\221\0\5\4\2\0"+
    "\5\113\3\0\1\113\2\4\131\0\4\113\21\0\2\113"+
    "\113\0\1\113\5\0\17\113\15\0\22\113\220\0\1\171"+
    "\220\0\1\171\5\0\3\171\116\0\3\171\10\0\3\171"+
    "\10\0\1\171\6\0\2\171\4\0\1\171\14\0\1\171"+
    "\1\0\1\171\247\0\1\171\234\0\5\171\3\0\1\171"+
    "\133\0\4\171\21\0\2\171\113\0\1\171\5\0\17\171"+
    "\15\0\22\171\220\0\1\223\162\0\2\65\253\0\1\223"+
    "\5\0\3\223\116\0\3\223\10\0\3\223\7\0\1\65"+
    "\1\223\6\0\2\223\2\0\1\65\1\0\1\223\5\0"+
    "\3\65\4\0\1\223\1\0\1\223\247\0\1\223\2\0"+
    "\2\65\230\0\5\223\3\0\1\223\133\0\4\223\21\0"+
    "\2\223\256\0\2\65\52\0\1\223\5\0\17\223\15\0"+
    "\22\223\62\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[26741];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\37\1\1\0\1\1\21\0\2\1\12\0"+
    "\1\1\11\0\1\1\55\0\1\1\115\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[198];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  /** Alphanumeric sequences */
  public static final int WORD_TYPE = StandardAnalyzer.TokenType.ALPHANUM.value;
  
  /** Numbers */
  public static final int NUMERIC_TYPE = StandardAnalyzer.TokenType.NUM.value;
  
  /**
   * Chars in class \p{Line_Break = Complex_Context} are from South East Asian
   * scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
   * together as as a single token rather than broken up, because the logic
   * required to break them at word boundaries is too complex for UAX#29.
   * <p>
   * See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
   */
  public static final int SOUTH_EAST_ASIAN_TYPE = StandardAnalyzer.TokenType.SOUTHEAST_ASIAN.value;
  
  public static final int IDEOGRAPHIC_TYPE = StandardAnalyzer.TokenType.IDEOGRAPHIC.value;
  
  public static final int HIRAGANA_TYPE = StandardAnalyzer.TokenType.HIRAGANA.value;
  
  public static final int KATAKANA_TYPE = StandardAnalyzer.TokenType.KATAKANA.value;
  
  public static final int HANGUL_TYPE = StandardAnalyzer.TokenType.HANGUL.value;

  public final long yychar()
  {
    return yychar;
  }

  public String getText()
  {
    return String.valueOf(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }

  public char[] getArray()
  {
    return Arrays.copyOfRange(zzBuffer, zzStartRead, zzMarkedPos);
  }

  public byte[] getBytes()
  {
    return getText().getBytes();
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public StandardTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return StandardAnalyzer.TokenType.EOF.value;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { /* Break so we don't hit fall-through warning: */ break; /* Not numeric, word, ideographic, hiragana, or SE Asian -- ignore it. */
            }
            // fall through
          case 9: break;
          case 2:
            { return NUMERIC_TYPE;
            }
            // fall through
          case 10: break;
          case 3:
            { return WORD_TYPE;
            }
            // fall through
          case 11: break;
          case 4:
            { return SOUTH_EAST_ASIAN_TYPE;
            }
            // fall through
          case 12: break;
          case 5:
            { return HANGUL_TYPE;
            }
            // fall through
          case 13: break;
          case 6:
            { return IDEOGRAPHIC_TYPE;
            }
            // fall through
          case 14: break;
          case 7:
            { return KATAKANA_TYPE;
            }
            // fall through
          case 15: break;
          case 8:
            { return HIRAGANA_TYPE;
            }
            // fall through
          case 16: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
