/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.JavaBasedUDFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDFContext;
import org.apache.cassandra.cql3.functions.UDFContextImpl;
import org.apache.cassandra.cql3.functions.UDFDataType;
import org.apache.cassandra.cql3.functions.UserFunction;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.FunctionExecutionException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.UserFunctions;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UDFunction
extends UserFunction
implements ScalarFunction {
    protected static final Logger logger = LoggerFactory.getLogger(UDFunction.class);
    static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    protected final List<ColumnIdentifier> argNames;
    protected final String language;
    protected final String body;
    protected final List<UDFDataType> argumentTypes;
    protected final UDFDataType resultType;
    protected final boolean calledOnNullInput;
    protected final UDFContext udfContext;
    private static final String[] allowedPatterns = new String[]{"com/google/common/reflect/TypeToken", "java/io/IOException.class", "java/io/Serializable.class", "java/lang/", "java/math/", "java/net/InetAddress.class", "java/net/Inet4Address.class", "java/net/Inet6Address.class", "java/net/UnknownHostException.class", "java/net/NetworkInterface.class", "java/net/SocketException.class", "java/nio/Buffer.class", "java/nio/ByteBuffer.class", "java/text/", "java/time/", "java/util/", "org/apache/cassandra/cql3/functions/types/", "org/apache/cassandra/cql3/functions/Arguments.class", "org/apache/cassandra/cql3/functions/UDFDataType.class", "org/apache/cassandra/cql3/functions/JavaUDF.class", "org/apache/cassandra/cql3/functions/UDFContext.class", "org/apache/cassandra/exceptions/", "org/apache/cassandra/transport/ProtocolVersion.class"};
    private static final String[] disallowedPatterns = new String[]{"com/datastax/driver/core/Cluster.class", "com/datastax/driver/core/Metrics.class", "com/datastax/driver/core/NettyOptions.class", "com/datastax/driver/core/Session.class", "com/datastax/driver/core/Statement.class", "com/datastax/driver/core/TimestampGenerator.class", "java/lang/Compiler.class", "java/lang/InheritableThreadLocal.class", "java/lang/Package.class", "java/lang/Process.class", "java/lang/ProcessBuilder.class", "java/lang/ProcessEnvironment.class", "java/lang/ProcessImpl.class", "java/lang/Runnable.class", "java/lang/Runtime.class", "java/lang/Shutdown.class", "java/lang/Thread.class", "java/lang/ThreadGroup.class", "java/lang/ThreadLocal.class", "java/lang/instrument/", "java/lang/invoke/", "java/lang/management/", "java/lang/ref/", "java/lang/reflect/", "java/util/ServiceLoader.class", "java/util/Timer.class", "java/util/concurrent/", "java/util/function/", "java/util/jar/", "java/util/logging/", "java/util/prefs/", "java/util/spi/", "java/util/stream/", "java/util/zip/"};
    private static final String[] disallowedPatternsSyncUDF = new String[]{"java/lang/System.class"};
    static final ClassLoader udfClassLoader = new UDFClassLoader();

    static boolean secureResource(String resource) {
        while (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        for (String allowed : allowedPatterns) {
            if (!resource.startsWith(allowed)) continue;
            for (String disallowed : disallowedPatterns) {
                if (!resource.startsWith(disallowed)) continue;
                logger.trace("access denied: resource {}", (Object)resource);
                return false;
            }
            if (!DatabaseDescriptor.enableUserDefinedFunctionsThreads() && !DatabaseDescriptor.allowExtraInsecureUDFs()) {
                for (String disallowed : disallowedPatternsSyncUDF) {
                    if (!resource.startsWith(disallowed)) continue;
                    logger.trace("access denied: resource {}", (Object)resource);
                    return false;
                }
            }
            return true;
        }
        logger.trace("access denied: resource {}", (Object)resource);
        return false;
    }

    protected UDFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) {
        super(name, argTypes, returnType);
        assert (new HashSet<ColumnIdentifier>(argNames).size() == argNames.size()) : "duplicate argument names";
        this.argNames = argNames;
        this.language = language;
        this.body = body;
        this.argumentTypes = UDFDataType.wrap(argTypes, !calledOnNullInput);
        this.resultType = UDFDataType.wrap(returnType, !calledOnNullInput);
        this.calledOnNullInput = calledOnNullInput;
        this.udfContext = new UDFContextImpl(argNames, this.argumentTypes, this.resultType, name.keyspace);
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return FunctionArguments.newInstanceForUdf(version, this.argumentTypes);
    }

    public static UDFunction tryCreate(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) {
        try {
            return UDFunction.create(name, argNames, argTypes, returnType, calledOnNullInput, language, body);
        }
        catch (InvalidRequestException e) {
            return UDFunction.createBrokenFunction(name, argNames, argTypes, returnType, calledOnNullInput, language, body, e);
        }
    }

    public static UDFunction create(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) {
        UDFunction.assertUdfsEnabled(language);
        return new JavaBasedUDFunction(name, argNames, argTypes, returnType, calledOnNullInput, body);
    }

    public static UDFunction createBrokenFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body, final InvalidRequestException reason) {
        return new UDFunction(name, argNames, argTypes, returnType, calledOnNullInput, language, body){

            @Override
            protected ExecutorService executor() {
                return ImmediateExecutor.INSTANCE;
            }

            @Override
            protected Object executeAggregateUserDefined(Object firstParam, Arguments arguments) {
                throw this.broken();
            }

            @Override
            public ByteBuffer executeUserDefined(Arguments arguments) {
                throw this.broken();
            }

            private InvalidRequestException broken() {
                return new InvalidRequestException(String.format("Function '%s' exists but hasn't been loaded successfully for the following reason: %s. Please see the server log for details", this, reason.getMessage()));
            }
        };
    }

    @Override
    public SchemaElement.SchemaElementType elementType() {
        return SchemaElement.SchemaElementType.FUNCTION;
    }

    @Override
    public String toCqlString(boolean withInternals, boolean ifNotExists) {
        CqlBuilder builder = new CqlBuilder();
        builder.append("CREATE FUNCTION ");
        if (ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.name()).append("(");
        int m = this.argNames().size();
        for (int i = 0; i < m; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.argNames().get(i)).append(' ').append(this.toCqlString(this.argTypes().get(i)));
        }
        builder.append(')').newLine().increaseIndent().append(this.isCalledOnNullInput() ? "CALLED" : "RETURNS NULL").append(" ON NULL INPUT").newLine().append("RETURNS ").append(this.toCqlString(this.returnType())).newLine().append("LANGUAGE ").append(this.language()).newLine().append("AS $$").append(this.body()).append("$$;");
        return builder.toString();
    }

    @Override
    public boolean isPure() {
        return false;
    }

    @Override
    public final ByteBuffer execute(Arguments arguments) {
        UDFunction.assertUdfsEnabled(this.language);
        if (!this.isCallableWrtNullable(arguments)) {
            return null;
        }
        long tStart = Clock.Global.nanoTime();
        try {
            ByteBuffer result = DatabaseDescriptor.enableUserDefinedFunctionsThreads() ? this.executeAsync(arguments) : this.executeUserDefined(arguments);
            Tracing.trace("Executed UDF {} in {}\u03bcs", (Object)this.name(), (Object)((Clock.Global.nanoTime() - tStart) / 1000L));
            return result;
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.trace("Invocation of user-defined function '{}' failed", (Object)this, (Object)t);
            if (t instanceof VirtualMachineError) {
                throw (VirtualMachineError)t;
            }
            throw FunctionExecutionException.create(this, t);
        }
    }

    public final Object executeForAggregate(Object state, Arguments arguments) {
        UDFunction.assertUdfsEnabled(this.language);
        if (!this.calledOnNullInput && state == null || !this.isCallableWrtNullable(arguments)) {
            return null;
        }
        long tStart = Clock.Global.nanoTime();
        try {
            Object result = DatabaseDescriptor.enableUserDefinedFunctionsThreads() ? this.executeAggregateAsync(state, arguments) : this.executeAggregateUserDefined(state, arguments);
            Tracing.trace("Executed UDF {} in {}\u03bcs", (Object)this.name(), (Object)((Clock.Global.nanoTime() - tStart) / 1000L));
            return result;
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.debug("Invocation of user-defined function '{}' failed", (Object)this, (Object)t);
            if (t instanceof VirtualMachineError) {
                throw (VirtualMachineError)t;
            }
            throw FunctionExecutionException.create(this, t);
        }
    }

    public static void assertUdfsEnabled(String language) {
        if (!DatabaseDescriptor.enableUserDefinedFunctions()) {
            throw new InvalidRequestException("User-defined functions are disabled in cassandra.yaml - set user_defined_functions_enabled=true to enable");
        }
        if (!"java".equalsIgnoreCase(language)) {
            throw new InvalidRequestException("Currently only Java UDFs are available in Cassandra. For more information - CASSANDRA-18252 and CASSANDRA-17281");
        }
    }

    static void initializeThread() {
        TypeCodec.inet().format(InetAddress.getLoopbackAddress());
        TypeCodec.ascii().format("");
    }

    private ByteBuffer executeAsync(Arguments arguments) {
        ThreadIdAndCpuTime threadIdAndCpuTime = new ThreadIdAndCpuTime();
        return this.async(threadIdAndCpuTime, () -> {
            threadIdAndCpuTime.setup();
            return this.executeUserDefined(arguments);
        });
    }

    private Object executeAggregateAsync(Object state, Arguments arguments) {
        ThreadIdAndCpuTime threadIdAndCpuTime = new ThreadIdAndCpuTime();
        return this.async(threadIdAndCpuTime, () -> {
            threadIdAndCpuTime.setup();
            return this.executeAggregateUserDefined(state, arguments);
        });
    }

    private <T> T async(ThreadIdAndCpuTime threadIdAndCpuTime, Callable<T> callable) {
        Future<T> future = this.executor().submit(callable);
        try {
            if (DatabaseDescriptor.getUserDefinedFunctionWarnTimeout() > 0L) {
                try {
                    return future.get(DatabaseDescriptor.getUserDefinedFunctionWarnTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    String warn = String.format("User defined function %s ran longer than %dms", this, DatabaseDescriptor.getUserDefinedFunctionWarnTimeout());
                    logger.warn(warn);
                    ClientWarn.instance.warn(warn);
                }
            }
            return future.get(DatabaseDescriptor.getUserDefinedFunctionFailTimeout() - DatabaseDescriptor.getUserDefinedFunctionWarnTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof RuntimeException) {
                throw (RuntimeException)c;
            }
            throw new RuntimeException(c);
        }
        catch (TimeoutException e) {
            try {
                threadIdAndCpuTime.get(1L, TimeUnit.SECONDS);
                long cpuTimeMillis = threadMXBean.getThreadCpuTime(threadIdAndCpuTime.threadId) - threadIdAndCpuTime.cpuTime;
                return future.get(Math.max(DatabaseDescriptor.getUserDefinedFunctionFailTimeout() - (cpuTimeMillis /= 1000000L), 0L), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new UncheckedInterruptedException(e1);
            }
            catch (ExecutionException e1) {
                Throwable c = e.getCause();
                if (c instanceof RuntimeException) {
                    throw (RuntimeException)c;
                }
                throw new RuntimeException(c);
            }
            catch (TimeoutException e1) {
                TimeoutException cause = new TimeoutException(String.format("User defined function %s ran longer than %dms%s", this, DatabaseDescriptor.getUserDefinedFunctionFailTimeout(), DatabaseDescriptor.getUserFunctionTimeoutPolicy() == Config.UserFunctionTimeoutPolicy.ignore ? "" : " - will stop Cassandra VM"));
                FunctionExecutionException fe = FunctionExecutionException.create(this, cause);
                JVMStabilityInspector.userFunctionTimeout(cause);
                throw fe;
            }
        }
    }

    protected abstract ExecutorService executor();

    public boolean isCallableWrtNullable(Arguments arguments) {
        return this.calledOnNullInput || !arguments.containsNulls();
    }

    protected abstract ByteBuffer executeUserDefined(Arguments var1);

    protected abstract Object executeAggregateUserDefined(Object var1, Arguments var2);

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public List<ColumnIdentifier> argNames() {
        return this.argNames;
    }

    public String body() {
        return this.body;
    }

    public String language() {
        return this.language;
    }

    protected ByteBuffer decompose(ProtocolVersion protocolVersion, Object value) {
        return this.resultType.decompose(protocolVersion, value);
    }

    @Override
    public boolean referencesUserType(ByteBuffer name) {
        return Iterables.any(this.argTypes(), t -> t.referencesUserType(name)) || this.returnType.referencesUserType(name);
    }

    public UDFunction withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        return UDFunction.tryCreate(this.name, this.argNames, Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.argTypes, t -> t.withUpdatedUserType(udt))), this.returnType.withUpdatedUserType(udt), this.calledOnNullInput, this.language, this.body);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDFunction)) {
            return false;
        }
        UDFunction that = (UDFunction)o;
        return this.equalsWithoutTypes(that) && this.argTypes.equals(that.argTypes) && this.returnType.equals(that.returnType);
    }

    private boolean equalsWithoutTypes(UDFunction other) {
        return this.name.equals(other.name) && this.argTypes.size() == other.argTypes.size() && this.argNames.equals(other.argNames) && this.body.equals(other.body) && this.language.equals(other.language) && this.calledOnNullInput == other.calledOnNullInput;
    }

    @Override
    public Optional<Difference> compare(Function function) {
        if (!(function instanceof UDFunction)) {
            throw new IllegalArgumentException();
        }
        UDFunction other = (UDFunction)function;
        if (!this.equalsWithoutTypes(other)) {
            return Optional.of(Difference.SHALLOW);
        }
        boolean typesDifferDeeply = false;
        if (!this.returnType.equals(other.returnType)) {
            if (this.returnType.asCQL3Type().toString().equals(other.returnType.asCQL3Type().toString())) {
                typesDifferDeeply = true;
            } else {
                return Optional.of(Difference.SHALLOW);
            }
        }
        for (int i = 0; i < this.argTypes().size(); ++i) {
            AbstractType thatType;
            AbstractType thisType = (AbstractType)this.argTypes.get(i);
            if (thisType.equals(thatType = (AbstractType)other.argTypes.get(i))) continue;
            if (thisType.asCQL3Type().toString().equals(thatType.asCQL3Type().toString())) {
                typesDifferDeeply = true;
                continue;
            }
            return Optional.of(Difference.SHALLOW);
        }
        return typesDifferDeeply ? Optional.of(Difference.DEEP) : Optional.empty();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, UserFunctions.typeHashCode(this.argTypes), this.returnType, this.language, this.body});
    }

    private static class UDFClassLoader
    extends ClassLoader {
        static final ClassLoader insecureClassLoader = UDFClassLoader.class.getClassLoader();

        private UDFClassLoader() {
            super(insecureClassLoader);
        }

        @Override
        public URL getResource(String name) {
            if (!UDFunction.secureResource(name)) {
                return null;
            }
            return insecureClassLoader.getResource(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (!UDFunction.secureResource(name.replace('.', '/') + ".class")) {
                throw new ClassNotFoundException(name);
            }
            return insecureClassLoader.loadClass(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (!UDFunction.secureResource(name.replace('.', '/') + ".class")) {
                throw new ClassNotFoundException(name);
            }
            return super.loadClass(name);
        }
    }

    private static final class ThreadIdAndCpuTime
    extends CompletableFuture<Object> {
        long threadId;
        long cpuTime;

        ThreadIdAndCpuTime() {
            threadMXBean.getCurrentThreadCpuTime();
        }

        void setup() {
            this.threadId = Thread.currentThread().getId();
            this.cpuTime = threadMXBean.getCurrentThreadCpuTime();
            this.complete(null);
        }
    }
}

