/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.agrona.collections.IntArrayList;
import org.apache.cassandra.index.sai.disk.v1.vector.RamAwareVectorValues;
import org.apache.cassandra.index.sai.disk.v1.vector.VectorPostings;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.Pair;

public class VectorPostingsWriter<T> {
    public long writePostings(SequentialWriter writer, RamAwareVectorValues vectorValues, Map<float[], VectorPostings<T>> postingsMap, Set<Integer> deletedOrdinals) throws IOException {
        this.writeDeletedOrdinals(writer, deletedOrdinals);
        this.writeNodeOrdinalToRowIdMapping(writer, vectorValues, postingsMap);
        this.writeRowIdToNodeOrdinalMapping(writer, vectorValues, postingsMap);
        return writer.position();
    }

    private void writeDeletedOrdinals(SequentialWriter writer, Set<Integer> deletedOrdinals) throws IOException {
        writer.writeInt(deletedOrdinals.size());
        for (Integer ordinal : deletedOrdinals) {
            writer.writeInt(ordinal);
        }
    }

    public void writeNodeOrdinalToRowIdMapping(SequentialWriter writer, RamAwareVectorValues vectorValues, Map<float[], VectorPostings<T>> postingsMap) throws IOException {
        int i;
        long offsetsStartAt;
        long ordToRowOffset = writer.getOnDiskFilePointer();
        writer.writeInt(vectorValues.size());
        long nextOffset = offsetsStartAt = ordToRowOffset + 4L + 8L * (long)vectorValues.size();
        for (i = 0; i < vectorValues.size(); ++i) {
            writer.writeLong(nextOffset);
            IntArrayList rowIds = postingsMap.get(vectorValues.vectorValue(i)).getRowIds();
            nextOffset += 4L + (long)rowIds.size() * 4L;
        }
        assert (writer.position() == offsetsStartAt) : "writer.position()=" + writer.position() + " offsetsStartAt=" + offsetsStartAt;
        for (i = 0; i < vectorValues.size(); ++i) {
            VectorPostings<T> postings = postingsMap.get(vectorValues.vectorValue(i));
            IntArrayList rowIds = postings.getRowIds();
            writer.writeInt(rowIds.size());
            for (int r = 0; r < rowIds.size(); ++r) {
                writer.writeInt(rowIds.getInt(r));
            }
        }
        assert (writer.position() == nextOffset);
    }

    public void writeRowIdToNodeOrdinalMapping(SequentialWriter writer, RamAwareVectorValues vectorValues, Map<float[], VectorPostings<T>> postingsMap) throws IOException {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (int i = 0; i < vectorValues.size(); ++i) {
            IntArrayList rowIds = postingsMap.get(vectorValues.vectorValue(i)).getRowIds();
            for (int r = 0; r < rowIds.size(); ++r) {
                pairs.add(Pair.create(rowIds.getInt(r), i));
            }
        }
        pairs.sort(Comparator.comparingInt(Pair::left));
        long startOffset = writer.position();
        for (Pair pair : pairs) {
            writer.writeInt((Integer)pair.left);
            writer.writeInt((Integer)pair.right);
        }
        writer.writeLong(startOffset);
    }
}

