/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.MessageParams;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.VectorQueryContext;
import org.apache.cassandra.index.sai.disk.IndexSearchResultIterator;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeConcatIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIntersectionIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeOrderingIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.QueryReferencingTooManyIndexesException;
import org.apache.cassandra.index.sai.plan.QueryViewBuilder;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;

public class QueryController {
    final QueryContext queryContext;
    private final ColumnFamilyStore cfs;
    private final ReadCommand command;
    private final RowFilter indexFilter;
    private final List<DataRange> ranges;
    private final AbstractBounds<PartitionPosition> mergeRange;
    private final PrimaryKey.Factory keyFactory;
    private final PrimaryKey firstPrimaryKey;
    private final PrimaryKey lastPrimaryKey;
    private final int orderChunkSize;

    public QueryController(ColumnFamilyStore cfs, ReadCommand command, RowFilter indexFilter, QueryContext queryContext) {
        this.cfs = cfs;
        this.command = command;
        this.queryContext = queryContext;
        this.indexFilter = indexFilter;
        this.ranges = QueryController.dataRanges(command);
        DataRange first = this.ranges.get(0);
        DataRange last = this.ranges.get(this.ranges.size() - 1);
        this.mergeRange = this.ranges.size() == 1 ? first.keyRange() : first.keyRange().withNewRight((PartitionPosition)last.keyRange().right);
        this.keyFactory = new PrimaryKey.Factory(cfs.getPartitioner(), cfs.getComparator());
        this.firstPrimaryKey = this.keyFactory.create(((PartitionPosition)this.mergeRange.left).getToken());
        this.lastPrimaryKey = this.keyFactory.create(((PartitionPosition)this.mergeRange.right).getToken());
        this.orderChunkSize = CassandraRelevantProperties.SAI_VECTOR_SEARCH_ORDER_CHUNK_SIZE.getInt();
    }

    public PrimaryKey.Factory primaryKeyFactory() {
        return this.keyFactory;
    }

    public PrimaryKey firstPrimaryKeyInRange() {
        return this.firstPrimaryKey;
    }

    public PrimaryKey lastPrimaryKeyInRange() {
        return this.lastPrimaryKey;
    }

    public TableMetadata metadata() {
        return this.command.metadata();
    }

    public RowFilter indexFilter() {
        return this.indexFilter;
    }

    public boolean usesStrictFiltering() {
        return this.command.rowFilter().isStrict();
    }

    public List<DataRange> dataRanges() {
        return this.ranges;
    }

    @Nullable
    public StorageAttachedIndex indexFor(RowFilter.Expression expression) {
        return this.cfs.indexManager.getBestIndexFor(expression, StorageAttachedIndex.class).orElse(null);
    }

    public boolean hasAnalyzer(RowFilter.Expression expression) {
        StorageAttachedIndex index = this.indexFor(expression);
        return index != null && index.hasAnalyzer();
    }

    public UnfilteredRowIterator queryStorage(PrimaryKey key, ReadExecutionController executionController) {
        if (key == null) {
            throw new IllegalArgumentException("non-null key required");
        }
        SinglePartitionReadCommand partition = SinglePartitionReadCommand.create(this.cfs.metadata(), this.command.nowInSec(), this.command.columnFilter(), RowFilter.none(), DataLimits.NONE, key.partitionKey(), this.makeFilter(key));
        return partition.queryMemtableAndDisk(this.cfs, executionController);
    }

    public KeyRangeIterator.Builder getIndexQueryResults(Collection<Expression> expressions) {
        expressions = expressions.stream().filter(e -> e.getIndexOperator() != Expression.IndexOperator.ANN).collect(Collectors.toList());
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(expressions, this.mergeRange).build();
        Runnable onClose = () -> queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
        KeyRangeIterator.Builder builder = this.command.rowFilter().isStrict() ? KeyRangeIntersectionIterator.builder(expressions.size(), onClose) : KeyRangeUnionIterator.builder(expressions.size(), onClose);
        try {
            this.maybeTriggerGuardrails(queryView);
            if (this.command.rowFilter().isStrict()) {
                for (Pair<Expression, Collection<SSTableIndex>> queryViewPair : queryView.view) {
                    builder.add(IndexSearchResultIterator.build((Expression)queryViewPair.left, (Collection)queryViewPair.right, this.mergeRange, this.queryContext, true, () -> {}));
                }
            } else {
                KeyRangeIntersectionIterator.Builder repairedBuilder = KeyRangeIntersectionIterator.builder(expressions.size(), () -> {});
                for (Pair<Expression, Collection<SSTableIndex>> queryViewPair : queryView.view) {
                    ArrayList<SSTableIndex> repaired = new ArrayList<SSTableIndex>(5);
                    ArrayList<SSTableIndex> unrepaired = new ArrayList<SSTableIndex>(5);
                    for (SSTableIndex index : (Collection)queryViewPair.right) {
                        if (index.getSSTable().isRepaired()) {
                            repaired.add(index);
                            continue;
                        }
                        unrepaired.add(index);
                    }
                    IndexSearchResultIterator unrepairedIterator = IndexSearchResultIterator.build((Expression)queryViewPair.left, unrepaired, this.mergeRange, this.queryContext, true, () -> {});
                    if (unrepairedIterator.getMaxKeys() > 0L) {
                        builder.add(unrepairedIterator);
                        this.queryContext.hasUnrepairedMatches = true;
                    } else {
                        unrepairedIterator.close();
                    }
                    if (repaired.isEmpty()) continue;
                    ((KeyRangeIterator.Builder)repairedBuilder).add(IndexSearchResultIterator.build((Expression)queryViewPair.left, repaired, this.mergeRange, this.queryContext, false, () -> {}));
                }
                if (((KeyRangeIterator.Builder)repairedBuilder).rangeCount() > 0) {
                    builder.add(repairedBuilder.build());
                }
            }
        }
        catch (Throwable t) {
            builder.cleanup();
            throw t;
        }
        return builder;
    }

    private void maybeTriggerGuardrails(QueryViewBuilder.QueryView queryView) {
        int referencedIndexes = queryView.referencedIndexes.size();
        if (Guardrails.saiSSTableIndexesPerQuery.failsOn(referencedIndexes, null)) {
            String msg = String.format("Query %s attempted to read from too many indexes (%s) but max allowed is %s; query aborted (see sai_sstable_indexes_per_query_fail_threshold)", this.command.toCQLString(), referencedIndexes, Guardrails.CONFIG_PROVIDER.getOrCreate(null).getSaiSSTableIndexesPerQueryFailThreshold());
            Tracing.trace(msg);
            MessageParams.add(ParamType.TOO_MANY_REFERENCED_INDEXES_FAIL, referencedIndexes);
            throw new QueryReferencingTooManyIndexesException(msg);
        }
        if (Guardrails.saiSSTableIndexesPerQuery.warnsOn(referencedIndexes, null)) {
            MessageParams.add(ParamType.TOO_MANY_REFERENCED_INDEXES_WARN, referencedIndexes);
        }
    }

    public boolean doesNotSelect(PrimaryKey key) {
        return key.kind() == PrimaryKey.Kind.WIDE && !this.command.clusteringIndexFilter(key.partitionKey()).selects(key.clustering());
    }

    public KeyRangeIterator getTopKRows(RowFilter.Expression expression) {
        assert (expression.operator() == Operator.ANN);
        StorageAttachedIndex index = this.indexFor(expression);
        assert (index != null);
        Expression planExpression = Expression.create(index).add(Operator.ANN, expression.getIndexValue().duplicate());
        KeyRangeIterator memtableResults = index.memtableIndexManager().searchMemtableIndexes(this.queryContext, planExpression, this.mergeRange);
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(Collections.singleton(planExpression), this.mergeRange).build();
        Runnable onClose = () -> queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
        try {
            List<KeyRangeIterator> sstableIntersections = queryView.view.stream().map(this::createRowIdIterator).collect(Collectors.toList());
            return IndexSearchResultIterator.build(sstableIntersections, memtableResults, queryView.referencedIndexes, this.queryContext, onClose);
        }
        catch (Throwable t) {
            onClose.run();
            throw t;
        }
    }

    public KeyRangeIterator getTopKRows(KeyRangeIterator source, RowFilter.Expression expression) {
        return new KeyRangeOrderingIterator(source, this.orderChunkSize, list -> this.getTopKRows((List<PrimaryKey>)list, expression));
    }

    private KeyRangeIterator getTopKRows(List<PrimaryKey> rawSourceKeys, RowFilter.Expression expression) {
        VectorQueryContext vectorQueryContext = this.queryContext.vectorContext();
        List<PrimaryKey> sourceKeys = rawSourceKeys.stream().filter(vectorQueryContext::shouldInclude).collect(Collectors.toList());
        StorageAttachedIndex index = this.indexFor(expression);
        assert (index != null) : "Cannot do ANN ordering on an unindexed column";
        Expression planExpression = Expression.create(index);
        planExpression.add(Operator.ANN, expression.getIndexValue().duplicate());
        KeyRangeIterator memtableResults = index.memtableIndexManager().limitToTopResults(this.queryContext, sourceKeys, planExpression);
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(Collections.singleton(planExpression), this.mergeRange).build();
        Runnable onClose = () -> queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
        try {
            List<KeyRangeIterator> sstableIntersections = queryView.view.stream().flatMap(pair -> ((Collection)pair.right).stream()).map(idx -> {
                try {
                    return idx.limitToTopKResults(this.queryContext, sourceKeys, planExpression);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).collect(Collectors.toList());
            return IndexSearchResultIterator.build(sstableIntersections, memtableResults, queryView.referencedIndexes, this.queryContext, onClose);
        }
        catch (Throwable t) {
            onClose.run();
            throw t;
        }
    }

    private KeyRangeIterator createRowIdIterator(Pair<Expression, Collection<SSTableIndex>> indexExpression) {
        List<KeyRangeIterator> subIterators = ((Collection)indexExpression.right).stream().map(index -> {
            try {
                List<KeyRangeIterator> iterators = index.search((Expression)indexExpression.left, this.mergeRange, this.queryContext);
                return KeyRangeConcatIterator.builder(iterators.size()).add(iterators).build();
            }
            catch (Throwable ex) {
                throw Throwables.cleaned(ex);
            }
        }).collect(Collectors.toList());
        return KeyRangeUnionIterator.build(subIterators);
    }

    private ClusteringIndexFilter makeFilter(PrimaryKey key) {
        ClusteringIndexFilter clusteringIndexFilter = this.command.clusteringIndexFilter(key.partitionKey());
        assert (this.cfs.metadata().comparator.size() == 0 && !key.kind().hasClustering || this.cfs.metadata().comparator.size() > 0 && key.kind().hasClustering) : "PrimaryKey " + key + " clustering does not match table. There should be a clustering of size " + this.cfs.metadata().comparator.size();
        if (this.cfs.metadata().comparator.size() == 0 || key.kind() == PrimaryKey.Kind.STATIC) {
            return clusteringIndexFilter;
        }
        return new ClusteringIndexNamesFilter(FBUtilities.singleton(key.clustering(), this.cfs.metadata().comparator), clusteringIndexFilter.isReversed());
    }

    private static List<DataRange> dataRanges(ReadCommand command) {
        if (command instanceof SinglePartitionReadCommand) {
            return Lists.newArrayList((Object[])new DataRange[]{command.dataRange()});
        }
        if (command instanceof PartitionRangeReadCommand) {
            return Lists.newArrayList((Object[])new DataRange[]{command.dataRange()});
        }
        throw new AssertionError((Object)("Unsupported read command type: " + command.getClass().getName()));
    }
}

