/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.cql3.functions.types.DataType;

public class VectorType
extends DataType {
    private final DataType subtype;
    private final int dimensions;

    VectorType(DataType subtype, int dimensions) {
        super(DataType.Name.VECTOR);
        assert (dimensions > 0) : "vectors may only have positive dimensions; given " + dimensions;
        this.subtype = subtype;
        this.dimensions = dimensions;
    }

    public DataType getSubtype() {
        return this.subtype;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public List<DataType> getTypeArguments() {
        return Arrays.asList(this.subtype, DataType.cint());
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorType that = (VectorType)o;
        if (this.dimensions != that.dimensions) {
            return false;
        }
        if (!this.subtype.equals(that.subtype)) {
            return false;
        }
        return this.name == that.name;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.dimensions;
        result = 31 * result + this.subtype.hashCode();
        return result;
    }

    public String toString() {
        return String.format("vector<%s, %d>", this.subtype, this.dimensions);
    }
}

