/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.postings;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.segment.IndexSegmentSearcherContext;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PostingListRangeIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(PostingListRangeIterator.class);
    private final Stopwatch timeToExhaust = Stopwatch.createStarted();
    private final QueryContext queryContext;
    private final PostingList postingList;
    private final IndexIdentifier indexIdentifier;
    private final PrimaryKeyMap primaryKeyMap;
    private final long rowIdOffset;
    private boolean needsSkipping = false;
    private PrimaryKey skipToKey = null;

    public PostingListRangeIterator(IndexIdentifier indexIdentifier, PrimaryKeyMap primaryKeyMap, IndexSegmentSearcherContext searcherContext) {
        super(searcherContext.minimumKey, searcherContext.maximumKey, searcherContext.count(), () -> {});
        this.indexIdentifier = indexIdentifier;
        this.primaryKeyMap = primaryKeyMap;
        this.postingList = searcherContext.postingList;
        this.rowIdOffset = searcherContext.segmentRowIdOffset;
        this.queryContext = searcherContext.context;
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        if (this.skipToKey != null && this.skipToKey.compareTo(nextKey) > 0) {
            return;
        }
        this.skipToKey = nextKey;
        this.needsSkipping = true;
    }

    @Override
    protected PrimaryKey computeNext() {
        try {
            this.queryContext.checkpoint();
            if (this.exhausted()) {
                return (PrimaryKey)this.endOfData();
            }
            long rowId = this.getNextRowId();
            if (rowId == Long.MAX_VALUE) {
                return (PrimaryKey)this.endOfData();
            }
            return this.primaryKeyMap.primaryKeyFromRowId(rowId);
        }
        catch (Throwable t) {
            if (!(t instanceof QueryCancelledException)) {
                logger.error(this.indexIdentifier.logMessage("Unable to provide next token!"), t);
            }
            FileUtils.closeQuietly(Arrays.asList(this.postingList, this.primaryKeyMap));
            throw Throwables.cleaned(t);
        }
    }

    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            long exhaustedInMills = this.timeToExhaust.stop().elapsed(TimeUnit.MILLISECONDS);
            logger.trace(this.indexIdentifier.logMessage("PostingListRangeIterator exhausted after {} ms"), (Object)exhaustedInMills);
        }
        FileUtils.closeQuietly(Arrays.asList(this.postingList, this.primaryKeyMap));
    }

    private boolean exhausted() {
        return this.needsSkipping && this.skipToKey.compareTo(this.getMaximum()) > 0;
    }

    private long getNextRowId() throws IOException {
        long segmentRowId;
        if (this.needsSkipping) {
            long targetRowID = this.primaryKeyMap.rowIdFromPrimaryKey(this.skipToKey);
            if (targetRowID < 0L) {
                return Long.MAX_VALUE;
            }
            segmentRowId = this.postingList.advance(targetRowID - this.rowIdOffset);
            this.needsSkipping = false;
        } else {
            segmentRowId = this.postingList.nextPosting();
        }
        return segmentRowId != Long.MAX_VALUE ? segmentRowId + this.rowIdOffset : Long.MAX_VALUE;
    }
}

