/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.FilterTree;
import org.apache.cassandra.index.sai.plan.QueryController;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.schema.ColumnMetadata;

public class Operation {
    @VisibleForTesting
    protected static ListMultimap<ColumnMetadata, Expression> buildIndexExpressions(QueryController queryController, List<RowFilter.Expression> expressions) {
        ArrayListMultimap analyzed = ArrayListMultimap.create();
        expressions.sort((a, b) -> {
            int cmp = a.column().compareTo(b.column());
            return cmp == 0 ? -Integer.compare(Operation.getPriority(a.operator()), Operation.getPriority(b.operator())) : cmp;
        });
        for (RowFilter.Expression expression : expressions) {
            if (!Expression.supportsOperator(expression.operator())) continue;
            StorageAttachedIndex index = queryController.indexFor(expression);
            List perColumn = analyzed.get((Object)expression.column());
            if (index == null) {
                Operation.buildUnindexedExpression(queryController, expression, perColumn);
                continue;
            }
            Operation.buildIndexedExpression(index, expression, perColumn);
        }
        return analyzed;
    }

    private static void buildUnindexedExpression(QueryController queryController, RowFilter.Expression expression, List<Expression> perColumn) {
        IndexTermType indexTermType = IndexTermType.create(expression.column(), queryController.metadata().partitionKeyColumns(), Operation.determineIndexTargetType(expression));
        if (indexTermType.isMultiExpression(expression)) {
            perColumn.add(Expression.create(indexTermType).add(expression.operator(), expression.getIndexValue().duplicate()));
        } else {
            Expression range;
            if (perColumn.size() == 0) {
                range = Expression.create(indexTermType);
                perColumn.add(range);
            } else {
                range = (Expression)Iterables.getLast(perColumn);
            }
            range.add(expression.operator(), expression.getIndexValue().duplicate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildIndexedExpression(StorageAttachedIndex index, RowFilter.Expression expression, List<Expression> perColumn) {
        if (index.hasAnalyzer()) {
            AbstractAnalyzer analyzer = index.analyzer();
            try {
                Expression range;
                analyzer.reset(expression.getIndexValue().duplicate());
                if (index.termType().isMultiExpression(expression)) {
                    while (analyzer.hasNext()) {
                        ByteBuffer token = analyzer.next();
                        perColumn.add(Expression.create(index).add(expression.operator(), token.duplicate()));
                    }
                }
                if (perColumn.size() == 0) {
                    range = Expression.create(index);
                    perColumn.add(range);
                } else {
                    range = (Expression)Iterables.getLast(perColumn);
                }
                if (index.termType().isLiteral()) {
                    while (analyzer.hasNext()) {
                        ByteBuffer term = analyzer.next();
                        range.add(expression.operator(), term.duplicate());
                    }
                }
                range.add(expression.operator(), expression.getIndexValue().duplicate());
            }
            finally {
                analyzer.end();
            }
        } else if (index.termType().isMultiExpression(expression)) {
            perColumn.add(Expression.create(index).add(expression.operator(), expression.getIndexValue().duplicate()));
        } else {
            Expression range;
            if (perColumn.size() == 0) {
                range = Expression.create(index);
                perColumn.add(range);
            } else {
                range = (Expression)Iterables.getLast(perColumn);
            }
            range.add(expression.operator(), expression.getIndexValue().duplicate());
        }
    }

    private static IndexTarget.Type determineIndexTargetType(RowFilter.Expression expression) {
        AbstractType type = expression.column().type;
        IndexTarget.Type indexTargetType = IndexTarget.Type.SIMPLE;
        if (type.isCollection() && type.isMultiCell()) {
            CollectionType collection = (CollectionType)type;
            if (collection.kind == CollectionType.Kind.MAP) {
                switch (expression.operator()) {
                    case EQ: {
                        indexTargetType = IndexTarget.Type.KEYS_AND_VALUES;
                        break;
                    }
                    case CONTAINS: {
                        indexTargetType = IndexTarget.Type.VALUES;
                        break;
                    }
                    case CONTAINS_KEY: {
                        indexTargetType = IndexTarget.Type.KEYS;
                        break;
                    }
                    default: {
                        throw new InvalidRequestException("Invalid operator");
                    }
                }
            }
        }
        return indexTargetType;
    }

    private static int getPriority(Operator op) {
        switch (op) {
            case EQ: 
            case CONTAINS: 
            case CONTAINS_KEY: {
                return 5;
            }
            case GTE: 
            case GT: {
                return 3;
            }
            case LTE: 
            case LT: {
                return 2;
            }
        }
        return 0;
    }

    static KeyRangeIterator buildIterator(QueryController controller) {
        List orderings = controller.indexFilter().getExpressions().stream().filter(e -> e.operator() == Operator.ANN).collect(Collectors.toList());
        assert (orderings.size() <= 1);
        if (controller.indexFilter().getExpressions().size() == 1 && orderings.size() == 1) {
            return controller.getTopKRows((RowFilter.Expression)orderings.get(0));
        }
        KeyRangeIterator iterator = Node.buildTree(controller.indexFilter()).analyzeTree(controller).rangeIterator(controller);
        if (orderings.isEmpty()) {
            return iterator;
        }
        return controller.getTopKRows(iterator, (RowFilter.Expression)orderings.get(0));
    }

    static FilterTree buildFilter(QueryController controller, boolean strict) {
        return Node.buildTree(controller.indexFilter()).buildFilter(controller, strict);
    }

    static class ExpressionNode
    extends Node {
        final RowFilter.Expression expression;

        @Override
        public void analyze(List<RowFilter.Expression> expressionList, QueryController controller) {
            this.expressionMap = Operation.buildIndexExpressions(controller, expressionList);
            assert (this.expressionMap.size() == 1) : "Expression nodes should only have a single expression!";
        }

        @Override
        FilterTree filterTree(boolean isStrict, QueryContext context) {
            return new FilterTree(BooleanOperator.AND, (ListMultimap<ColumnMetadata, Expression>)this.expressionMap, isStrict, context);
        }

        public ExpressionNode(RowFilter.Expression expression) {
            this.expression = expression;
        }

        @Override
        public RowFilter.Expression expression() {
            return this.expression;
        }

        @Override
        KeyRangeIterator rangeIterator(QueryController controller) {
            assert (this.canFilter()) : "Cannot process query with no expressions";
            return controller.getIndexQueryResults(this.expressionMap.values()).build();
        }
    }

    static class AndNode
    extends OperatorNode {
        AndNode() {
        }

        @Override
        public void analyze(List<RowFilter.Expression> expressionList, QueryController controller) {
            this.expressionMap = Operation.buildIndexExpressions(controller, expressionList);
        }

        @Override
        FilterTree filterTree(boolean isStrict, QueryContext context) {
            return new FilterTree(BooleanOperator.AND, (ListMultimap<ColumnMetadata, Expression>)this.expressionMap, isStrict, context);
        }

        @Override
        KeyRangeIterator rangeIterator(QueryController controller) {
            KeyRangeIterator.Builder builder = controller.getIndexQueryResults(this.expressionMap.values());
            for (Node child : this.children) {
                boolean canFilter = child.canFilter();
                if (!canFilter) continue;
                builder.add(child.rangeIterator(controller));
            }
            return builder.build();
        }
    }

    static abstract class OperatorNode
    extends Node {
        final List<Node> children = new ArrayList<Node>();

        OperatorNode() {
        }

        @Override
        public List<Node> children() {
            return this.children;
        }

        @Override
        public void add(Node child) {
            this.children.add(child);
        }
    }

    static abstract class Node {
        ListMultimap<ColumnMetadata, Expression> expressionMap;

        Node() {
        }

        boolean canFilter() {
            return this.expressionMap != null && !this.expressionMap.isEmpty() || !this.children().isEmpty();
        }

        List<Node> children() {
            return Collections.emptyList();
        }

        void add(Node child) {
            throw new UnsupportedOperationException();
        }

        RowFilter.Expression expression() {
            throw new UnsupportedOperationException();
        }

        abstract void analyze(List<RowFilter.Expression> var1, QueryController var2);

        abstract FilterTree filterTree(boolean var1, QueryContext var2);

        abstract KeyRangeIterator rangeIterator(QueryController var1);

        static Node buildTree(RowFilter filterOperation) {
            AndNode node = new AndNode();
            for (RowFilter.Expression expression : filterOperation.getExpressions()) {
                node.add(Node.buildExpression(expression));
            }
            return node;
        }

        static Node buildExpression(RowFilter.Expression expression) {
            return new ExpressionNode(expression);
        }

        Node analyzeTree(QueryController controller) {
            ArrayList<RowFilter.Expression> expressionList = new ArrayList<RowFilter.Expression>();
            this.doTreeAnalysis(this, expressionList, controller);
            if (!expressionList.isEmpty()) {
                this.analyze(expressionList, controller);
            }
            return this;
        }

        void doTreeAnalysis(Node node, List<RowFilter.Expression> expressions, QueryController controller) {
            if (node.children().isEmpty()) {
                expressions.add(node.expression());
            } else {
                ArrayList<RowFilter.Expression> expressionList = new ArrayList<RowFilter.Expression>();
                for (Node child : node.children()) {
                    this.doTreeAnalysis(child, expressionList, controller);
                }
                node.analyze(expressionList, controller);
            }
        }

        FilterTree buildFilter(QueryController controller, boolean isStrict) {
            this.analyzeTree(controller);
            FilterTree tree = this.filterTree(isStrict, controller.queryContext);
            for (Node child : this.children()) {
                if (!child.canFilter()) continue;
                tree.addChild(child.buildFilter(controller, isStrict));
            }
            return tree;
        }
    }

    public static enum BooleanOperator {
        AND((a, b) -> a & b),
        OR((a, b) -> a | b);

        private final BiFunction<Boolean, Boolean, Boolean> func;

        private BooleanOperator(BiFunction<Boolean, Boolean, Boolean> func) {
            this.func = func;
        }

        public boolean apply(boolean a, boolean b) {
            return this.func.apply(a, b);
        }
    }
}

