/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import java.util.StringJoiner;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.utils.Closeable;

public interface IScrubber
extends Closeable {
    public void scrub();

    @Override
    public void close();

    public CompactionInfo.Holder getScrubInfo();

    @VisibleForTesting
    public ScrubResult scrubWithResult();

    public static Options.Builder options() {
        return new Options.Builder();
    }

    public static class Options {
        public final boolean checkData;
        public final boolean reinsertOverflowedTTLRows;
        public final boolean skipCorrupted;

        private Options(boolean checkData, boolean reinsertOverflowedTTLRows, boolean skipCorrupted) {
            this.checkData = checkData;
            this.reinsertOverflowedTTLRows = reinsertOverflowedTTLRows;
            this.skipCorrupted = skipCorrupted;
        }

        public String toString() {
            return new StringJoiner(", ", Options.class.getSimpleName() + "[", "]").add("checkData=" + this.checkData).add("reinsertOverflowedTTLRows=" + this.reinsertOverflowedTTLRows).add("skipCorrupted=" + this.skipCorrupted).toString();
        }

        public static class Builder {
            private boolean checkData = false;
            private boolean reinsertOverflowedTTLRows = false;
            private boolean skipCorrupted = false;

            public Builder checkData() {
                this.checkData = true;
                return this;
            }

            public Builder checkData(boolean checkData) {
                this.checkData = checkData;
                return this;
            }

            public Builder reinsertOverflowedTTLRows() {
                this.reinsertOverflowedTTLRows = true;
                return this;
            }

            public Builder reinsertOverflowedTTLRows(boolean reinsertOverflowedTTLRows) {
                this.reinsertOverflowedTTLRows = reinsertOverflowedTTLRows;
                return this;
            }

            public Builder skipCorrupted() {
                this.skipCorrupted = true;
                return this;
            }

            public Builder skipCorrupted(boolean skipCorrupted) {
                this.skipCorrupted = skipCorrupted;
                return this;
            }

            public Options build() {
                return new Options(this.checkData, this.reinsertOverflowedTTLRows, this.skipCorrupted);
            }
        }
    }

    public static final class ScrubResult {
        public final int goodPartitions;
        public final int badPartitions;
        public final int emptyPartitions;

        public ScrubResult(int goodPartitions, int badPartitions, int emptyPartitions) {
            this.goodPartitions = goodPartitions;
            this.badPartitions = badPartitions;
            this.emptyPartitions = emptyPartitions;
        }
    }
}

