/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.InheritingClass;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.memtable.SkipListMemtableFactory;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.slf4j.LoggerFactory;

public final class MemtableParams {
    private final Memtable.Factory factory;
    private final String configurationKey;
    private static final String DEFAULT_CONFIGURATION_KEY = "default";
    private static final Memtable.Factory DEFAULT_MEMTABLE_FACTORY = SkipListMemtableFactory.INSTANCE;
    private static final ParameterizedClass DEFAULT_CONFIGURATION = SkipListMemtableFactory.CONFIGURATION;
    private static final Map<String, ParameterizedClass> CONFIGURATION_DEFINITIONS = MemtableParams.expandDefinitions(DatabaseDescriptor.getMemtableConfigurations());
    private static final Map<String, MemtableParams> CONFIGURATIONS = new HashMap<String, MemtableParams>();
    public static final MemtableParams DEFAULT = MemtableParams.get(null);

    private MemtableParams(Memtable.Factory factory, String configurationKey) {
        this.configurationKey = configurationKey;
        this.factory = factory;
    }

    public String configurationKey() {
        return this.configurationKey;
    }

    public Memtable.Factory factory() {
        return this.factory;
    }

    public String toString() {
        return this.configurationKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemtableParams)) {
            return false;
        }
        MemtableParams c = (MemtableParams)o;
        return Objects.equal((Object)this.configurationKey, (Object)c.configurationKey);
    }

    public int hashCode() {
        return this.configurationKey.hashCode();
    }

    public static Set<String> knownDefinitions() {
        return CONFIGURATION_DEFINITIONS.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemtableParams get(String key) {
        if (key == null) {
            key = DEFAULT_CONFIGURATION_KEY;
        }
        Map<String, MemtableParams> map = CONFIGURATIONS;
        synchronized (map) {
            return CONFIGURATIONS.computeIfAbsent(key, MemtableParams::parseConfiguration);
        }
    }

    public static MemtableParams getWithFallback(String key) {
        try {
            return MemtableParams.get(key);
        }
        catch (ConfigurationException e) {
            LoggerFactory.getLogger(MemtableParams.class).error("Invalid memtable configuration \"" + key + "\" in schema. Falling back to default to avoid schema mismatch.\nPlease ensure the correct definition is given in cassandra.yaml.", (Throwable)e);
            return new MemtableParams(DEFAULT.factory(), key);
        }
    }

    @VisibleForTesting
    static Map<String, ParameterizedClass> expandDefinitions(Map<String, InheritingClass> memtableConfigurations) {
        if (memtableConfigurations == null) {
            return ImmutableMap.of((Object)DEFAULT_CONFIGURATION_KEY, (Object)DEFAULT_CONFIGURATION);
        }
        LinkedHashMap<String, ParameterizedClass> configs = new LinkedHashMap<String, ParameterizedClass>(memtableConfigurations.size() + 1);
        if (!memtableConfigurations.containsKey(DEFAULT_CONFIGURATION_KEY)) {
            configs.put(DEFAULT_CONFIGURATION_KEY, DEFAULT_CONFIGURATION);
        }
        LinkedHashMap<String, InheritingClass> inheritingClasses = new LinkedHashMap<String, InheritingClass>();
        for (Map.Entry<String, InheritingClass> entry : memtableConfigurations.entrySet()) {
            if (entry.getValue().inherits != null) {
                if (entry.getKey().equals(entry.getValue().inherits)) {
                    throw new ConfigurationException(String.format("Configuration entry %s can not inherit itself.", entry.getKey()));
                }
                if (memtableConfigurations.get(entry.getValue().inherits) == null && !entry.getValue().inherits.equals(DEFAULT_CONFIGURATION_KEY)) {
                    throw new ConfigurationException(String.format("Configuration entry %s inherits non-existing entry %s.", entry.getKey(), entry.getValue().inherits));
                }
                inheritingClasses.put(entry.getKey(), entry.getValue());
                continue;
            }
            configs.put(entry.getKey(), entry.getValue().resolve(configs));
        }
        for (Map.Entry<String, InheritingClass> entry : inheritingClasses.entrySet()) {
            String inherits = entry.getValue().inherits;
            while (inherits != null) {
                InheritingClass nextInheritance = (InheritingClass)inheritingClasses.get(inherits);
                if ((inherits = nextInheritance == null ? null : nextInheritance.inherits) == null || !inherits.equals(entry.getKey())) continue;
                throw new ConfigurationException(String.format("Detected loop when processing key %s", entry.getKey()));
            }
        }
        while (!inheritingClasses.isEmpty()) {
            HashSet<String> forRemoval = new HashSet<String>();
            for (Map.Entry inheritingEntry : inheritingClasses.entrySet()) {
                if (configs.get(((InheritingClass)inheritingEntry.getValue()).inherits) == null) continue;
                configs.put((String)inheritingEntry.getKey(), ((InheritingClass)inheritingEntry.getValue()).resolve(configs));
                forRemoval.add((String)inheritingEntry.getKey());
            }
            assert (!forRemoval.isEmpty());
            for (String toRemove : forRemoval) {
                inheritingClasses.remove(toRemove);
            }
        }
        return ImmutableMap.copyOf(configs);
    }

    private static MemtableParams parseConfiguration(String configurationKey) {
        ParameterizedClass definition = CONFIGURATION_DEFINITIONS.get(configurationKey);
        if (definition == null) {
            throw new ConfigurationException("Memtable configuration \"" + configurationKey + "\" not found.");
        }
        return new MemtableParams(MemtableParams.getMemtableFactory(definition), configurationKey);
    }

    private static Memtable.Factory getMemtableFactory(ParameterizedClass options) {
        if (options == DEFAULT_CONFIGURATION) {
            return DEFAULT_MEMTABLE_FACTORY;
        }
        Object className = options.class_name;
        if (className == null || ((String)className).isEmpty()) {
            throw new ConfigurationException("The 'class_name' option must be specified.");
        }
        className = ((String)className).contains(".") ? className : "org.apache.cassandra.db.memtable." + (String)className;
        try {
            Memtable.Factory factory;
            Class<?> clazz = Class.forName((String)className);
            HashMap<String, String> parametersCopy = options.parameters != null ? new HashMap<String, String>(options.parameters) : new HashMap();
            try {
                Method factoryMethod = clazz.getDeclaredMethod("factory", Map.class);
                factory = (Memtable.Factory)factoryMethod.invoke(null, parametersCopy);
            }
            catch (NoSuchMethodException e) {
                Field factoryField = clazz.getDeclaredField("FACTORY");
                factory = (Memtable.Factory)factoryField.get(null);
            }
            if (!parametersCopy.isEmpty()) {
                throw new ConfigurationException("Memtable class " + (String)className + " does not accept any futher parameters, but " + parametersCopy + " were given.");
            }
            return factory;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException("Could not create memtable factory for class " + options, e);
        }
    }
}

