// $ANTLR 2.7.7 (20060906): "ACIItem.g" -> "AntlrACIItemParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.api.ldap.aci;


import java.util.List;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Enumeration;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecificationModifier;
import org.apache.directory.api.util.ComponentsMonitor;
import org.apache.directory.api.util.MandatoryAndOptionalComponentsMonitor;
import org.apache.directory.api.util.MandatoryComponentsMonitor;
import org.apache.directory.api.ldap.model.name.DnUtils;
import org.apache.directory.api.util.NoDuplicateKeysMap;
import org.apache.directory.api.util.OptionalComponentsMonitor;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.aci.protectedItem.AllAttributeValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.AttributeTypeItem;
import org.apache.directory.api.ldap.aci.protectedItem.AttributeValueItem;
import org.apache.directory.api.ldap.aci.protectedItem.SelfValueItem;
import org.apache.directory.api.ldap.aci.protectedItem.ClassesItem;
import org.apache.directory.api.ldap.aci.protectedItem.EntryItem;
import org.apache.directory.api.ldap.aci.protectedItem.RangeOfValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxImmSubItem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxValueCountElem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxValueCountItem;
import org.apache.directory.api.ldap.aci.protectedItem.RestrictedByElem;
import org.apache.directory.api.ldap.aci.protectedItem.RestrictedByItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The antlr generated ACIItem parser.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class AntlrACIItemParser extends antlr.LLkParser       implements AntlrACIItemParserTokenTypes
 {

    private static final Logger LOG = LoggerFactory.getLogger( AntlrACIItemParser.class );
    
    NameComponentNormalizer normalizer;
    
    // nonshared global data needed to avoid extensive pass/return stuff
    // these are only used by three first order components
    private String identificationTag;
    private AuthenticationLevel authenticationLevel;
    private Integer aciPrecedence = null;
    
    private boolean isItemFirstACIItem;
    
    // shared global data needed to avoid extensive pass/return stuff
    private Set<ProtectedItem> protectedItems;
    private Map<String, ProtectedItem> protectedItemsMap;
    private Set<UserClass> userClasses;
    private Map<String, UserClass> userClassesMap;
    private Set<ItemPermission> itemPermissions;
    private Integer precedence = null;
    private Set<GrantAndDenial> grantsAndDenials;
    private Set<UserPermission> userPermissions;
    
    /** The SchemaManager */
    private SchemaManager schemaManager;
    
    private Set<Dn> chopBeforeExclusions;
    private Set<Dn> chopAfterExclusions;
    private SubtreeSpecificationModifier ssModifier = null;
    
    private ComponentsMonitor mainACIItemComponentsMonitor;
    private ComponentsMonitor itemPermissionComponentsMonitor;
    private ComponentsMonitor userPermissionComponentsMonitor;
    private ComponentsMonitor subtreeSpecificationComponentsMonitor;
    
    
    /**
     * Creates a (normalizing) subordinate DnParser for parsing Names.
     * This method MUST be called for each instance while we cannot do
     * constructor overloading for this class.
     *
     * @param schemaManager the SchemaManager
     */
    public void init( SchemaManager schemaManager )
    {
        this.schemaManager = schemaManager;
    }

    /**
     * Sets the NameComponentNormalizer for this parser's dnParser.
     *
     * @param normalizer The {@link Normalizer} to use
     */
    public void setNormalizer(NameComponentNormalizer normalizer)
    {
        this.normalizer = normalizer;
    }

    private int token2Integer( Token token ) throws RecognitionException
    {
        int i = 0;
        
        try
        {
            i = Integer.parseInt( token.getText());
        }
        catch ( NumberFormatException e )
        {
            throw new RecognitionException( I18n.err( I18n.ERR_13900_INTEGER_TOKEN_NOT_INTEGER, 
                                            token.getText() ) );
        }
        
        return i;
    }

protected AntlrACIItemParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrACIItemParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemParser(TokenStream lexer) {
  this(lexer,1);
}

public AntlrACIItemParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final  ACIItem  wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		 ACIItem aciItem ;
		
		
		LOG.debug( "entered wrapperEntryPoint()" );
		aciItem = null;
		
		
		{
		_loop3:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop3;
			}
			
		} while (true);
		}
		aciItem=theACIItem();
		{
		_loop5:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop5;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
		return aciItem ;
	}
	
	public final  ACIItem  theACIItem() throws RecognitionException, TokenStreamException {
		 ACIItem aciItem ;
		
		
		LOG.debug( "entered theACIItem()" );
		aciItem = null;
		mainACIItemComponentsMonitor = new MandatoryComponentsMonitor( 
		new String [] { "identificationTag", "precedence", "authenticationLevel", "itemOrUserFirst" } );
		
		
		match(OPEN_CURLY);
		{
		_loop8:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop8;
			}
			
		} while (true);
		}
		mainACIItemComponent();
		{
		_loop10:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop10;
			}
			
		} while (true);
		}
		{
		_loop16:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop13:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop13;
					}
					
				} while (true);
				}
				mainACIItemComponent();
				{
				_loop15:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop15;
					}
					
				} while (true);
				}
			}
			else {
				break _loop16;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		if ( !mainACIItemComponentsMonitor.finalStateValid() )
		{
		throw new RecognitionException( I18n.err(I18n.ERR_07005_MISSING_MANDATORY_ACIITEM,
		mainACIItemComponentsMonitor.getRemainingComponents() ) );
		}
		
		if ( isItemFirstACIItem )
		{
		aciItem = new ItemFirstACIItem(
		identificationTag,
		aciPrecedence,
		authenticationLevel,
		protectedItems,
		itemPermissions );
		}
		else
		{
		aciItem = new UserFirstACIItem(
		identificationTag,
		aciPrecedence,
		authenticationLevel,
		userClasses,
		userPermissions );
		}
		
		return aciItem ;
	}
	
	public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered mainACIItemComponent()" );
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_identificationTag:
			{
				aci_identificationTag();
				
				mainACIItemComponentsMonitor.useComponent( "identificationTag" );
				
				break;
			}
			case ID_precedence:
			{
				aci_precedence();
				
				mainACIItemComponentsMonitor.useComponent( "precedence" );
				
				break;
			}
			case ID_authenticationLevel:
			{
				aci_authenticationLevel();
				
				mainACIItemComponentsMonitor.useComponent( "authenticationLevel" );
				
				break;
			}
			case ID_itemOrUserFirst:
			{
				aci_itemOrUserFirst();
				
				mainACIItemComponentsMonitor.useComponent( "itemOrUserFirst" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		LOG.debug( "entered aci_identificationTag()" );
		
		
		match(ID_identificationTag);
		{
		int _cnt20=0;
		_loop20:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt20>=1 ) { break _loop20; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt20++;
		} while (true);
		}
		token = LT(1);
		match(SAFEUTF8STRING);
		
		identificationTag = token.getText();
		
	}
	
	public final void aci_precedence() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered aci_precedence()" );
		
		
		precedence();
		
		aciPrecedence = Integer.valueOf( precedence );
		precedence = null;
		
	}
	
	public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered aci_authenticationLevel()" );
		
		
		match(ID_authenticationLevel);
		{
		int _cnt27=0;
		_loop27:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt27>=1 ) { break _loop27; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt27++;
		} while (true);
		}
		authenticationLevel();
	}
	
	public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered aci_itemOrUserFirst()" );
		
		
		match(ID_itemOrUserFirst);
		{
		int _cnt31=0;
		_loop31:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt31>=1 ) { break _loop31; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt31++;
		} while (true);
		}
		itemOrUserFirst();
	}
	
	public final void precedence() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		LOG.debug( "entered precedence()" );
		
		
		match(ID_precedence);
		{
		int _cnt24=0;
		_loop24:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt24>=1 ) { break _loop24; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt24++;
		} while (true);
		}
		token = LT(1);
		match(INTEGER);
		
		precedence = Integer.valueOf( token2Integer( token ) );
		
		if ( ( precedence < 0 ) || ( precedence > 255 ) )
		{
		throw new RecognitionException( I18n.err( I18n.ERR_07006_EXPECTING_INTEGER_TOKEN, precedence ) );
		}
		
	}
	
	public final void authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered authenticationLevel()" );
		
		
		switch ( LA(1)) {
		case ID_none:
		{
			match(ID_none);
			
			authenticationLevel = AuthenticationLevel.NONE;
			
			break;
		}
		case ID_simple:
		{
			match(ID_simple);
			
			authenticationLevel = AuthenticationLevel.SIMPLE;
			
			break;
		}
		case ID_strong:
		{
			match(ID_strong);
			
			authenticationLevel = AuthenticationLevel.STRONG;
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered itemOrUserFirst()" );
		
		
		switch ( LA(1)) {
		case ID_itemFirst:
		{
			itemFirst();
			break;
		}
		case ID_userFirst:
		{
			userFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemFirst() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered itemFirst()" );
		
		
		match(ID_itemFirst);
		{
		_loop35:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop35;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop37:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop37;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop39:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop39;
			}
			
		} while (true);
		}
		protectedItems();
		{
		_loop41:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop41;
			}
			
		} while (true);
		}
		match(SEP);
		{
		_loop43:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop43;
			}
			
		} while (true);
		}
		itemPermissions();
		{
		_loop45:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop45;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		isItemFirstACIItem = true;
		
	}
	
	public final void userFirst() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered userFirst()" );
		
		
		match(ID_userFirst);
		{
		_loop48:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop48;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop50:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop50;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop52:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop52;
			}
			
		} while (true);
		}
		userClasses();
		{
		_loop54:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop54;
			}
			
		} while (true);
		}
		match(SEP);
		{
		_loop56:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop56;
			}
			
		} while (true);
		}
		userPermissions();
		{
		_loop58:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop58;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		isItemFirstACIItem = false;
		
	}
	
	public final void protectedItems() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered protectedItems()" );
		protectedItemsMap = new NoDuplicateKeysMap();
		
		
		try {      // for error handling
			match(ID_protectedItems);
			{
			_loop61:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop61;
				}
				
			} while (true);
			}
			match(OPEN_CURLY);
			{
			_loop63:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop63;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case ATTRIBUTE_VALUE_CANDIDATE:
			case RANGE_OF_VALUES_CANDIDATE:
			case ID_entry:
			case ID_allUserAttributeTypes:
			case ID_attributeType:
			case ID_allAttributeValues:
			case ID_allUserAttributeTypesAndValues:
			case ID_selfValue:
			case ID_maxValueCount:
			case ID_maxImmSub:
			case ID_restrictedBy:
			case ID_classes:
			{
				protectedItem();
				{
				_loop66:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop66;
					}
					
				} while (true);
				}
				{
				_loop72:
				do {
					if ((LA(1)==SEP)) {
						match(SEP);
						{
						_loop69:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop69;
							}
							
						} while (true);
						}
						protectedItem();
						{
						_loop71:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop71;
							}
							
						} while (true);
						}
					}
					else {
						break _loop72;
					}
					
				} while (true);
				}
				break;
			}
			case CLOSE_CURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(CLOSE_CURLY);
			
			protectedItems = new HashSet<ProtectedItem>( protectedItemsMap.values() );
			
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( I18n.err( I18n.ERR_07007_DUPLICATED_PROTECTED_ITEM, e.getMessage() ) );
			
		}
	}
	
	public final void itemPermissions() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered itemPermissions()" );
		itemPermissions = new HashSet<ItemPermission>();
		ItemPermission itemPermission = null;
		
		
		match(ID_itemPermissions);
		{
		int _cnt177=0;
		_loop177:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt177>=1 ) { break _loop177; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt177++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop179:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop179;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			itemPermission=itemPermission();
			{
			_loop182:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop182;
				}
				
			} while (true);
			}
			
			itemPermissions.add( itemPermission );
			
			{
			_loop188:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop185:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop185;
						}
						
					} while (true);
					}
					itemPermission=itemPermission();
					{
					_loop187:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop187;
						}
						
					} while (true);
					}
					
					itemPermissions.add( itemPermission );
					
				}
				else {
					break _loop188;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userClasses() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered userClasses()" );
		userClassesMap = new NoDuplicateKeysMap();
		
		
		try {      // for error handling
			match(ID_userClasses);
			{
			int _cnt218=0;
			_loop218:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt218>=1 ) { break _loop218; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt218++;
			} while (true);
			}
			match(OPEN_CURLY);
			{
			_loop220:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop220;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case ID_allUsers:
			case ID_thisEntry:
			case ID_parentOfEntry:
			case ID_name:
			case ID_userGroup:
			case ID_subtree:
			{
				userClass();
				{
				_loop223:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop223;
					}
					
				} while (true);
				}
				{
				_loop229:
				do {
					if ((LA(1)==SEP)) {
						match(SEP);
						{
						_loop226:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop226;
							}
							
						} while (true);
						}
						userClass();
						{
						_loop228:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop228;
							}
							
						} while (true);
						}
					}
					else {
						break _loop229;
					}
					
				} while (true);
				}
				break;
			}
			case CLOSE_CURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(CLOSE_CURLY);
			
			userClasses  = new HashSet<UserClass>( userClassesMap.values() );
			
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( I18n.err( I18n.MSG_07011_DUPLICATED_USER_CLASSES, e.getMessage() ) );
			
		}
	}
	
	public final void userPermissions() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered userPermissions()" );
		userPermissions = new HashSet<UserPermission>();
		UserPermission userPermission = null;
		
		
		match(ID_userPermissions);
		{
		int _cnt275=0;
		_loop275:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt275>=1 ) { break _loop275; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt275++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop277:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop277;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			userPermission=userPermission();
			{
			_loop280:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop280;
				}
				
			} while (true);
			}
			
			userPermissions.add( userPermission );
			
			{
			_loop286:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop283:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop283;
						}
						
					} while (true);
					}
					userPermission=userPermission();
					{
					_loop285:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop285;
						}
						
					} while (true);
					}
					
					userPermissions.add( userPermission );
					
				}
				else {
					break _loop286;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItem() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered protectedItem()" );
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			entry();
			break;
		}
		case ID_allUserAttributeTypes:
		{
			allUserAttributeTypes();
			break;
		}
		case ID_attributeType:
		{
			attributeType();
			break;
		}
		case ID_allAttributeValues:
		{
			allAttributeValues();
			break;
		}
		case ID_allUserAttributeTypesAndValues:
		{
			allUserAttributeTypesAndValues();
			break;
		}
		case ATTRIBUTE_VALUE_CANDIDATE:
		{
			attributeValue();
			break;
		}
		case ID_selfValue:
		{
			selfValue();
			break;
		}
		case RANGE_OF_VALUES_CANDIDATE:
		{
			rangeOfValues();
			break;
		}
		case ID_maxValueCount:
		{
			maxValueCount();
			break;
		}
		case ID_maxImmSub:
		{
			maxImmSub();
			break;
		}
		case ID_restrictedBy:
		{
			restrictedBy();
			break;
		}
		case ID_classes:
		{
			classes();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void entry() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered entry()" );  
		
		
		match(ID_entry);
		
		protectedItemsMap.put( "entry", ProtectedItem.ENTRY );
		
	}
	
	public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered allUserAttributeTypes()" );
		
		
		match(ID_allUserAttributeTypes);
		
		protectedItemsMap.put( "allUserAttributeTypes", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES );
		
	}
	
	public final void attributeType() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered attributeType()" );
		Set<AttributeType> attributeTypeSet = null;
		
		
		match(ID_attributeType);
		{
		int _cnt78=0;
		_loop78:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt78>=1 ) { break _loop78; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt78++;
		} while (true);
		}
		attributeTypeSet=attributeTypeSet();
		
		protectedItemsMap.put( "attributeType", new AttributeTypeItem(attributeTypeSet ) );
		
	}
	
	public final void allAttributeValues() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered allAttributeValues()" );
		Set<AttributeType> attributeTypeSet = null;
		
		
		match(ID_allAttributeValues);
		{
		int _cnt81=0;
		_loop81:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt81>=1 ) { break _loop81; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt81++;
		} while (true);
		}
		attributeTypeSet=attributeTypeSet();
		
		protectedItemsMap.put( "allAttributeValues", new AllAttributeValuesItem( attributeTypeSet ) );
		
	}
	
	public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered allUserAttributeTypesAndValues()" );
		
		
		match(ID_allUserAttributeTypesAndValues);
		
		protectedItemsMap.put( "allUserAttributeTypesAndValues", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES_AND_VALUES );
		
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		LOG.debug( "entered attributeValue()" );
		String attributeTypeAndValue = null;
		String attributeType = null;
		String attributeValue = null;
		Set<Attribute> attributeSet = new HashSet<Attribute>();
		
		
		try {      // for error handling
			token = LT(1);
			match(ATTRIBUTE_VALUE_CANDIDATE);
			
			// A Dn can be considered as a set of attributeTypeAndValues
			// So, parse the set as a Dn and extract each attributeTypeAndValue
			Dn attributeTypeAndValueSetAsDn = new Dn( schemaManager, token.getText() );
			
			for ( Rdn rdn : attributeTypeAndValueSetAsDn )
			{
			attributeTypeAndValue = rdn.getName();
			attributeType = DnUtils.getRdnAttributeType( attributeTypeAndValue );
			attributeValue = DnUtils.getRdnValue( attributeTypeAndValue );
			
			attributeSet.add( new DefaultAttribute( attributeType, attributeValue ) );
			LOG.debug( I18n.msg( I18n.MSG_07000_ATTRIBUTE_TYPE_AND_VALUE_FROM_SET, attributeType,  attributeValue ) );
			}
			
			protectedItemsMap.put( "attributeValue", new AttributeValueItem( attributeSet ) );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( I18n.err( I18n.ERR_07008_DN_PARSER_FAILED, token.getText(), e.getMessage() ) );
			
		}
	}
	
	public final void selfValue() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered selfValue()" );
		Set<AttributeType> attributeTypeSet = null;
		
		
		match(ID_selfValue);
		{
		int _cnt86=0;
		_loop86:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt86>=1 ) { break _loop86; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt86++;
		} while (true);
		}
		attributeTypeSet=attributeTypeSet();
		
		protectedItemsMap.put( "sefValue", new SelfValueItem( attributeTypeSet ) );
		
	}
	
	public final void rangeOfValues() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		LOG.debug( "entered rangeOfValues()" );
		
		
		try {      // for error handling
			token = LT(1);
			match(RANGE_OF_VALUES_CANDIDATE);
			
			protectedItemsMap.put( "rangeOfValues",
			new RangeOfValuesItem(
			FilterParser.parse( schemaManager, token.getText() ) ) );
			LOG.debug( I18n.msg( I18n.MSG_07001_FILTER_SET_PARSED, token.getText() ) );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( I18n.err( I18n.MSG_07009_FILTER_PARSER_FAILED, e.getMessage() ) );
			
		}
	}
	
	public final void maxValueCount() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered maxValueCount()" );
		MaxValueCountElem maxValueCount = null;
		Set<MaxValueCountElem> maxValueCountSet = new HashSet<MaxValueCountElem>();
		
		
		match(ID_maxValueCount);
		{
		int _cnt90=0;
		_loop90:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt90>=1 ) { break _loop90; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt90++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop92:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop92;
			}
			
		} while (true);
		}
		maxValueCount=aMaxValueCount();
		{
		_loop94:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop94;
			}
			
		} while (true);
		}
		
		maxValueCountSet.add( maxValueCount );
		
		{
		_loop100:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop97:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop97;
					}
					
				} while (true);
				}
				maxValueCount=aMaxValueCount();
				{
				_loop99:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop99;
					}
					
				} while (true);
				}
				
				maxValueCountSet.add( maxValueCount );
				
			}
			else {
				break _loop100;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		protectedItemsMap.put( "maxValueCount", new MaxValueCountItem( maxValueCountSet ) );
		
	}
	
	public final void maxImmSub() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		LOG.debug( "entered maxImmSub()" );
		
		
		match(ID_maxImmSub);
		{
		int _cnt125=0;
		_loop125:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt125>=1 ) { break _loop125; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt125++;
		} while (true);
		}
		token = LT(1);
		match(INTEGER);
		
		
		protectedItemsMap.put( "maxImmSub",
		new MaxImmSubItem(
		token2Integer( token ) ) );
		
	}
	
	public final void restrictedBy() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered restrictedBy()" );
		RestrictedByElem restrictedValue = null;
		Set<RestrictedByElem> restrictedBy = new HashSet<RestrictedByElem>();
		
		
		match(ID_restrictedBy);
		{
		int _cnt128=0;
		_loop128:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt128>=1 ) { break _loop128; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt128++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop130:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop130;
			}
			
		} while (true);
		}
		restrictedValue=restrictedValue();
		{
		_loop132:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop132;
			}
			
		} while (true);
		}
		
		restrictedBy.add( restrictedValue );
		
		{
		_loop138:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop135:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop135;
					}
					
				} while (true);
				}
				restrictedValue=restrictedValue();
				{
				_loop137:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop137;
					}
					
				} while (true);
				}
				
				restrictedBy.add( restrictedValue );
				
			}
			else {
				break _loop138;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		protectedItemsMap.put( "restrictedBy", new RestrictedByItem( restrictedBy ) );
		
	}
	
	public final void classes() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered classes()" );
		ExprNode classes = null;
		
		
		match(ID_classes);
		{
		int _cnt174=0;
		_loop174:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt174>=1 ) { break _loop174; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt174++;
		} while (true);
		}
		classes=refinement();
		
		protectedItemsMap.put( "classes", new ClassesItem( classes ) );
		
	}
	
	public final  Set<AttributeType>  attributeTypeSet() throws RecognitionException, TokenStreamException {
		 Set<AttributeType> attributeTypeSet ;
		
		
		LOG.debug( "entered attributeTypeSet()" );
		String oid = null;
		attributeTypeSet = new HashSet<AttributeType>();
		AttributeType attributeType = null;
		
		
		match(OPEN_CURLY);
		{
		_loop163:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop163;
			}
			
		} while (true);
		}
		oid=oid();
		{
		_loop165:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop165;
			}
			
		} while (true);
		}
		
		try
		{
		if ( schemaManager != null )
		{
		attributeType = schemaManager.lookupAttributeTypeRegistry( oid );
		}
		else
		{
		attributeType = new AttributeType( oid );
		}
		
		attributeTypeSet.add( attributeType );
		}
		catch ( LdapException le )
		{
		// The oid does not exist
		// TODO : deal with such an exception
		}
		
		{
		_loop171:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop168:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop168;
					}
					
				} while (true);
				}
				oid=oid();
				{
				_loop170:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop170;
					}
					
				} while (true);
				}
				
				try
				{
				if ( schemaManager != null )
				{
				attributeType = schemaManager.lookupAttributeTypeRegistry( oid );
				}
				else
				{
				attributeType = new AttributeType( oid );
				}
				
				attributeTypeSet.add( attributeType );
				}
				catch ( LdapException le )
				{
				// The oid does not exist
				// TODO : deal with such an exception
				}
				
			}
			else {
				break _loop171;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		return attributeTypeSet ;
	}
	
	public final  MaxValueCountElem  aMaxValueCount() throws RecognitionException, TokenStreamException {
		 MaxValueCountElem maxValueCount ;
		
		Token  token1 = null;
		Token  token2 = null;
		
		LOG.debug( "entered aMaxValueCount()" );
		maxValueCount = null;
		String oid = null;
		Token token = null;
		AttributeType attributeType = null;
		
		
		match(OPEN_CURLY);
		{
		_loop103:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop103;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt106=0;
			_loop106:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt106>=1 ) { break _loop106; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt106++;
			} while (true);
			}
			oid=oid();
			{
			_loop108:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop108;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop110:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop110;
				}
				
			} while (true);
			}
			match(ID_maxCount);
			{
			int _cnt112=0;
			_loop112:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt112>=1 ) { break _loop112; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt112++;
			} while (true);
			}
			token1 = LT(1);
			match(INTEGER);
			token = token1;
			break;
		}
		case ID_maxCount:
		{
			match(ID_maxCount);
			{
			int _cnt114=0;
			_loop114:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt114>=1 ) { break _loop114; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt114++;
			} while (true);
			}
			token2 = LT(1);
			match(INTEGER);
			{
			_loop116:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop116;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop118:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop118;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt120=0;
			_loop120:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt120>=1 ) { break _loop120; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt120++;
			} while (true);
			}
			oid=oid();
			token = token2;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop122:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop122;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		try
		{
		if ( schemaManager != null )
		{
		attributeType = schemaManager.lookupAttributeTypeRegistry( oid );
		}
		else
		{
		attributeType = new AttributeType( oid );
		}
		
		maxValueCount = new MaxValueCountElem( attributeType, token2Integer( token ) );
		}
		catch ( LdapException le )
		{
		// The oid does not exist
		// TODO : deal with such an exception
		}
		
		return maxValueCount ;
	}
	
	public final  String  oid() throws RecognitionException, TokenStreamException {
		 String result ;
		
		
		LOG.debug( "entered oid()" );
		result = null;
		Token token = null;
		
		
		token = LT( 1 );
		{
		switch ( LA(1)) {
		case DESCR:
		{
			match(DESCR);
			break;
		}
		case NUMERICOID:
		{
			match(NUMERICOID);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
		result = token.getText();
		LOG.debug( I18n.msg( I18n.MSG_07003_OID_PARSED, result ) );
		
		return result ;
	}
	
	public final  RestrictedByElem  restrictedValue() throws RecognitionException, TokenStreamException {
		 RestrictedByElem restrictedValue ;
		
		
		LOG.debug( "entered restrictedValue()" );
		String typeOid = null;
		String valuesInOid = null;
		restrictedValue = null;
		AttributeType attributeType = null;
		AttributeType valueInAttributeType = null;
		
		
		match(OPEN_CURLY);
		{
		_loop141:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop141;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt144=0;
			_loop144:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt144>=1 ) { break _loop144; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt144++;
			} while (true);
			}
			typeOid=oid();
			{
			_loop146:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop146;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop148:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop148;
				}
				
			} while (true);
			}
			match(ID_valuesIn);
			{
			int _cnt150=0;
			_loop150:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt150>=1 ) { break _loop150; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt150++;
			} while (true);
			}
			valuesInOid=oid();
			break;
		}
		case ID_valuesIn:
		{
			match(ID_valuesIn);
			{
			int _cnt152=0;
			_loop152:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt152>=1 ) { break _loop152; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt152++;
			} while (true);
			}
			valuesInOid=oid();
			{
			_loop154:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop154;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop156:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop156;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt158=0;
			_loop158:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt158>=1 ) { break _loop158; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt158++;
			} while (true);
			}
			typeOid=oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop160:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop160;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		try
		{
		if ( schemaManager != null )
		{
		attributeType = schemaManager.lookupAttributeTypeRegistry( typeOid );
		valueInAttributeType = schemaManager.lookupAttributeTypeRegistry( valuesInOid );
		}
		else
		{
		attributeType = new AttributeType( typeOid );
		valueInAttributeType = new AttributeType( valuesInOid );
		}
		
		restrictedValue = new RestrictedByElem( attributeType, valueInAttributeType );
		}
		catch ( LdapException le )
		{
		// The oid does not exist
		// TODO : deal with such an exception
		}
		
		return restrictedValue ;
	}
	
	public final  ExprNode  refinement() throws RecognitionException, TokenStreamException {
		 ExprNode node ;
		
		
		LOG.debug( "entered refinement()" );
		node = null;
		
		
		switch ( LA(1)) {
		case ID_item:
		{
			node=item();
			break;
		}
		case ID_and:
		{
			node=and();
			break;
		}
		case ID_or:
		{
			node=or();
			break;
		}
		case ID_not:
		{
			node=not();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return node ;
	}
	
	public final  ItemPermission  itemPermission() throws RecognitionException, TokenStreamException {
		 ItemPermission itemPermission ;
		
		
		LOG.debug( "entered itemPermission()" );
		itemPermission = null;
		itemPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor( 
		new String [] { "userClasses", "grantsAndDenials" }, new String [] { "precedence" } );
		
		
		match(OPEN_CURLY);
		{
		_loop191:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop191;
			}
			
		} while (true);
		}
		anyItemPermission();
		{
		_loop193:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop193;
			}
			
		} while (true);
		}
		{
		_loop199:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop196:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop196;
					}
					
				} while (true);
				}
				anyItemPermission();
				{
				_loop198:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop198;
					}
					
				} while (true);
				}
			}
			else {
				break _loop199;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		if ( !itemPermissionComponentsMonitor.finalStateValid() )
		{
		throw new RecognitionException( I18n.err( I18n.ERR_07005_MISSING_MANDATORY_ACIITEM, 
						itemPermissionComponentsMonitor.getRemainingComponents() ) );
		}
		
		itemPermission = new ItemPermission( precedence, grantsAndDenials, userClasses );
		precedence = null;
		
		return itemPermission ;
	}
	
	public final void anyItemPermission() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_precedence:
			{
				precedence();
				
				itemPermissionComponentsMonitor.useComponent( "precedence" );
				
				break;
			}
			case ID_userClasses:
			{
				userClasses();
				
				itemPermissionComponentsMonitor.useComponent( "userClasses" );
				
				break;
			}
			case ID_grantsAndDenials:
			{
				grantsAndDenials();
				
				itemPermissionComponentsMonitor.useComponent( "grantsAndDenials" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered grantsAndDenials()" );
		grantsAndDenials = new HashSet<GrantAndDenial>();
		GrantAndDenial grantAndDenial = null;
		
		
		match(ID_grantsAndDenials);
		{
		int _cnt203=0;
		_loop203:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt203>=1 ) { break _loop203; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt203++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop205:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop205;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_grantAdd:
		case ID_denyAdd:
		case ID_grantDiscloseOnError:
		case ID_denyDiscloseOnError:
		case ID_grantRead:
		case ID_denyRead:
		case ID_grantRemove:
		case ID_denyRemove:
		case ID_grantBrowse:
		case ID_denyBrowse:
		case ID_grantExport:
		case ID_denyExport:
		case ID_grantImport:
		case ID_denyImport:
		case ID_grantModify:
		case ID_denyModify:
		case ID_grantRename:
		case ID_denyRename:
		case ID_grantReturnDN:
		case ID_denyReturnDN:
		case ID_grantCompare:
		case ID_denyCompare:
		case ID_grantFilterMatch:
		case ID_denyFilterMatch:
		case ID_grantInvoke:
		case ID_denyInvoke:
		{
			grantAndDenial=grantAndDenial();
			{
			_loop208:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop208;
				}
				
			} while (true);
			}
			
			if ( !grantsAndDenials.add( grantAndDenial ))
			{
			throw new RecognitionException( I18n.err( I18n.MSG_07010_DUPLICATED_GRANT_AND_DENIAL, grantAndDenial ) );
			}
			
			{
			_loop214:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop211:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop211;
						}
						
					} while (true);
					}
					grantAndDenial=grantAndDenial();
					{
					_loop213:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop213;
						}
						
					} while (true);
					}
					
					if ( !grantsAndDenials.add( grantAndDenial ))
					{
					throw new RecognitionException( I18n.err( I18n.MSG_07010_DUPLICATED_GRANT_AND_DENIAL, grantAndDenial ) );
					}
					
				}
				else {
					break _loop214;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final  GrantAndDenial  grantAndDenial() throws RecognitionException, TokenStreamException {
		 GrantAndDenial l_grantAndDenial ;
		
		
		LOG.debug( "entered grantAndDenialsBit()" );
		l_grantAndDenial = null;
		
		
		switch ( LA(1)) {
		case ID_grantAdd:
		{
			match(ID_grantAdd);
			l_grantAndDenial = GrantAndDenial.GRANT_ADD;
			break;
		}
		case ID_denyAdd:
		{
			match(ID_denyAdd);
			l_grantAndDenial = GrantAndDenial.DENY_ADD;
			break;
		}
		case ID_grantDiscloseOnError:
		{
			match(ID_grantDiscloseOnError);
			l_grantAndDenial = GrantAndDenial.GRANT_DISCLOSE_ON_ERROR;
			break;
		}
		case ID_denyDiscloseOnError:
		{
			match(ID_denyDiscloseOnError);
			l_grantAndDenial = GrantAndDenial.DENY_DISCLOSE_ON_ERROR;
			break;
		}
		case ID_grantRead:
		{
			match(ID_grantRead);
			l_grantAndDenial = GrantAndDenial.GRANT_READ;
			break;
		}
		case ID_denyRead:
		{
			match(ID_denyRead);
			l_grantAndDenial = GrantAndDenial.DENY_READ;
			break;
		}
		case ID_grantRemove:
		{
			match(ID_grantRemove);
			l_grantAndDenial = GrantAndDenial.GRANT_REMOVE;
			break;
		}
		case ID_denyRemove:
		{
			match(ID_denyRemove);
			l_grantAndDenial = GrantAndDenial.DENY_REMOVE;
			break;
		}
		case ID_grantBrowse:
		{
			match(ID_grantBrowse);
			l_grantAndDenial = GrantAndDenial.GRANT_BROWSE;
			break;
		}
		case ID_denyBrowse:
		{
			match(ID_denyBrowse);
			l_grantAndDenial = GrantAndDenial.DENY_BROWSE;
			break;
		}
		case ID_grantExport:
		{
			match(ID_grantExport);
			l_grantAndDenial = GrantAndDenial.GRANT_EXPORT;
			break;
		}
		case ID_denyExport:
		{
			match(ID_denyExport);
			l_grantAndDenial = GrantAndDenial.DENY_EXPORT;
			break;
		}
		case ID_grantImport:
		{
			match(ID_grantImport);
			l_grantAndDenial = GrantAndDenial.GRANT_IMPORT;
			break;
		}
		case ID_denyImport:
		{
			match(ID_denyImport);
			l_grantAndDenial = GrantAndDenial.DENY_IMPORT;
			break;
		}
		case ID_grantModify:
		{
			match(ID_grantModify);
			l_grantAndDenial = GrantAndDenial.GRANT_MODIFY;
			break;
		}
		case ID_denyModify:
		{
			match(ID_denyModify);
			l_grantAndDenial = GrantAndDenial.DENY_MODIFY;
			break;
		}
		case ID_grantRename:
		{
			match(ID_grantRename);
			l_grantAndDenial = GrantAndDenial.GRANT_RENAME;
			break;
		}
		case ID_denyRename:
		{
			match(ID_denyRename);
			l_grantAndDenial = GrantAndDenial.DENY_RENAME;
			break;
		}
		case ID_grantReturnDN:
		{
			match(ID_grantReturnDN);
			l_grantAndDenial = GrantAndDenial.GRANT_RETURN_DN;
			break;
		}
		case ID_denyReturnDN:
		{
			match(ID_denyReturnDN);
			l_grantAndDenial = GrantAndDenial.DENY_RETURN_DN;
			break;
		}
		case ID_grantCompare:
		{
			match(ID_grantCompare);
			l_grantAndDenial = GrantAndDenial.GRANT_COMPARE;
			break;
		}
		case ID_denyCompare:
		{
			match(ID_denyCompare);
			l_grantAndDenial = GrantAndDenial.DENY_COMPARE;
			break;
		}
		case ID_grantFilterMatch:
		{
			match(ID_grantFilterMatch);
			l_grantAndDenial = GrantAndDenial.GRANT_FILTER_MATCH;
			break;
		}
		case ID_denyFilterMatch:
		{
			match(ID_denyFilterMatch);
			l_grantAndDenial = GrantAndDenial.DENY_FILTER_MATCH;
			break;
		}
		case ID_grantInvoke:
		{
			match(ID_grantInvoke);
			l_grantAndDenial = GrantAndDenial.GRANT_INVOKE;
			break;
		}
		case ID_denyInvoke:
		{
			match(ID_denyInvoke);
			l_grantAndDenial = GrantAndDenial.DENY_INVOKE;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return l_grantAndDenial ;
	}
	
	public final void userClass() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered userClasses()" );
		
		
		switch ( LA(1)) {
		case ID_allUsers:
		{
			allUsers();
			break;
		}
		case ID_thisEntry:
		{
			thisEntry();
			break;
		}
		case ID_parentOfEntry:
		{
			parentOfEntry();
			break;
		}
		case ID_name:
		{
			name();
			break;
		}
		case ID_userGroup:
		{
			userGroup();
			break;
		}
		case ID_subtree:
		{
			subtree();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void allUsers() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered allUsers()" );
		
		
		match(ID_allUsers);
		
		userClassesMap.put( "allUsers", UserClass.ALL_USERS );
		
	}
	
	public final void thisEntry() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered thisEntry()" );
		
		
		match(ID_thisEntry);
		
		userClassesMap.put( "thisEntry", UserClass.THIS_ENTRY );
		
	}
	
	public final void parentOfEntry() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered parentOfEntry()" );
		
		
		match(ID_parentOfEntry);
		
		userClassesMap.put( "parentOfEntry", UserClass.PARENT_OF_ENTRY );
		
	}
	
	public final void name() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered name()" );
		Set<String> names = new HashSet<>();
		Dn distinguishedName = null;
		
		
		match(ID_name);
		{
		int _cnt236=0;
		_loop236:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt236>=1 ) { break _loop236; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt236++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop238:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop238;
			}
			
		} while (true);
		}
		distinguishedName=distinguishedName();
		{
		_loop240:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop240;
			}
			
		} while (true);
		}
		
		names.add( distinguishedName.getNormName() );
		
		{
		_loop246:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop243:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop243;
					}
					
				} while (true);
				}
				distinguishedName=distinguishedName();
				{
				_loop245:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop245;
					}
					
				} while (true);
				}
				
				names.add( distinguishedName.getNormName() );
				
			}
			else {
				break _loop246;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		userClassesMap.put( "name", new UserClass.Name( names ) );
		
	}
	
	public final void userGroup() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered userGroup()" );
		Set<String> userGroup = new HashSet<>();
		Dn distinguishedName = null;
		
		
		match(ID_userGroup);
		{
		int _cnt249=0;
		_loop249:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt249>=1 ) { break _loop249; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt249++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop251:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop251;
			}
			
		} while (true);
		}
		distinguishedName=distinguishedName();
		{
		_loop253:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop253;
			}
			
		} while (true);
		}
		
		userGroup.add( distinguishedName.getNormName() );
		
		{
		_loop259:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop256:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop256;
					}
					
				} while (true);
				}
				distinguishedName=distinguishedName();
				{
				_loop258:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop258;
					}
					
				} while (true);
				}
				
				userGroup.add( distinguishedName.getNormName() );
				
			}
			else {
				break _loop259;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		userClassesMap.put( "userGroup", new UserClass.UserGroup( userGroup ) );
		
	}
	
	public final void subtree() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered subtree()" );
		Set<SubtreeSpecification> subtrees = new HashSet<SubtreeSpecification>();
		SubtreeSpecification subtreeSpecification = null;    
		
		
		match(ID_subtree);
		{
		int _cnt262=0;
		_loop262:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt262>=1 ) { break _loop262; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt262++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop264:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop264;
			}
			
		} while (true);
		}
		subtreeSpecification=subtreeSpecification();
		{
		_loop266:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop266;
			}
			
		} while (true);
		}
		
		subtrees.add( subtreeSpecification );
		
		{
		_loop272:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop269:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop269;
					}
					
				} while (true);
				}
				subtreeSpecification=subtreeSpecification();
				{
				_loop271:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop271;
					}
					
				} while (true);
				}
				
				subtrees.add( subtreeSpecification );
				
			}
			else {
				break _loop272;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		userClassesMap.put( "subtree", new UserClass.Subtree( subtrees ) );
		
	}
	
	public final  Dn  distinguishedName() throws RecognitionException, TokenStreamException {
		 Dn name ;
		
		Token  token = null;
		
		LOG.debug( "entered distinguishedName()" );
		name = null;
		
		
		try {      // for error handling
			token = LT(1);
			match(SAFEUTF8STRING);
			
			name = new Dn( schemaManager, token.getText() );
			
			LOG.debug( I18n.msg( I18n.MSG_07002_DN_PARSED, token.getText() ) );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( I18n.err( I18n.ERR_07008_DN_PARSER_FAILED, token.getText(), e.getMessage() ) );
			
		}
		return name ;
	}
	
	public final SubtreeSpecification  subtreeSpecification() throws RecognitionException, TokenStreamException {
		SubtreeSpecification ss;
		
		
		LOG.debug( "entered subtreeSpecification()" );
		// clear out ss, ssModifier, chopBeforeExclusions and chopAfterExclusions
		// in case something is left from the last parse
		ss = null;
		ssModifier = new SubtreeSpecificationModifier();
		chopBeforeExclusions = new HashSet<Dn>();
		chopAfterExclusions = new HashSet<Dn>();
		subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor( 
		new String [] { "base", "specificExclusions", "minimum", "maximum" } );
		
		
		match(OPEN_CURLY);
		{
		_loop301:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop301;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_base:
		case ID_specificExclusions:
		case ID_minimum:
		case ID_maximum:
		{
			subtreeSpecificationComponent();
			{
			_loop304:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop304;
				}
				
			} while (true);
			}
			{
			_loop310:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop307:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop307;
						}
						
					} while (true);
					}
					subtreeSpecificationComponent();
					{
					_loop309:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop309;
						}
						
					} while (true);
					}
				}
				else {
					break _loop310;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
		
		ss = ssModifier.getSubtreeSpecification();
		
		return ss;
	}
	
	public final  UserPermission  userPermission() throws RecognitionException, TokenStreamException {
		 UserPermission userPermission ;
		
		
		LOG.debug( "entered userPermission()" );
		userPermission = null;
		userPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor( 
		new String [] { "protectedItems", "grantsAndDenials" }, new String [] { "precedence" } );
		
		
		match(OPEN_CURLY);
		{
		_loop289:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop289;
			}
			
		} while (true);
		}
		anyUserPermission();
		{
		_loop291:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop291;
			}
			
		} while (true);
		}
		{
		_loop297:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop294:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop294;
					}
					
				} while (true);
				}
				anyUserPermission();
				{
				_loop296:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop296;
					}
					
				} while (true);
				}
			}
			else {
				break _loop297;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		if ( !userPermissionComponentsMonitor.finalStateValid() )
		{
		throw new RecognitionException( I18n.err( I18n.ERR_07012_MISSING_MANDATORY_USER_PERMISSION,
		userPermissionComponentsMonitor.getRemainingComponents() ) );
		}
		
		userPermission = new UserPermission( precedence, grantsAndDenials, protectedItems );
		precedence = null;
		
		return userPermission ;
	}
	
	public final void anyUserPermission() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_precedence:
			{
				precedence();
				
				userPermissionComponentsMonitor.useComponent( "precedence" );
				
				break;
			}
			case ID_protectedItems:
			{
				protectedItems();
				
				userPermissionComponentsMonitor.useComponent( "protectedItems" );
				
				break;
			}
			case ID_grantsAndDenials:
			{
				grantsAndDenials();
				
				userPermissionComponentsMonitor.useComponent( "grantsAndDenials" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered subtreeSpecification()" );
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_base:
			{
				ss_base();
				
				subtreeSpecificationComponentsMonitor.useComponent( "base" );
				
				break;
			}
			case ID_specificExclusions:
			{
				ss_specificExclusions();
				
				subtreeSpecificationComponentsMonitor.useComponent( "specificExclusions" );
				
				break;
			}
			case ID_minimum:
			{
				ss_minimum();
				
				subtreeSpecificationComponentsMonitor.useComponent( "minimum" );
				
				break;
			}
			case ID_maximum:
			{
				ss_maximum();
				
				subtreeSpecificationComponentsMonitor.useComponent( "maximum" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void ss_base() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered ss_base()" );
		Dn base = null;
		
		
		match(ID_base);
		{
		int _cnt314=0;
		_loop314:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt314>=1 ) { break _loop314; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt314++;
		} while (true);
		}
		base=distinguishedName();
		
		ssModifier.setBase( base );
		
	}
	
	public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered ss_specificExclusions()" );
		
		
		match(ID_specificExclusions);
		{
		int _cnt317=0;
		_loop317:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt317>=1 ) { break _loop317; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt317++;
		} while (true);
		}
		specificExclusions();
		
		ssModifier.setChopBeforeExclusions( chopBeforeExclusions );
		ssModifier.setChopAfterExclusions( chopAfterExclusions );
		
	}
	
	public final void ss_minimum() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered ss_minimum()" );
		int minimum = 0;
		
		
		match(ID_minimum);
		{
		int _cnt343=0;
		_loop343:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt343>=1 ) { break _loop343; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt343++;
		} while (true);
		}
		minimum=baseDistance();
		
		ssModifier.setMinBaseDistance( minimum );
		
	}
	
	public final void ss_maximum() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered ss_maximum()" );
		int maximum = 0;
		
		
		match(ID_maximum);
		{
		int _cnt346=0;
		_loop346:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt346>=1 ) { break _loop346; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt346++;
		} while (true);
		}
		maximum=baseDistance();
		
		ssModifier.setMaxBaseDistance( maximum );
		
	}
	
	public final void specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered specificExclusions()" );
		
		
		match(OPEN_CURLY);
		{
		_loop320:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop320;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_chopBefore:
		case ID_chopAfter:
		{
			specificExclusion();
			{
			_loop323:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop323;
				}
				
			} while (true);
			}
			{
			_loop329:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop326:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop326;
						}
						
					} while (true);
					}
					specificExclusion();
					{
					_loop328:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop328;
						}
						
					} while (true);
					}
				}
				else {
					break _loop329;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void specificExclusion() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered specificExclusion()" );
		
		
		switch ( LA(1)) {
		case ID_chopBefore:
		{
			chopBefore();
			break;
		}
		case ID_chopAfter:
		{
			chopAfter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void chopBefore() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered chopBefore()" );
		Dn chopBeforeExclusion = null;
		
		
		match(ID_chopBefore);
		{
		_loop333:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop333;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop335:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop335;
			}
			
		} while (true);
		}
		chopBeforeExclusion=distinguishedName();
		
		chopBeforeExclusions.add( chopBeforeExclusion );
		
	}
	
	public final void chopAfter() throws RecognitionException, TokenStreamException {
		
		
		LOG.debug( "entered chopAfter()" );
		Dn chopAfterExclusion = null;
		
		
		match(ID_chopAfter);
		{
		_loop338:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop338;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop340:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop340;
			}
			
		} while (true);
		}
		chopAfterExclusion=distinguishedName();
		
		chopAfterExclusions.add( chopAfterExclusion );
		
	}
	
	public final  int  baseDistance() throws RecognitionException, TokenStreamException {
		 int distance ;
		
		Token  token = null;
		
		LOG.debug( "entered baseDistance()" );
		distance = 0;
		
		
		token = LT(1);
		match(INTEGER);
		
		distance = token2Integer( token );
		
		return distance ;
	}
	
	public final  LeafNode  item() throws RecognitionException, TokenStreamException {
		 LeafNode node ;
		
		
		LOG.debug( "entered item()" );
		node = null;
		String oid = null;
		
		
		match(ID_item);
		{
		_loop354:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop354;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop356:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop356;
			}
			
		} while (true);
		}
		oid=oid();
		
		node = new EqualityNode( SchemaConstants.OBJECT_CLASS_AT , oid );
		
		return node ;
	}
	
	public final  BranchNode  and() throws RecognitionException, TokenStreamException {
		 BranchNode node ;
		
		
		LOG.debug( "entered and()" );
		node = null;
		List<ExprNode> children = null; 
		
		
		match(ID_and);
		{
		_loop359:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop359;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop361:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop361;
			}
			
		} while (true);
		}
		children=refinements();
		
		node = new AndNode( children );
		
		return node ;
	}
	
	public final  BranchNode  or() throws RecognitionException, TokenStreamException {
		 BranchNode node ;
		
		
		LOG.debug( "entered or()" );
		node = null;
		List<ExprNode> children = null; 
		
		
		match(ID_or);
		{
		_loop364:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop364;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop366:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop366;
			}
			
		} while (true);
		}
		children=refinements();
		
		node = new OrNode( children );
		
		return node ;
	}
	
	public final  BranchNode  not() throws RecognitionException, TokenStreamException {
		 BranchNode node ;
		
		
		LOG.debug( "entered not()" );
		node = null;
		List<ExprNode> children = null;
		
		
		match(ID_not);
		{
		_loop369:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop369;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop371:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop371;
			}
			
		} while (true);
		}
		children=refinements();
		
		node = new NotNode( children );
		
		return node ;
	}
	
	public final  List<ExprNode>  refinements() throws RecognitionException, TokenStreamException {
		 List<ExprNode> children ;
		
		
		LOG.debug( "entered refinements()" );
		children = null;
		ExprNode child = null;
		List<ExprNode> tempChildren = new ArrayList<ExprNode>();
		
		
		match(OPEN_CURLY);
		{
		_loop374:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop374;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			child=refinement();
			{
			_loop377:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop377;
				}
				
			} while (true);
			}
			
			tempChildren.add( child );
			
			{
			_loop383:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop380:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop380;
						}
						
					} while (true);
					}
					child=refinement();
					{
					_loop382:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop382;
						}
						
					} while (true);
					}
					
					tempChildren.add( child );
					
				}
				else {
					break _loop383;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
		
		children = tempChildren;
		
		return children ;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"ATTRIBUTE_VALUE_CANDIDATE",
		"RANGE_OF_VALUES_CANDIDATE",
		"SP",
		"OPEN_CURLY",
		"SEP",
		"CLOSE_CURLY",
		"\"identificationTag\"",
		"SAFEUTF8STRING",
		"\"precedence\"",
		"INTEGER",
		"\"authenticationLevel\"",
		"\"none\"",
		"\"simple\"",
		"\"strong\"",
		"\"itemOrUserFirst\"",
		"\"itemFirst\"",
		"COLON",
		"\"userFirst\"",
		"\"protectedItems\"",
		"\"entry\"",
		"\"allUserAttributeTypes\"",
		"\"attributeType\"",
		"\"allAttributeValues\"",
		"\"allUserAttributeTypesAndValues\"",
		"\"selfValue\"",
		"\"maxValueCount\"",
		"\"type\"",
		"\"maxCount\"",
		"\"maxImmSub\"",
		"\"restrictedBy\"",
		"\"valuesIn\"",
		"\"classes\"",
		"\"itemPermissions\"",
		"\"grantsAndDenials\"",
		"\"grantAdd\"",
		"\"denyAdd\"",
		"\"grantDiscloseOnError\"",
		"\"denyDiscloseOnError\"",
		"\"grantRead\"",
		"\"denyRead\"",
		"\"grantRemove\"",
		"\"denyRemove\"",
		"\"grantBrowse\"",
		"\"denyBrowse\"",
		"\"grantExport\"",
		"\"denyExport\"",
		"\"grantImport\"",
		"\"denyImport\"",
		"\"grantModify\"",
		"\"denyModify\"",
		"\"grantRename\"",
		"\"denyRename\"",
		"\"grantReturnDN\"",
		"\"denyReturnDN\"",
		"\"grantCompare\"",
		"\"denyCompare\"",
		"\"grantFilterMatch\"",
		"\"denyFilterMatch\"",
		"\"grantInvoke\"",
		"\"denyInvoke\"",
		"\"userClasses\"",
		"\"allUsers\"",
		"\"thisEntry\"",
		"\"parentOfEntry\"",
		"\"name\"",
		"\"userGroup\"",
		"\"subtree\"",
		"\"userPermissions\"",
		"\"base\"",
		"\"specificExclusions\"",
		"\"chopBefore\"",
		"\"chopAfter\"",
		"\"minimum\"",
		"\"maximum\"",
		"DESCR",
		"NUMERICOID",
		"\"item\"",
		"\"and\"",
		"\"or\"",
		"\"not\"",
		"\"FALSE\"",
		"\"TRUE\"",
		"\"level\"",
		"\"basicLevels\"",
		"\"localQualifier\"",
		"\"signed\"",
		"\"rangeOfValues\"",
		"\"specificationFilter\"",
		"SAFEUTF8CHAR",
		"DIGIT",
		"LDIGIT",
		"ALPHA",
		"HYPHEN",
		"DOT",
		"INTEGER_OR_NUMERICOID",
		"FILTER",
		"FILTER_VALUE"
	};
	
	
	}
