/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.mysql.catalog;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.databases.mysql.catalog.MySqlTypeMapper;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectTypeMapper;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MySqlCatalog
extends AbstractJdbcCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlCatalog.class);
    private final JdbcDialectTypeMapper dialectTypeMapper;
    private static final Set<String> builtinDatabases = new HashSet<String>(){
        {
            this.add("information_schema");
            this.add("mysql");
            this.add("performance_schema");
            this.add("sys");
        }
    };

    public MySqlCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        super(userClassLoader, catalogName, defaultDatabase, username, pwd, baseUrl);
        String driverVersion = (String)Preconditions.checkNotNull((Object)this.getDriverVersion(), (String)"Driver version must not be null.");
        String databaseVersion = (String)Preconditions.checkNotNull((Object)this.getDatabaseVersion(), (String)"Database version must not be null.");
        LOG.info("Driver version: {}, database version: {}", (Object)driverVersion, (Object)databaseVersion);
        this.dialectTypeMapper = new MySqlTypeMapper(databaseVersion, driverVersion);
    }

    public List<String> listDatabases() throws CatalogException {
        return this.extractColumnValuesBySQL(this.defaultUrl, "SELECT `SCHEMA_NAME` FROM `INFORMATION_SCHEMA`.`SCHEMATA`;", 1, dbName -> !builtinDatabases.contains(dbName), new Object[0]);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)databaseName), (Object)"Database name must not be blank.");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.extractColumnValuesBySQL(this.baseUrl + databaseName, "SELECT TABLE_NAME FROM information_schema.`TABLES` WHERE TABLE_SCHEMA = ?", 1, null, databaseName);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        return !this.extractColumnValuesBySQL(this.baseUrl, "SELECT TABLE_NAME FROM information_schema.`TABLES` WHERE TABLE_SCHEMA=? and TABLE_NAME=?", 1, null, tablePath.getDatabaseName(), tablePath.getObjectName()).isEmpty();
    }

    private String getDatabaseVersion() {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)this.userClassLoader);){
            String string;
            block14: {
                Connection conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);
                try {
                    string = conn.getMetaData().getDatabaseProductVersion();
                    if (conn == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new CatalogException(String.format("Failed in getting MySQL version by %s.", this.defaultUrl), (Throwable)e);
                    }
                }
                conn.close();
            }
            return string;
        }
    }

    private String getDriverVersion() {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)this.userClassLoader);){
            String string;
            block14: {
                Connection conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);
                try {
                    String driverVersion = conn.getMetaData().getDriverVersion();
                    Pattern regexp = Pattern.compile("\\d+?\\.\\d+?\\.\\d+");
                    Matcher matcher = regexp.matcher(driverVersion);
                    String string2 = string = matcher.find() ? matcher.group(0) : null;
                    if (conn == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new CatalogException(String.format("Failed in getting MySQL driver version by %s.", this.defaultUrl), (Throwable)e);
                    }
                }
                conn.close();
            }
            return string;
        }
    }

    @Override
    protected DataType fromJDBCType(ObjectPath tablePath, ResultSetMetaData metadata, int colIndex) throws SQLException {
        return this.dialectTypeMapper.mapping(tablePath, metadata, colIndex);
    }

    @Override
    protected String getTableName(ObjectPath tablePath) {
        return tablePath.getObjectName();
    }

    @Override
    protected String getSchemaName(ObjectPath tablePath) {
        return tablePath.getDatabaseName();
    }

    @Override
    protected String getSchemaTableName(ObjectPath tablePath) {
        return tablePath.getObjectName();
    }
}

