/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe;

import java.util.EnumSet;
import org.apache.pulsar.shade.com.scurrilous.circe.HashParameters;
import org.apache.pulsar.shade.com.scurrilous.circe.HashProviders;
import org.apache.pulsar.shade.com.scurrilous.circe.HashSupport;
import org.apache.pulsar.shade.com.scurrilous.circe.IncrementalIntHash;
import org.apache.pulsar.shade.com.scurrilous.circe.IncrementalLongHash;
import org.apache.pulsar.shade.com.scurrilous.circe.StatefulHash;
import org.apache.pulsar.shade.com.scurrilous.circe.StatelessIntHash;
import org.apache.pulsar.shade.com.scurrilous.circe.StatelessLongHash;

public final class Hashes {
    private Hashes() {
    }

    public static StatefulHash createStateful(HashParameters params) {
        return HashProviders.best(params).createStateful(params);
    }

    public static StatelessIntHash getStatelessInt(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.INT_SIZED)).getStatelessInt(params);
    }

    public static StatelessLongHash getStatelessLong(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.LONG_SIZED)).getStatelessLong(params);
    }

    public static IncrementalIntHash getIncrementalInt(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.INT_SIZED, HashSupport.STATELESS_INCREMENTAL)).getIncrementalInt(params);
    }

    public static IncrementalLongHash getIncrementalLong(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.LONG_SIZED, HashSupport.STATELESS_INCREMENTAL)).getIncrementalLong(params);
    }
}

