/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.cms;

import java.io.IOException;
import org.apache.pulsar.shade.org.bouncycastle.asn1.cms.KEKIdentifier;
import org.apache.pulsar.shade.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.pulsar.shade.org.bouncycastle.cms.AuthAttributesProvider;
import org.apache.pulsar.shade.org.bouncycastle.cms.CMSException;
import org.apache.pulsar.shade.org.bouncycastle.cms.CMSSecureReadable;
import org.apache.pulsar.shade.org.bouncycastle.cms.KEKRecipient;
import org.apache.pulsar.shade.org.bouncycastle.cms.KEKRecipientId;
import org.apache.pulsar.shade.org.bouncycastle.cms.Recipient;
import org.apache.pulsar.shade.org.bouncycastle.cms.RecipientInformation;
import org.apache.pulsar.shade.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

