/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.cms.bc;

import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.pulsar.shade.org.bouncycastle.cms.CMSException;
import org.apache.pulsar.shade.org.bouncycastle.cms.KeyTransRecipient;
import org.apache.pulsar.shade.org.bouncycastle.cms.bc.CMSUtils;
import org.apache.pulsar.shade.org.bouncycastle.crypto.CipherParameters;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.pulsar.shade.org.bouncycastle.operator.OperatorException;
import org.apache.pulsar.shade.org.bouncycastle.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.recipientKey = asymmetricKeyParameter;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper bcRSAAsymmetricKeyUnwrapper = new BcRSAAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return CMSUtils.getBcKey(bcRSAAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

