/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.cache;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.cache.CuratorCacheStorage;

class StandardCuratorCacheStorage
implements CuratorCacheStorage {
    private final Map<String, ChildData> dataMap = new ConcurrentHashMap<String, ChildData>();
    private final boolean cacheBytes;

    StandardCuratorCacheStorage(boolean cacheBytes) {
        this.cacheBytes = cacheBytes;
    }

    @Override
    public Optional<ChildData> put(ChildData data) {
        ChildData localData = this.cacheBytes ? data : new ChildData(data.getPath(), data.getStat(), null);
        return Optional.ofNullable(this.dataMap.put(data.getPath(), localData));
    }

    @Override
    public Optional<ChildData> remove(String path) {
        return Optional.ofNullable(this.dataMap.remove(path));
    }

    @Override
    public Optional<ChildData> get(String path) {
        return Optional.ofNullable(this.dataMap.get(path));
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public Stream<ChildData> stream() {
        return this.dataMap.values().stream();
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }
}

