/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.slowlog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogTableAccessor.class);
    public static final TableName SLOW_LOG_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "slowlog");

    private static void doPut(Connection connection, List<Put> puts) throws IOException {
        try (Table table = connection.getTable(SLOW_LOG_TABLE_NAME);){
            table.put(puts);
        }
    }

    public static void addSlowLogRecords(List<TooSlowLog.SlowLogPayload> slowLogPayloads, Connection connection) {
        ArrayList<Put> puts = new ArrayList<Put>(slowLogPayloads.size());
        for (TooSlowLog.SlowLogPayload slowLogPayload : slowLogPayloads) {
            byte[] rowKey = SlowLogTableAccessor.getRowKey(slowLogPayload);
            Put put = new Put(rowKey).setDurability(Durability.SKIP_WAL).setPriority(0).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("call_details"), Bytes.toBytes(slowLogPayload.getCallDetails())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("client_address"), Bytes.toBytes(slowLogPayload.getClientAddress())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("method_name"), Bytes.toBytes(slowLogPayload.getMethodName())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("param"), Bytes.toBytes(slowLogPayload.getParam())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("processing_time"), Bytes.toBytes(Integer.toString(slowLogPayload.getProcessingTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("queue_time"), Bytes.toBytes(Integer.toString(slowLogPayload.getQueueTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("fs_read_time"), Bytes.toBytes(Long.toString(slowLogPayload.getFsReadTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("region_name"), Bytes.toBytes(slowLogPayload.getRegionName())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("response_size"), Bytes.toBytes(Long.toString(slowLogPayload.getResponseSize()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("block_bytes_scanned"), Bytes.toBytes(Long.toString(slowLogPayload.getBlockBytesScanned()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("server_class"), Bytes.toBytes(slowLogPayload.getServerClass())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("start_time"), Bytes.toBytes(Long.toString(slowLogPayload.getStartTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("type"), Bytes.toBytes(slowLogPayload.getType().name())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes("username"), Bytes.toBytes(slowLogPayload.getUserName()));
            puts.add(put);
        }
        try {
            SlowLogTableAccessor.doPut(connection, puts);
        }
        catch (Exception e) {
            LOG.warn("Failed to add slow/large log records to hbase:slowlog table.", (Throwable)e);
        }
    }

    private static byte[] getRowKey(TooSlowLog.SlowLogPayload slowLogPayload) {
        String hashcode;
        String lastFiveDig = hashcode.substring((hashcode = String.valueOf(slowLogPayload.hashCode())).length() > 5 ? hashcode.length() - 5 : 0);
        if (lastFiveDig.startsWith("-")) {
            lastFiveDig = String.valueOf(ThreadLocalRandom.current().nextInt(99999));
        }
        long currentTime = EnvironmentEdgeManager.currentTime();
        String timeAndHashcode = currentTime + lastFiveDig;
        long rowKeyLong = Long.parseLong(timeAndHashcode);
        return Bytes.toBytes(rowKeyLong);
    }
}

