/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.FileMetaInfo;
import org.apache.orc.OrcFile;

public class OrcNewSplit
extends FileSplit {
    private FileMetaInfo fileMetaInfo;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private final List<AcidInputFormat.DeltaMetaData> deltas = new ArrayList<AcidInputFormat.DeltaMetaData>();
    private OrcFile.WriterVersion writerVersion;

    protected OrcNewSplit() {
        super(null, 0L, 0L, null);
    }

    public OrcNewSplit(OrcSplit inner) throws IOException {
        super(inner.getPath(), inner.getStart(), inner.getLength(), inner.getLocations());
        this.fileMetaInfo = inner.getFileMetaInfo();
        this.hasFooter = inner.hasFooter();
        this.isOriginal = inner.isOriginal();
        this.hasBase = inner.hasBase();
        this.deltas.addAll(inner.getDeltas());
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (AcidInputFormat.DeltaMetaData delta : this.deltas) {
            delta.write(out);
        }
        if (this.hasFooter) {
            Text.writeString((DataOutput)out, (String)this.fileMetaInfo.compressionType);
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.bufferSize);
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.metadataSize);
            ByteBuffer footerBuff = this.fileMetaInfo.footerBuffer;
            footerBuff.reset();
            WritableUtils.writeVInt((DataOutput)out, (int)(footerBuff.limit() - footerBuff.position()));
            out.write(footerBuff.array(), footerBuff.position(), footerBuff.limit() - footerBuff.position());
            WritableUtils.writeVInt((DataOutput)out, (int)this.fileMetaInfo.writerVersion.getId());
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            AcidInputFormat.DeltaMetaData dmd = new AcidInputFormat.DeltaMetaData();
            dmd.readFields(in);
            this.deltas.add(dmd);
        }
        if (this.hasFooter) {
            String compressionType = Text.readString((DataInput)in);
            int bufferSize = WritableUtils.readVInt((DataInput)in);
            int metadataSize = WritableUtils.readVInt((DataInput)in);
            int footerBuffSize = WritableUtils.readVInt((DataInput)in);
            ByteBuffer footerBuff = ByteBuffer.allocate(footerBuffSize);
            in.readFully(footerBuff.array(), 0, footerBuffSize);
            OrcFile.WriterVersion writerVersion = ReaderImpl.getWriterVersion(WritableUtils.readVInt((DataInput)in));
            this.fileMetaInfo = new FileMetaInfo(compressionType, bufferSize, metadataSize, footerBuff, writerVersion);
        }
    }

    FileMetaInfo getFileMetaInfo() {
        return this.fileMetaInfo;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public List<AcidInputFormat.DeltaMetaData> getDeltas() {
        return this.deltas;
    }
}

