/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsOptimizer
extends Transform {
    private static final Logger Logger = LoggerFactory.getLogger(StatsOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (pctx.getFetchTask() != null || !pctx.getQueryProperties().isQuery() || pctx.getQueryProperties().isAnalyzeRewrite() || pctx.getQueryProperties().isCTAS() || pctx.getLoadFileWork().size() > 1 || !pctx.getLoadTableWork().isEmpty()) {
            return pctx;
        }
        String TS = TableScanOperator.getOperatorName() + "%";
        String GBY = GroupByOperator.getOperatorName() + "%";
        String RS = ReduceSinkOperator.getOperatorName() + "%";
        String SEL = SelectOperator.getOperatorName() + "%";
        String FS = FileSinkOperator.getOperatorName() + "%";
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TS + SEL + GBY + RS + GBY + SEL + FS), new MetaDataProcessor(pctx));
        opRules.put(new RuleRegExp("R2", TS + SEL + GBY + RS + GBY + FS), new MetaDataProcessor(pctx));
        StatsOptimizerProcContext soProcCtx = new StatsOptimizerProcContext();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, soProcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class MetaDataProcessor
    implements NodeProcessor {
        private final ParseContext pctx;

        public MetaDataProcessor(ParseContext pctx) {
            this.pctx = pctx;
        }

        private StatType getType(String origType) {
            if (serdeConstants.IntegralTypes.contains(origType)) {
                return StatType.Integeral;
            }
            if (origType.equals("double") || origType.equals("float")) {
                return StatType.Double;
            }
            if (origType.equals("binary")) {
                return StatType.Binary;
            }
            if (origType.equals("boolean")) {
                return StatType.Boolean;
            }
            if (origType.equals("string")) {
                return StatType.String;
            }
            return StatType.Unsupported;
        }

        private Long getNullcountFor(StatType type, ColumnStatisticsData statData) {
            switch (type) {
                case Integeral: {
                    return statData.getLongStats().getNumNulls();
                }
                case Double: {
                    return statData.getDoubleStats().getNumNulls();
                }
                case String: {
                    return statData.getStringStats().getNumNulls();
                }
                case Boolean: {
                    return statData.getBooleanStats().getNumNulls();
                }
                case Binary: {
                    return statData.getBinaryStats().getNumNulls();
                }
            }
            return null;
        }

        private boolean hasNullOrConstantGbyKey(GroupByOperator gbyOp) {
            GroupByDesc gbyDesc = (GroupByDesc)gbyOp.getConf();
            if (gbyDesc.getOutputColumnNames().size() == gbyDesc.getAggregators().size()) {
                return true;
            }
            for (ExprNodeDesc en : gbyDesc.getKeys()) {
                if (en instanceof ExprNodeConstantDesc) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            StatsOptimizerProcContext soProcCtx = (StatsOptimizerProcContext)procCtx;
            if (soProcCtx.stopProcess) {
                return null;
            }
            boolean isOptimized = false;
            try {
                FileSinkOperator fsOp;
                ExprNodeDesc desc;
                TableScanOperator tsOp = (TableScanOperator)stack.get(0);
                if (tsOp.getNumParent() > 0) {
                    Object var8_9 = null;
                    return var8_9;
                }
                SelectOperator pselOp = (SelectOperator)stack.get(1);
                for (ExprNodeDesc desc2 : ((SelectDesc)pselOp.getConf()).getColList()) {
                    if (desc2 instanceof ExprNodeColumnDesc || desc2 instanceof ExprNodeConstantDesc) continue;
                    Object var11_13 = null;
                    return var11_13;
                }
                Map<String, ExprNodeDesc> exprMap = pselOp.getColumnExprMap();
                GroupByOperator pgbyOp = (GroupByOperator)stack.get(2);
                if (!this.hasNullOrConstantGbyKey(pgbyOp)) {
                    Object var11_14 = null;
                    return var11_14;
                }
                ReduceSinkOperator rsOp = (ReduceSinkOperator)stack.get(3);
                if (((ReduceSinkDesc)rsOp.getConf()).getDistinctColumnIndices().size() > 0) {
                    Object var12_16 = null;
                    return var12_16;
                }
                GroupByOperator cgbyOp = (GroupByOperator)stack.get(4);
                if (!this.hasNullOrConstantGbyKey(cgbyOp)) {
                    Object var13_18 = null;
                    return var13_18;
                }
                Operator last = (Operator)stack.get(5);
                SelectOperator cselOp = null;
                HashMap<Integer, Object> posToConstant = new HashMap<Integer, Object>();
                if (last instanceof SelectOperator) {
                    cselOp = (SelectOperator)last;
                    if (!cselOp.isIdentitySelect()) {
                        for (int pos = 0; pos < ((SelectDesc)cselOp.getConf()).getColList().size(); ++pos) {
                            desc = ((SelectDesc)cselOp.getConf()).getColList().get(pos);
                            if (desc instanceof ExprNodeConstantDesc) {
                                posToConstant.put(pos, ((ExprNodeConstantDesc)desc).getValue());
                                continue;
                            }
                            if (desc instanceof ExprNodeColumnDesc) continue;
                            Object var18_25 = null;
                            return var18_25;
                        }
                    }
                    last = (Operator)stack.get(6);
                }
                if ((fsOp = (FileSinkOperator)last).getNumChild() > 0) {
                    desc = null;
                    return desc;
                }
                Table tbl = ((TableScanDesc)tsOp.getConf()).getTableMetadata();
                ArrayList<Object> oneRow = new ArrayList<Object>();
                Hive hive = Hive.get(this.pctx.getConf());
                for (AggregationDesc aggr : ((GroupByDesc)pgbyOp.getConf()).getAggregators()) {
                    DoubleColumnStatsData dstats;
                    long curVal;
                    LongColumnStatsData lstats;
                    ColumnStatisticsData statData;
                    Collection<List<ColumnStatisticsObj>> result;
                    Enum subType;
                    String name;
                    Set<Partition> parts;
                    StatType type;
                    String colName;
                    Object colDesc;
                    Iterator<List<ColumnStatisticsObj>> iterator;
                    Set<Partition> parts2;
                    Object var28_43;
                    StatType type2;
                    Object var27_42;
                    PrimitiveObjectInspector.PrimitiveCategory category;
                    if (aggr.getDistinct()) {
                        Object var22_30 = null;
                        return var22_30;
                    }
                    GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(aggr.getGenericUDAFName());
                    if (udaf instanceof GenericUDAFSum) {
                        String constant;
                        ExprNodeDesc desc3 = aggr.getParameters().get(0);
                        category = GenericUDAFSum.getReturnType(desc3.getTypeInfo());
                        if (category == null) {
                            Object var25_36 = null;
                            return var25_36;
                        }
                        if (desc3 instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)desc3).getValue().toString();
                        } else if (desc3 instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)desc3).getColumn()) instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)desc3).getColumn())).getValue().toString();
                        } else {
                            Object var26_41 = null;
                            return var26_41;
                        }
                        Long rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                        if (rowCnt == null) {
                            var27_42 = null;
                            return var27_42;
                        }
                        switch (category) {
                            case LONG: {
                                oneRow.add(Long.valueOf(constant) * rowCnt);
                                break;
                            }
                            case DOUBLE: {
                                oneRow.add(Double.valueOf(constant) * (double)rowCnt.longValue());
                                break;
                            }
                            case DECIMAL: {
                                oneRow.add(HiveDecimal.create(constant).multiply(HiveDecimal.create(rowCnt)));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("never");
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFCount) {
                        Long rowCnt = 0L;
                        if (aggr.getParameters().isEmpty() || aggr.getParameters().get(0) instanceof ExprNodeConstantDesc || aggr.getParameters().get(0) instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn()) instanceof ExprNodeConstantDesc) {
                            rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                            if (rowCnt == null) {
                                category = null;
                                return category;
                            }
                        } else {
                            ExprNodeColumnDesc desc4 = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                            String colName2 = desc4.getColumn();
                            type2 = this.getType(desc4.getTypeString());
                            if (!tbl.isPartitioned()) {
                                if (!StatsSetupConst.areBasicStatsUptoDate(tbl.getParameters())) {
                                    Logger.debug("Stats for table : " + tbl.getTableName() + " are not up to date.");
                                    var27_42 = null;
                                    return var27_42;
                                }
                                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                                if (rowCnt == null) {
                                    Logger.debug("Table doesn't have up to date stats " + tbl.getTableName());
                                    var27_42 = null;
                                    return var27_42;
                                }
                                if (!StatsSetupConst.areColumnStatsUptoDate(tbl.getParameters(), colName2)) {
                                    Logger.debug("Stats for table : " + tbl.getTableName() + " column " + colName2 + " are not up to date.");
                                    var27_42 = null;
                                    return var27_42;
                                }
                                List<ColumnStatisticsObj> stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName2));
                                if (stats.isEmpty()) {
                                    Logger.debug("No stats for " + tbl.getTableName() + " column " + colName2);
                                    var28_43 = null;
                                    return var28_43;
                                }
                                Long nullCnt = this.getNullcountFor(type2, stats.get(0).getStatsData());
                                if (null == nullCnt) {
                                    Logger.debug("Unsupported type: " + desc4.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName2);
                                    Object var29_45 = null;
                                    return var29_45;
                                }
                                rowCnt = rowCnt - nullCnt;
                            } else {
                                parts2 = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                                for (Partition partition : parts2) {
                                    if (!StatsSetupConst.areBasicStatsUptoDate(partition.getParameters())) {
                                        Logger.debug("Stats for part : " + partition.getSpec() + " are not up to date.");
                                        Object var30_71 = null;
                                        return var30_71;
                                    }
                                    Long partRowCnt = Long.parseLong(partition.getParameters().get("numRows"));
                                    if (partRowCnt == null) {
                                        Logger.debug("Partition doesn't have up to date stats " + partition.getSpec());
                                        iterator = null;
                                        return iterator;
                                    }
                                    rowCnt = rowCnt + partRowCnt;
                                }
                                Collection<List<ColumnStatisticsObj>> result2 = this.verifyAndGetPartColumnStats(hive, tbl, colName2, parts2);
                                if (result2 == null) {
                                    Object var29_48 = null;
                                    return var29_48;
                                }
                                for (List<ColumnStatisticsObj> statObj : result2) {
                                    ColumnStatisticsData statData2 = this.validateSingleColStat(statObj);
                                    if (statData2 == null) {
                                        Object var32_73 = null;
                                        return var32_73;
                                    }
                                    Long nullCnt = this.getNullcountFor(type2, statData2);
                                    if (nullCnt == null) {
                                        Logger.debug("Unsupported type: " + desc4.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName2);
                                        Object var33_74 = null;
                                        return var33_74;
                                    }
                                    rowCnt = rowCnt - nullCnt;
                                }
                            }
                        }
                        oneRow.add(rowCnt);
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMax) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = ((ExprNodeColumnDesc)colDesc).getColumn();
                        type = this.getType(((ExprNodeDesc)colDesc).getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areColumnStatsUptoDate(tbl.getParameters(), colName)) {
                                Logger.debug("Stats for table : " + tbl.getTableName() + " column " + colName + " are not up to date.");
                                type2 = null;
                                return type2;
                            }
                            List<ColumnStatisticsObj> stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName));
                            if (stats.isEmpty()) {
                                Logger.debug("No stats for " + tbl.getTableName() + " column " + colName);
                                parts2 = null;
                                return parts2;
                            }
                            ColumnStatisticsData statData3 = stats.get(0).getStatsData();
                            String name2 = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                            switch (type) {
                                case Integeral: {
                                    LongSubType longSubType = LongSubType.valueOf(name2);
                                    LongColumnStatsData lstats2 = statData3.getLongStats();
                                    if (lstats2.isSetHighValue()) {
                                        oneRow.add(longSubType.cast(lstats2.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    DoubleSubType doubleSubType = DoubleSubType.valueOf(name2);
                                    DoubleColumnStatsData dstats2 = statData3.getDoubleStats();
                                    if (dstats2.isSetHighValue()) {
                                        oneRow.add(doubleSubType.cast(dstats2.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                    Object var29_52 = null;
                                    return var29_52;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                        switch (type) {
                            case Integeral: {
                                void var29_55;
                                subType = LongSubType.valueOf(name);
                                Object var29_54 = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        Object var34_75 = null;
                                        return var34_75;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetHighValue()) continue;
                                    curVal = lstats.getHighValue();
                                    Long l = var29_55 == null ? curVal : Math.max(var29_55.longValue(), curVal);
                                }
                                if (var29_55 != null) {
                                    oneRow.add(((LongSubType)subType).cast(var29_55.longValue()));
                                    break;
                                }
                                oneRow.add(var29_55);
                                break;
                            }
                            case Double: {
                                void var29_58;
                                subType = DoubleSubType.valueOf(name);
                                Object var29_57 = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        lstats = null;
                                        return lstats;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetHighValue()) continue;
                                    double curVal2 = statData.getDoubleStats().getHighValue();
                                    Double d = var29_58 == null ? curVal2 : Math.max(var29_58.doubleValue(), curVal2);
                                }
                                if (var29_58 != null) {
                                    oneRow.add(((DoubleSubType)subType).cast(var29_58.doubleValue()));
                                    break;
                                }
                                oneRow.add(null);
                                break;
                            }
                            default: {
                                Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                subType = null;
                                return subType;
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMin) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = ((ExprNodeColumnDesc)colDesc).getColumn();
                        type = this.getType(((ExprNodeDesc)colDesc).getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areColumnStatsUptoDate(tbl.getParameters(), colName)) {
                                Logger.debug("Stats for table : " + tbl.getTableName() + " column " + colName + " are not up to date.");
                                parts = null;
                                return parts;
                            }
                            ColumnStatisticsData statData4 = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName)).get(0).getStatsData();
                            name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                            switch (type) {
                                case Integeral: {
                                    subType = LongSubType.valueOf(name);
                                    LongColumnStatsData longColumnStatsData = statData4.getLongStats();
                                    if (longColumnStatsData.isSetLowValue()) {
                                        oneRow.add(((LongSubType)subType).cast(longColumnStatsData.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    subType = DoubleSubType.valueOf(name);
                                    DoubleColumnStatsData doubleColumnStatsData = statData4.getDoubleStats();
                                    if (doubleColumnStatsData.isSetLowValue()) {
                                        oneRow.add(((DoubleSubType)subType).cast(doubleColumnStatsData.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                    subType = null;
                                    return subType;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                        switch (type) {
                            case Integeral: {
                                void var29_65;
                                subType = LongSubType.valueOf(name);
                                Object var29_64 = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        dstats = null;
                                        return dstats;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetLowValue()) continue;
                                    curVal = lstats.getLowValue();
                                    Long l = var29_65 == null ? curVal : Math.min(var29_65.longValue(), curVal);
                                }
                                if (var29_65 != null) {
                                    oneRow.add(((LongSubType)subType).cast(var29_65.longValue()));
                                    break;
                                }
                                oneRow.add(var29_65);
                                break;
                            }
                            case Double: {
                                void var29_68;
                                subType = DoubleSubType.valueOf(name);
                                Object var29_67 = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        lstats = null;
                                        return lstats;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetLowValue()) continue;
                                    double curVal3 = statData.getDoubleStats().getLowValue();
                                    Double d = var29_68 == null ? curVal3 : Math.min(var29_68.doubleValue(), curVal3);
                                }
                                if (var29_68 != null) {
                                    oneRow.add(((DoubleSubType)subType).cast(var29_68.doubleValue()));
                                    break;
                                }
                                oneRow.add(var29_68);
                                break;
                            }
                            default: {
                                Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                var28_43 = null;
                                return var28_43;
                            }
                        }
                        continue;
                    }
                    Logger.debug("Unsupported aggregation for metadata optimizer: " + aggr.getGenericUDAFName());
                    colDesc = null;
                    return colDesc;
                }
                ArrayList<List<Object>> allRows = new ArrayList<List<Object>>();
                ArrayList<String> colNames = new ArrayList<String>();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                if (cselOp == null) {
                    allRows.add(oneRow);
                    for (ColumnInfo colInfo : cgbyOp.getSchema().getSignature()) {
                        colNames.add(colInfo.getInternalName());
                        ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(colInfo.getType()));
                    }
                } else {
                    int aggrPos = 0;
                    ArrayList<Object> oneRowWithConstant = new ArrayList<Object>();
                    for (int pos = 0; pos < cselOp.getSchema().getSignature().size(); ++pos) {
                        if (posToConstant.containsKey(pos)) {
                            oneRowWithConstant.add(posToConstant.get(pos));
                        } else {
                            oneRowWithConstant.add(oneRow.get(aggrPos++));
                        }
                        ColumnInfo colInfo = cselOp.getSchema().getSignature().get(pos);
                        colNames.add(colInfo.getInternalName());
                        ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(colInfo.getType()));
                    }
                    allRows.add(oneRowWithConstant);
                }
                FetchWork fWork = null;
                FetchTask fTask = this.pctx.getFetchTask();
                if (fTask != null) {
                    fWork = (FetchWork)fTask.getWork();
                    fWork.getRowsComputedUsingStats().addAll(allRows);
                } else {
                    StandardStructObjectInspector sOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, ois);
                    fWork = new FetchWork(allRows, sOI);
                    fTask = (FetchTask)TaskFactory.get(fWork, this.pctx.getConf(), new Task[0]);
                    this.pctx.setFetchTask(fTask);
                }
                fWork.setLimit(fWork.getRowsComputedUsingStats().size());
                isOptimized = true;
                Object var25_40 = null;
                return var25_40;
            }
            catch (Exception e) {
                Logger.debug("Failed to optimize using metadata optimizer", (Throwable)e);
                Object var8_10 = null;
                return var8_10;
            }
            finally {
                if (!isOptimized) {
                    soProcCtx.stopProcess = true;
                    this.pctx.setFetchTask(null);
                }
            }
        }

        private ColumnStatisticsData validateSingleColStat(List<ColumnStatisticsObj> statObj) {
            if (statObj.size() > 1) {
                Logger.error("More than one stat for a single column!");
                return null;
            }
            if (statObj.isEmpty()) {
                Logger.debug("No stats for some partition and column");
                return null;
            }
            return statObj.get(0).getStatsData();
        }

        private Collection<List<ColumnStatisticsObj>> verifyAndGetPartColumnStats(Hive hive, Table tbl, String colName, Set<Partition> parts) throws TException {
            ArrayList<String> partNames = new ArrayList<String>(parts.size());
            for (Partition part : parts) {
                if (!StatsSetupConst.areColumnStatsUptoDate(part.getParameters(), colName)) {
                    Logger.debug("Stats for part : " + part.getSpec() + " column " + colName + " are not up to date.");
                    return null;
                }
                partNames.add(part.getName());
            }
            Map<String, List<ColumnStatisticsObj>> result = hive.getMSC().getPartitionColumnStatistics(tbl.getDbName(), tbl.getTableName(), partNames, Lists.newArrayList(colName));
            if (result.size() != parts.size()) {
                Logger.debug("Received " + result.size() + " stats for " + parts.size() + " partitions");
                return null;
            }
            return result.values();
        }

        private Long getRowCnt(ParseContext pCtx, TableScanOperator tsOp, Table tbl) throws HiveException {
            Long rowCnt = 0L;
            if (tbl.isPartitioned()) {
                for (Partition part : this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions()) {
                    if (!StatsSetupConst.areBasicStatsUptoDate(part.getParameters())) {
                        return null;
                    }
                    Long partRowCnt = Long.parseLong(part.getParameters().get("numRows"));
                    if (partRowCnt == null) {
                        Logger.debug("Partition doesn't have up to date stats " + part.getSpec());
                        return null;
                    }
                    rowCnt = rowCnt + partRowCnt;
                }
            } else {
                if (!StatsSetupConst.areBasicStatsUptoDate(tbl.getParameters())) {
                    return null;
                }
                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                if (rowCnt == null) {
                    Logger.debug("Table doesn't have up to date stats " + tbl.getTableName());
                    rowCnt = null;
                }
            }
            return rowCnt;
        }

        static enum DoubleSubType {
            DOUBLE{

                @Override
                Object cast(double doubleValue) {
                    return doubleValue;
                }
            }
            ,
            FLOAT{

                @Override
                Object cast(double doubleValue) {
                    return Float.valueOf((float)doubleValue);
                }
            };


            abstract Object cast(double var1);
        }

        static enum LongSubType {
            BIGINT{

                @Override
                Object cast(long longValue) {
                    return longValue;
                }
            }
            ,
            INT{

                @Override
                Object cast(long longValue) {
                    return (int)longValue;
                }
            }
            ,
            SMALLINT{

                @Override
                Object cast(long longValue) {
                    return (short)longValue;
                }
            }
            ,
            TINYINT{

                @Override
                Object cast(long longValue) {
                    return (byte)longValue;
                }
            };


            abstract Object cast(long var1);
        }

        static enum StatType {
            Integeral,
            Double,
            String,
            Boolean,
            Binary,
            Unsupported;

        }
    }

    private static class StatsOptimizerProcContext
    implements NodeProcessorCtx {
        boolean stopProcess = false;

        private StatsOptimizerProcContext() {
        }
    }
}

