/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class HiveDecimalWritable
implements WritableComparable<HiveDecimalWritable> {
    private byte[] internalStorage = new byte[0];
    private int scale;

    public HiveDecimalWritable() {
    }

    public HiveDecimalWritable(String value) {
        this.set(HiveDecimal.create(value));
    }

    public HiveDecimalWritable(byte[] bytes, int scale) {
        this.set(bytes, scale);
    }

    public HiveDecimalWritable(HiveDecimalWritable writable) {
        this.set(writable.getHiveDecimal());
    }

    public HiveDecimalWritable(HiveDecimal value) {
        this.set(value);
    }

    public HiveDecimalWritable(long value) {
        this.set(HiveDecimal.create(value));
    }

    public void set(HiveDecimal value) {
        this.set(value.unscaledValue().toByteArray(), value.scale());
    }

    public void set(HiveDecimal value, int maxPrecision, int maxScale) {
        this.set(HiveDecimal.enforcePrecisionScale(value, maxPrecision, maxScale));
    }

    public void set(HiveDecimalWritable writable) {
        this.set(writable.getHiveDecimal());
    }

    public void set(byte[] bytes, int scale) {
        this.internalStorage = bytes;
        this.scale = scale;
    }

    public HiveDecimal getHiveDecimal() {
        return HiveDecimal.create(new BigInteger(this.internalStorage), this.scale);
    }

    public HiveDecimal getHiveDecimal(int maxPrecision, int maxScale) {
        return HiveDecimal.enforcePrecisionScale(HiveDecimal.create(new BigInteger(this.internalStorage), this.scale), maxPrecision, maxScale);
    }

    public void readFields(DataInput in) throws IOException {
        this.scale = WritableUtils.readVInt((DataInput)in);
        int byteArrayLen = WritableUtils.readVInt((DataInput)in);
        if (this.internalStorage.length != byteArrayLen) {
            this.internalStorage = new byte[byteArrayLen];
        }
        in.readFully(this.internalStorage);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.scale);
        WritableUtils.writeVInt((DataOutput)out, (int)this.internalStorage.length);
        out.write(this.internalStorage);
    }

    public int compareTo(HiveDecimalWritable that) {
        return this.getHiveDecimal().compareTo(that.getHiveDecimal());
    }

    public String toString() {
        return this.getHiveDecimal().toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HiveDecimalWritable bdw = (HiveDecimalWritable)other;
        return this.getHiveDecimal().compareTo(bdw.getHiveDecimal()) == 0;
    }

    public int hashCode() {
        return this.getHiveDecimal().hashCode();
    }

    public byte[] getInternalStorage() {
        return this.internalStorage;
    }

    public int getScale() {
        return this.scale;
    }

    public static HiveDecimalWritable enforcePrecisionScale(HiveDecimalWritable writable, int precision, int scale) {
        if (writable == null) {
            return null;
        }
        HiveDecimal dec = HiveDecimal.enforcePrecisionScale(writable.getHiveDecimal(), precision, scale);
        return dec == null ? null : new HiveDecimalWritable(dec);
    }
}

