/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkCommonOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hive.com.google.common.base.Preconditions;

public class VectorReduceSinkObjectHashOperator
extends VectorReduceSinkCommonOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkObjectHashOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected int[] reduceSinkBucketColumnMap;
    protected TypeInfo[] reduceSinkBucketTypeInfos;
    protected VectorExpression[] reduceSinkBucketExpressions;
    protected int[] reduceSinkPartitionColumnMap;
    protected TypeInfo[] reduceSinkPartitionTypeInfos;
    protected VectorExpression[] reduceSinkPartitionExpressions;
    protected transient ByteStream.Output keyOutput;
    protected transient VectorSerializeRow<BinarySortableSerializeWrite> keyVectorSerializeRow;
    private transient boolean hasBuckets;
    private transient int numBuckets;
    private transient ObjectInspector[] bucketObjectInspectors;
    private transient VectorExtractRow bucketVectorExtractRow;
    private transient Object[] bucketFieldValues;
    private transient boolean isPartitioned;
    private transient ObjectInspector[] partitionObjectInspectors;
    private transient VectorExtractRow partitionVectorExtractRow;
    private transient Object[] partitionFieldValues;
    private transient Random nonPartitionRandom;

    protected VectorReduceSinkObjectHashOperator() {
    }

    public VectorReduceSinkObjectHashOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkObjectHashOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx, vContext, conf);
        LOG.info((Object)("VectorReduceSinkObjectHashOperator constructor vectorReduceSinkInfo " + this.vectorReduceSinkInfo));
        Preconditions.checkState(!this.vectorReduceSinkInfo.getUseUniformHash());
        this.reduceSinkBucketColumnMap = this.vectorReduceSinkInfo.getReduceSinkBucketColumnMap();
        this.reduceSinkBucketTypeInfos = this.vectorReduceSinkInfo.getReduceSinkBucketTypeInfos();
        this.reduceSinkBucketExpressions = this.vectorReduceSinkInfo.getReduceSinkBucketExpressions();
        this.reduceSinkPartitionColumnMap = this.vectorReduceSinkInfo.getReduceSinkPartitionColumnMap();
        this.reduceSinkPartitionTypeInfos = this.vectorReduceSinkInfo.getReduceSinkPartitionTypeInfos();
        this.reduceSinkPartitionExpressions = this.vectorReduceSinkInfo.getReduceSinkPartitionExpressions();
    }

    private ObjectInspector[] getObjectInspectorArray(TypeInfo[] typeInfos) {
        int size = typeInfos.length;
        ObjectInspector[] objectInspectors = new ObjectInspector[size];
        for (int i = 0; i < size; ++i) {
            ObjectInspector standardWritableObjectInspector;
            TypeInfo typeInfo = typeInfos[i];
            objectInspectors[i] = standardWritableObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
        }
        return objectInspectors;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.keyOutput = new ByteStream.Output();
        this.keyBinarySortableSerializeWrite.set(this.keyOutput);
        this.keyVectorSerializeRow = new VectorSerializeRow<BinarySortableSerializeWrite>(this.keyBinarySortableSerializeWrite);
        this.keyVectorSerializeRow.init(this.reduceSinkKeyTypeInfos, this.reduceSinkKeyColumnMap);
        this.hasBuckets = false;
        this.isPartitioned = false;
        this.numBuckets = 0;
        this.numBuckets = ((ReduceSinkDesc)this.conf).getNumBuckets();
        boolean bl = this.hasBuckets = this.numBuckets > 0;
        if (this.hasBuckets) {
            this.bucketObjectInspectors = this.getObjectInspectorArray(this.reduceSinkBucketTypeInfos);
            this.bucketVectorExtractRow = new VectorExtractRow();
            this.bucketVectorExtractRow.init(this.reduceSinkBucketTypeInfos, this.reduceSinkBucketColumnMap);
            this.bucketFieldValues = new Object[this.reduceSinkBucketTypeInfos.length];
        }
        boolean bl2 = this.isPartitioned = ((ReduceSinkDesc)this.conf).getPartitionCols() != null;
        if (!this.isPartitioned) {
            this.nonPartitionRandom = new Random(12345L);
        } else {
            this.partitionObjectInspectors = this.getObjectInspectorArray(this.reduceSinkPartitionTypeInfos);
            LOG.debug((Object)("*NEW* partitionObjectInspectors " + Arrays.toString(this.partitionObjectInspectors)));
            this.partitionVectorExtractRow = new VectorExtractRow();
            this.partitionVectorExtractRow.init(this.reduceSinkPartitionTypeInfos, this.reduceSinkPartitionColumnMap);
            this.partitionFieldValues = new Object[this.reduceSinkPartitionTypeInfos.length];
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            ++this.batchCounter;
            if (batch.size == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.reduceSinkKeyExpressions != null) {
                for (VectorExpression ve : this.reduceSinkKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkValueExpressions != null) {
                for (VectorExpression ve : this.reduceSinkValueExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkBucketExpressions != null) {
                for (VectorExpression ve : this.reduceSinkBucketExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkPartitionExpressions != null) {
                for (VectorExpression ve : this.reduceSinkPartitionExpressions) {
                    ve.evaluate(batch);
                }
            }
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            int size = batch.size;
            for (int logical = 0; logical < size; ++logical) {
                int hashCode;
                int batchIndex;
                int n = batchIndex = selectedInUse ? selected[logical] : logical;
                if (!this.hasBuckets) {
                    if (!this.isPartitioned) {
                        hashCode = this.nonPartitionRandom.nextInt();
                    } else {
                        this.partitionVectorExtractRow.extractRow(batch, batchIndex, this.partitionFieldValues);
                        hashCode = ObjectInspectorUtils.getBucketHashCode(this.partitionFieldValues, this.partitionObjectInspectors);
                    }
                } else {
                    this.bucketVectorExtractRow.extractRow(batch, batchIndex, this.bucketFieldValues);
                    int bucketNum = ObjectInspectorUtils.getBucketNumber(this.bucketFieldValues, this.bucketObjectInspectors, this.numBuckets);
                    if (!this.isPartitioned) {
                        hashCode = this.nonPartitionRandom.nextInt() * 31 + bucketNum;
                    } else {
                        this.partitionVectorExtractRow.extractRow(batch, batchIndex, this.partitionFieldValues);
                        hashCode = ObjectInspectorUtils.getBucketHashCode(this.partitionFieldValues, this.partitionObjectInspectors) * 31 + bucketNum;
                    }
                }
                this.keyBinarySortableSerializeWrite.reset();
                this.keyVectorSerializeRow.serializeWrite(batch, batchIndex);
                int keyLength = this.keyOutput.getLength();
                if (tag == -1 || this.reduceSkipTag) {
                    this.keyWritable.set(this.keyOutput.getData(), 0, keyLength);
                } else {
                    this.keyWritable.setSize(keyLength + 1);
                    System.arraycopy(this.keyOutput.getData(), 0, this.keyWritable.get(), 0, keyLength);
                    this.keyWritable.get()[keyLength] = this.reduceTagByte;
                }
                this.keyWritable.setDistKeyLength(keyLength);
                this.keyWritable.setHashCode(hashCode);
                this.valueLazyBinarySerializeWrite.reset();
                this.valueVectorSerializeRow.serializeWrite(batch, batchIndex);
                this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
                this.collect(this.keyWritable, (Writable)this.valueBytesWritable);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

