/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveAlgorithmsConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class HiveAlgorithmsUtil {
    private final double cpuCost;
    private final double netCost;
    private final double localFSWrite;
    private final double localFSRead;
    private final double hdfsWrite;
    private final double hdfsRead;

    HiveAlgorithmsUtil(HiveConf conf) {
        this.cpuCost = Double.parseDouble(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_CBO_COST_MODEL_CPU));
        this.netCost = this.cpuCost * Double.parseDouble(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_CBO_COST_MODEL_NET));
        this.localFSWrite = this.netCost * Double.parseDouble(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_CBO_COST_MODEL_LFS_WRITE));
        this.localFSRead = this.netCost * Double.parseDouble(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_CBO_COST_MODEL_LFS_READ));
        this.hdfsWrite = this.localFSWrite * Double.parseDouble(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_CBO_COST_MODEL_HDFS_WRITE));
        this.hdfsRead = this.localFSRead * Double.parseDouble(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_CBO_COST_MODEL_HDFS_READ));
    }

    public static RelOptCost computeCardinalityBasedCost(HiveRelNode hr) {
        return new HiveCost(hr.getRows(), 0.0, 0.0);
    }

    public HiveCost computeScanCost(double cardinality, double avgTupleSize) {
        return new HiveCost(cardinality, 0.0, this.hdfsRead * cardinality * avgTupleSize);
    }

    public double computeSortMergeCPUCost(ImmutableList<Double> cardinalities, ImmutableBitSet sorted) {
        double cpuCost = 0.0;
        for (int i = 0; i < cardinalities.size(); ++i) {
            double cardinality = (Double)cardinalities.get(i);
            if (!sorted.get(i)) {
                cpuCost += this.computeSortCPUCost(cardinality);
            }
            cpuCost += cardinality * cpuCost;
        }
        return cpuCost;
    }

    public double computeSortCPUCost(Double cardinality) {
        return cardinality * Math.log(cardinality) * this.cpuCost;
    }

    public double computeSortMergeIOCost(ImmutableList<Pair<Double, Double>> relationInfos) {
        double ioCost = 0.0;
        for (Pair pair : relationInfos) {
            ioCost += this.computeSortIOCost(pair);
        }
        return ioCost;
    }

    public double computeSortIOCost(Pair<Double, Double> relationInfo) {
        double ioCost = 0.0;
        double cardinality = (Double)relationInfo.left;
        double averageTupleSize = (Double)relationInfo.right;
        ioCost += cardinality * averageTupleSize * this.localFSWrite;
        ioCost += cardinality * averageTupleSize * this.localFSRead;
        return ioCost += cardinality * averageTupleSize * this.netCost;
    }

    public static double computeMapJoinCPUCost(ImmutableList<Double> cardinalities, ImmutableBitSet streaming) {
        double cpuCost = 0.0;
        for (int i = 0; i < cardinalities.size(); ++i) {
            double cardinality = (Double)cardinalities.get(i);
            if (!streaming.get(i)) {
                cpuCost += cardinality;
            }
            cpuCost += cardinality * cpuCost;
        }
        return cpuCost;
    }

    public double computeMapJoinIOCost(ImmutableList<Pair<Double, Double>> relationInfos, ImmutableBitSet streaming, int parallelism) {
        double ioCost = 0.0;
        for (int i = 0; i < relationInfos.size(); ++i) {
            double cardinality = (Double)((Pair)relationInfos.get((int)i)).left;
            double averageTupleSize = (Double)((Pair)relationInfos.get((int)i)).right;
            if (streaming.get(i)) continue;
            ioCost += cardinality * averageTupleSize * this.netCost * (double)parallelism;
        }
        return ioCost;
    }

    public double computeBucketMapJoinCPUCost(ImmutableList<Double> cardinalities, ImmutableBitSet streaming) {
        double cpuCost = 0.0;
        for (int i = 0; i < cardinalities.size(); ++i) {
            double cardinality = (Double)cardinalities.get(i);
            if (!streaming.get(i)) {
                cpuCost += cardinality * cpuCost;
            }
            cpuCost += cardinality * cpuCost;
        }
        return cpuCost;
    }

    public double computeBucketMapJoinIOCost(ImmutableList<Pair<Double, Double>> relationInfos, ImmutableBitSet streaming, int parallelism) {
        double ioCost = 0.0;
        for (int i = 0; i < relationInfos.size(); ++i) {
            double cardinality = (Double)((Pair)relationInfos.get((int)i)).left;
            double averageTupleSize = (Double)((Pair)relationInfos.get((int)i)).right;
            if (streaming.get(i)) continue;
            ioCost += cardinality * averageTupleSize * this.netCost * (double)parallelism;
        }
        return ioCost;
    }

    public static double computeSMBMapJoinCPUCost(ImmutableList<Double> cardinalities) {
        double cpuCost = 0.0;
        for (int i = 0; i < cardinalities.size(); ++i) {
            cpuCost += (Double)cardinalities.get(i) * cpuCost;
        }
        return cpuCost;
    }

    public double computeSMBMapJoinIOCost(ImmutableList<Pair<Double, Double>> relationInfos, ImmutableBitSet streaming, int parallelism) {
        double ioCost = 0.0;
        for (int i = 0; i < relationInfos.size(); ++i) {
            double cardinality = (Double)((Pair)relationInfos.get((int)i)).left;
            double averageTupleSize = (Double)((Pair)relationInfos.get((int)i)).right;
            if (streaming.get(i)) continue;
            ioCost += cardinality * averageTupleSize * this.netCost * (double)parallelism;
        }
        return ioCost;
    }

    public static boolean isFittingIntoMemory(Double maxSize, RelNode input, int buckets) {
        Double currentMemory = RelMetadataQuery.instance().cumulativeMemoryWithinPhase(input);
        if (currentMemory != null) {
            return !(currentMemory / (double)buckets > maxSize);
        }
        return false;
    }

    public static ImmutableList<RelCollation> getJoinCollation(HiveCalciteUtil.JoinPredicateInfo joinPredInfo, HiveJoin.MapJoinStreamingRelation streamingRelation) {
        ImmutableList<RelCollation> collation;
        ImmutableList.Builder collationListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder leftCollationListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder rightCollationListBuilder = new ImmutableList.Builder();
        for (int i = 0; i < joinPredInfo.getEquiJoinPredicateElements().size(); ++i) {
            HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(i);
            for (int leftPos : joinLeafPredInfo.getProjsFromLeftPartOfJoinKeysInJoinSchema()) {
                RelFieldCollation leftFieldCollation = new RelFieldCollation(leftPos);
                collationListBuilder.add(leftFieldCollation);
                leftCollationListBuilder.add(leftFieldCollation);
            }
            for (int rightPos : joinLeafPredInfo.getProjsFromRightPartOfJoinKeysInJoinSchema()) {
                RelFieldCollation rightFieldCollation = new RelFieldCollation(rightPos);
                collationListBuilder.add(rightFieldCollation);
                rightCollationListBuilder.add(rightFieldCollation);
            }
        }
        switch (streamingRelation) {
            case LEFT_RELATION: {
                collation = ImmutableList.of(RelCollationTraitDef.INSTANCE.canonize(new HiveRelCollation((ImmutableList<RelFieldCollation>)leftCollationListBuilder.build())));
                break;
            }
            case RIGHT_RELATION: {
                collation = ImmutableList.of(RelCollationTraitDef.INSTANCE.canonize(new HiveRelCollation((ImmutableList<RelFieldCollation>)rightCollationListBuilder.build())));
                break;
            }
            default: {
                collation = ImmutableList.of(RelCollationTraitDef.INSTANCE.canonize(new HiveRelCollation((ImmutableList<RelFieldCollation>)collationListBuilder.build())));
            }
        }
        return collation;
    }

    public static RelDistribution getJoinRedistribution(HiveCalciteUtil.JoinPredicateInfo joinPredInfo) {
        ImmutableList.Builder keysListBuilder = new ImmutableList.Builder();
        for (int i = 0; i < joinPredInfo.getEquiJoinPredicateElements().size(); ++i) {
            HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(i);
            for (int leftPos : joinLeafPredInfo.getProjsFromLeftPartOfJoinKeysInJoinSchema()) {
                keysListBuilder.add((Object)leftPos);
            }
            for (int rightPos : joinLeafPredInfo.getProjsFromRightPartOfJoinKeysInJoinSchema()) {
                keysListBuilder.add((Object)rightPos);
            }
        }
        return new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, (List<Integer>)((Object)keysListBuilder.build()));
    }

    public static RelDistribution getJoinDistribution(HiveCalciteUtil.JoinPredicateInfo joinPredInfo, HiveJoin.MapJoinStreamingRelation streamingRelation) {
        ImmutableList.Builder leftKeysListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder rightKeysListBuilder = new ImmutableList.Builder();
        for (int i = 0; i < joinPredInfo.getEquiJoinPredicateElements().size(); ++i) {
            HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(i);
            for (int leftPos : joinLeafPredInfo.getProjsFromLeftPartOfJoinKeysInJoinSchema()) {
                leftKeysListBuilder.add((Object)leftPos);
            }
            for (int rightPos : joinLeafPredInfo.getProjsFromRightPartOfJoinKeysInJoinSchema()) {
                rightKeysListBuilder.add((Object)rightPos);
            }
        }
        HiveRelDistribution distribution = null;
        if (streamingRelation == HiveJoin.MapJoinStreamingRelation.LEFT_RELATION) {
            distribution = new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, (List<Integer>)((Object)leftKeysListBuilder.build()));
        } else if (streamingRelation == HiveJoin.MapJoinStreamingRelation.RIGHT_RELATION) {
            distribution = new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, (List<Integer>)((Object)rightKeysListBuilder.build()));
        }
        return distribution;
    }

    public static Double getJoinMemory(HiveJoin join) {
        return HiveAlgorithmsUtil.getJoinMemory(join, join.getStreamingSide());
    }

    public static Double getJoinMemory(HiveJoin join, HiveJoin.MapJoinStreamingRelation streamingSide) {
        Double memory = 0.0;
        RelMetadataQuery mq = RelMetadataQuery.instance();
        if (streamingSide == HiveJoin.MapJoinStreamingRelation.NONE || streamingSide == HiveJoin.MapJoinStreamingRelation.RIGHT_RELATION) {
            Double leftAvgRowSize = mq.getAverageRowSize(join.getLeft());
            Double leftRowCount = mq.getRowCount(join.getLeft());
            if (leftAvgRowSize == null || leftRowCount == null) {
                return null;
            }
            memory = memory + leftAvgRowSize * leftRowCount;
        }
        if (streamingSide == HiveJoin.MapJoinStreamingRelation.NONE || streamingSide == HiveJoin.MapJoinStreamingRelation.LEFT_RELATION) {
            Double rightAvgRowSize = mq.getAverageRowSize(join.getRight());
            Double rightRowCount = mq.getRowCount(join.getRight());
            if (rightAvgRowSize == null || rightRowCount == null) {
                return null;
            }
            memory = memory + rightAvgRowSize * rightRowCount;
        }
        return memory;
    }

    public static Integer getSplitCountWithRepartition(HiveJoin join) {
        Double maxSplitSize = join.getCluster().getPlanner().getContext().unwrap(HiveAlgorithmsConf.class).getMaxSplitSize();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double averageRowSize = mq.getAverageRowSize(join);
        Double rowCount = mq.getRowCount(join);
        if (averageRowSize == null || rowCount == null) {
            return null;
        }
        Double totalSize = averageRowSize * rowCount;
        Double splitCount = totalSize / maxSplitSize;
        return splitCount.intValue();
    }

    public static Integer getSplitCountWithoutRepartition(HiveJoin join) {
        RelNode largeInput;
        if (join.getStreamingSide() == HiveJoin.MapJoinStreamingRelation.LEFT_RELATION) {
            largeInput = join.getLeft();
        } else if (join.getStreamingSide() == HiveJoin.MapJoinStreamingRelation.RIGHT_RELATION) {
            largeInput = join.getRight();
        } else {
            return null;
        }
        return RelMetadataQuery.instance().splitCount(largeInput);
    }
}

