/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.metrics.ReadWriteLockMetrics;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hive.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapLockingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LlapLockingServlet.class);
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static Configuration conf = null;

    public static void setConf(Configuration c) {
        conf = c;
    }

    public void init() throws ServletException {
        LOG.info("LlapLockingServlet initialized");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        block21: {
            try {
                if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
                    response.setStatus(403);
                    break block21;
                }
                String collString = "\"disabled\"";
                boolean statsEnabled = false;
                response.setContentType("application/json; charset=utf8");
                response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, "GET");
                response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
                response.setHeader("Cache-Control", "no-transform,public,max-age=60,s-maxage=60");
                if (null != conf && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_COLLECT_LOCK_METRICS)) {
                    collString = "\"enabled\"";
                    statsEnabled = true;
                }
                StringBuffer result = new StringBuffer();
                List sourceList = ReadWriteLockMetrics.getAllMetricsSources();
                if (null == sourceList) {
                    result.append("{\"error\":\"R/W statistics not found\"}");
                } else {
                    sourceList.sort(new ReadWriteLockMetrics.MetricsComparator());
                    boolean first = true;
                    result.append("{\"statsCollection\":");
                    result.append(collString);
                    result.append(",\"lockStats\":[");
                    if (statsEnabled) {
                        for (MetricsSource ms : sourceList) {
                            if (!first) {
                                result.append(",");
                            }
                            first = false;
                            result.append(ms);
                        }
                    }
                    result.append("]}");
                }
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse(result.toString()).getAsJsonObject();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try (PrintWriter w = response.getWriter();){
                    w.println(gson.toJson((JsonElement)json));
                }
            }
            catch (Exception e) {
                LOG.error("Exception while processing locking stats request", (Throwable)e);
                response.setStatus(500);
            }
        }
    }
}

