/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.net.Socket;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSetIpAddressProcessor<I extends TCLIService.Iface>
extends TCLIService.Processor<TCLIService.Iface> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ThriftHiveMetastore.Processor.class.getName());

    public TSetIpAddressProcessor(TCLIService.Iface iface) {
        super(iface);
    }

    public boolean process(TProtocol in, TProtocol out) throws TException {
        this.setIpAddress(in);
        this.setUserName(in);
        return super.process(in, out);
    }

    private void setUserName(TProtocol in) {
        TTransport transport = in.getTransport();
        if (transport instanceof TSaslServerTransport) {
            String userName = ((TSaslServerTransport)transport).getSaslServer().getAuthorizationID();
            SessionManager.setUserName(userName);
        }
    }

    protected void setIpAddress(TProtocol in) {
        TTransport transport = in.getTransport();
        TSocket tSocket = this.getUnderlyingSocketFromTransport(transport);
        if (tSocket != null) {
            this.setIpAddress(tSocket.getSocket());
        } else {
            LOGGER.warn("Unknown Transport, cannot determine ipAddress");
        }
    }

    private void setIpAddress(Socket socket) {
        SessionManager.setIpAddress(socket.getInetAddress().toString());
    }

    private TSocket getUnderlyingSocketFromTransport(TTransport transport) {
        while (transport != null) {
            if (transport instanceof TSaslServerTransport) {
                transport = ((TSaslServerTransport)transport).getUnderlyingTransport();
            }
            if (transport instanceof TSaslClientTransport) {
                transport = ((TSaslClientTransport)transport).getUnderlyingTransport();
            }
            if (!(transport instanceof TSocket)) continue;
            return (TSocket)transport;
        }
        return null;
    }
}

